/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.spi.commons.nodetype;

import javax.jcr.NamespaceException;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.ConstraintViolationException;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.QValue;
import org.apache.jackrabbit.spi.commons.conversion.NameException;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.conversion.NameResolver;
import org.apache.jackrabbit.spi.commons.nodetype.InvalidConstraintException;
import org.apache.jackrabbit.spi.commons.nodetype.ValueConstraint;

class ReferenceConstraint
extends ValueConstraint {
    private final Name ntName;

    static ReferenceConstraint create(String qualifiedDefinition) {
        return new ReferenceConstraint(qualifiedDefinition, NAME_FACTORY.create(qualifiedDefinition));
    }

    static ReferenceConstraint create(String definition, NameResolver resolver) throws InvalidConstraintException {
        try {
            Name name = resolver.getQName(definition);
            return new ReferenceConstraint(name.toString(), name);
        }
        catch (NameException e) {
            String msg = "Invalid name constraint: " + definition;
            log.debug(msg);
            throw new InvalidConstraintException(msg, e);
        }
        catch (NamespaceException e) {
            String msg = "Invalid name constraint: " + definition;
            log.debug(msg);
            throw new InvalidConstraintException(msg, e);
        }
    }

    private ReferenceConstraint(String qualifiedDefinition, Name ntName) {
        super(qualifiedDefinition);
        this.ntName = ntName;
    }

    public String getDefinition(NamePathResolver resolver) {
        try {
            return resolver.getJCRName(this.ntName);
        }
        catch (NamespaceException e) {
            return this.getQualifiedDefinition();
        }
    }

    void check(QValue value) throws ConstraintViolationException, RepositoryException {
        if (value == null) {
            throw new ConstraintViolationException("Null value does not satisfy the constraint '" + this.getQualifiedDefinition() + "'");
        }
        switch (value.getType()) {
            case 9: {
                log.warn("validation of REFERENCE constraint is not yet implemented");
                return;
            }
        }
        String msg = "REFERENCE constraint can not be applied to value of type: " + PropertyType.nameFromValue(value.getType());
        log.debug(msg);
        throw new RepositoryException(msg);
    }
}

