/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.util;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import javax.jcr.RepositoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoryLock {
    private static final String LOCK = ".lock";
    private static final Logger LOG = LoggerFactory.getLogger(RepositoryLock.class);
    private final File directory;
    private final File file;
    private RandomAccessFile randomAccessFile;
    private final String identifier;
    private FileLock lock;

    public RepositoryLock(String path) throws RepositoryException {
        try {
            this.directory = new File(path).getCanonicalFile();
            this.file = new File(this.directory, LOCK);
            this.identifier = (RepositoryLock.class.getName() + ":" + this.directory.getPath()).intern();
            this.lock = null;
        }
        catch (IOException e) {
            throw new RepositoryException("Unable to determine canonical path of " + path, e);
        }
    }

    public void acquire() throws RepositoryException {
        if (this.file.exists()) {
            LOG.warn("Existing lock file " + this.file + " detected." + " Repository was not shut down properly.");
        }
        try {
            this.tryLock();
        }
        catch (RepositoryException e) {
            this.closeRandomAccessFile();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryLock() throws RepositoryException {
        try {
            this.randomAccessFile = new RandomAccessFile(this.file, "rw");
            this.lock = this.randomAccessFile.getChannel().tryLock();
        }
        catch (IOException e) {
            throw new RepositoryException("Unable to create or lock file " + this.file, e);
        }
        catch (OverlappingFileLockException e) {
            throw new RepositoryException("The repository home " + this.directory + " appears to be in use" + " since the file named " + this.file.getName() + " is already locked by the current process.");
        }
        if (this.lock == null) {
            throw new RepositoryException("The repository home " + this.directory + " appears to be in use" + " since the file named " + this.file.getName() + " is locked by another process.");
        }
        String string = this.identifier;
        synchronized (string) {
            if (null != System.getProperty(this.identifier)) {
                throw new RepositoryException("The repository home " + this.directory + " appears to be" + " already locked by the current process.");
            }
            try {
                System.setProperty(this.identifier, this.identifier);
            }
            catch (SecurityException e) {
                LOG.warn("Unable to set system property: " + this.identifier, e);
            }
        }
    }

    private void closeRandomAccessFile() {
        if (this.randomAccessFile != null) {
            try {
                this.randomAccessFile.close();
            }
            catch (IOException e) {
                LOG.warn("Unable to close the random access file " + this.file, e);
            }
            this.randomAccessFile = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        if (this.lock != null) {
            try {
                FileChannel channel = this.lock.channel();
                this.lock.release();
                channel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.lock = null;
            this.closeRandomAccessFile();
        }
        if (!this.file.delete()) {
            LOG.warn("Unable to delete repository lock file");
        }
        String string = this.identifier;
        synchronized (string) {
            try {
                System.getProperties().remove(this.identifier);
            }
            catch (SecurityException e) {
                LOG.error("Unable to clear system property: " + this.identifier, e);
            }
        }
    }
}

