/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula.functions;

import org.apache.poi.hssf.record.formula.eval.AreaEval;
import org.apache.poi.hssf.record.formula.eval.BlankEval;
import org.apache.poi.hssf.record.formula.eval.Eval;
import org.apache.poi.hssf.record.formula.eval.NumericValueEval;
import org.apache.poi.hssf.record.formula.eval.Ref2DEval;
import org.apache.poi.hssf.record.formula.eval.RefEval;
import org.apache.poi.hssf.record.formula.eval.ValueEval;
import org.apache.poi.hssf.record.formula.eval.ValueEvalToNumericXlator;
import org.apache.poi.hssf.record.formula.functions.NumericFunction;

public abstract class MultiOperandNumericFunction
extends NumericFunction {
    private static final ValueEvalToNumericXlator DEFAULT_NUM_XLATOR = new ValueEvalToNumericXlator(218);
    private static final int DEFAULT_MAX_NUM_OPERANDS = 30;

    protected ValueEvalToNumericXlator getXlator() {
        return DEFAULT_NUM_XLATOR;
    }

    protected int getMaxNumOperands() {
        return 30;
    }

    protected double[] getNumberArray(Eval[] operands, int srcRow, short srcCol) {
        double[] retval = new double[30];
        int count = 0;
        if (operands.length <= this.getMaxNumOperands()) {
            int iSize = operands.length;
            for (int i = 0; i < iSize; ++i) {
                double[] temp = this.getNumberArray(operands[i], srcRow, srcCol);
                if (temp == null) {
                    retval = null;
                    break;
                }
                retval = MultiOperandNumericFunction.putInArray(retval, count, temp);
                count += temp.length;
            }
        }
        if (retval != null) {
            double[] temp = retval;
            retval = new double[count];
            System.arraycopy(temp, 0, retval, 0, count);
        }
        return retval;
    }

    protected double[] getNumberArray(Eval operand, int srcRow, short srcCol) {
        double[] retval;
        int count = 0;
        if (operand instanceof AreaEval) {
            AreaEval ae = (AreaEval)operand;
            ValueEval[] values = ae.getValues();
            retval = new double[values.length];
            int jSize = values.length;
            for (int j = 0; j < jSize; ++j) {
                Ref2DEval re = values[j] instanceof RefEval ? new Ref2DEval(null, ((RefEval)values[j]).getInnerValueEval(), true) : new Ref2DEval(null, values[j], false);
                ValueEval ve = this.singleOperandEvaluate(re, srcRow, srcCol);
                if (ve instanceof NumericValueEval) {
                    NumericValueEval nve = (NumericValueEval)ve;
                    retval = MultiOperandNumericFunction.putInArray(retval, count++, nve.getNumberValue());
                    continue;
                }
                if (ve instanceof BlankEval) continue;
                retval = null;
                break;
            }
        } else {
            retval = new double[1];
            ValueEval ve = this.singleOperandEvaluate(operand, srcRow, srcCol);
            if (ve instanceof NumericValueEval) {
                NumericValueEval nve = (NumericValueEval)ve;
                retval = MultiOperandNumericFunction.putInArray(retval, count++, nve.getNumberValue());
            } else if (!(ve instanceof BlankEval)) {
                retval = null;
            }
        }
        if (retval != null && retval.length >= 1) {
            double[] temp = retval;
            retval = new double[count];
            System.arraycopy(temp, 0, retval, 0, count);
        }
        return retval;
    }

    private static double[] putInArray(double[] arr, int pos, double d) {
        double[] tarr = arr;
        while (pos >= arr.length) {
            arr = new double[arr.length << 1];
        }
        if (tarr.length != arr.length) {
            System.arraycopy(tarr, 0, arr, 0, tarr.length);
        }
        arr[pos] = d;
        return arr;
    }

    private static double[] putInArray(double[] arr, int pos, double[] d) {
        double[] tarr = arr;
        while (pos + d.length >= arr.length) {
            arr = new double[arr.length << 1];
        }
        if (tarr.length != arr.length) {
            System.arraycopy(tarr, 0, arr, 0, tarr.length);
        }
        int iSize = d.length;
        for (int i = 0; i < iSize; ++i) {
            arr[pos + i] = d[i];
        }
        return arr;
    }

    protected static boolean areSubArraysConsistent(double[][] values) {
        boolean retval = false;
        if (values != null && values.length > 0) {
            if (values[0] != null) {
                int len = values[0].length;
                int iSize = values.length;
                for (int i = 1; i < iSize; ++i) {
                    int tlen;
                    if (values[i] != null && len == (tlen = values[i].length)) {
                        continue;
                    }
                    break;
                }
            }
        } else {
            retval = true;
        }
        return retval;
    }
}

