/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hdf.model.hdftypes;

import org.apache.poi.hdf.model.hdftypes.HDFType;
import org.apache.poi.hdf.model.hdftypes.definitions.TCAbstractType;
import org.apache.poi.util.LittleEndian;

public class TableCellDescriptor
extends TCAbstractType
implements HDFType {
    static TableCellDescriptor convertBytesToTC(byte[] array, int offset) {
        TableCellDescriptor tc = new TableCellDescriptor();
        short rgf = LittleEndian.getShort(array, offset);
        tc.setFFirstMerged((rgf & 1) > 0);
        tc.setFMerged((rgf & 2) > 0);
        tc.setFVertical((rgf & 4) > 0);
        tc.setFBackward((rgf & 8) > 0);
        tc.setFRotateFont((rgf & 0x10) > 0);
        tc.setFVertMerge((rgf & 0x20) > 0);
        tc.setFVertRestart((rgf & 0x40) > 0);
        tc.setVertAlign((byte)((rgf & 0x180) >> 7));
        short[] brcTop = new short[2];
        short[] brcLeft = new short[2];
        short[] brcBottom = new short[2];
        short[] brcRight = new short[2];
        brcTop[0] = LittleEndian.getShort(array, offset + 4);
        brcTop[1] = LittleEndian.getShort(array, offset + 6);
        brcLeft[0] = LittleEndian.getShort(array, offset + 8);
        brcLeft[1] = LittleEndian.getShort(array, offset + 10);
        brcBottom[0] = LittleEndian.getShort(array, offset + 12);
        brcBottom[1] = LittleEndian.getShort(array, offset + 14);
        brcRight[0] = LittleEndian.getShort(array, offset + 16);
        brcRight[1] = LittleEndian.getShort(array, offset + 18);
        return tc;
    }
}

