/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.RepositoryException;
import org.apache.commons.collections.iterators.EmptyIterator;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.fs.FileSystemException;
import org.apache.jackrabbit.core.fs.local.LocalFileSystem;
import org.apache.jackrabbit.core.query.lucene.CachingMultiIndexReader;
import org.apache.jackrabbit.core.query.lucene.DocNumberCache;
import org.apache.jackrabbit.core.query.lucene.FieldNames;
import org.apache.jackrabbit.core.query.lucene.IndexFormatVersion;
import org.apache.jackrabbit.core.query.lucene.IndexInfos;
import org.apache.jackrabbit.core.query.lucene.IndexListener;
import org.apache.jackrabbit.core.query.lucene.IndexMerger;
import org.apache.jackrabbit.core.query.lucene.IndexingQueue;
import org.apache.jackrabbit.core.query.lucene.IndexingQueueStore;
import org.apache.jackrabbit.core.query.lucene.NamespaceMappings;
import org.apache.jackrabbit.core.query.lucene.PersistentIndex;
import org.apache.jackrabbit.core.query.lucene.ReadOnlyIndexReader;
import org.apache.jackrabbit.core.query.lucene.Recovery;
import org.apache.jackrabbit.core.query.lucene.RedoLog;
import org.apache.jackrabbit.core.query.lucene.SearchIndex;
import org.apache.jackrabbit.core.query.lucene.Util;
import org.apache.jackrabbit.core.query.lucene.VolatileIndex;
import org.apache.jackrabbit.core.state.ChildNodeEntry;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.ItemStateManager;
import org.apache.jackrabbit.core.state.NoSuchItemStateException;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.PathFactory;
import org.apache.jackrabbit.spi.commons.name.PathFactoryImpl;
import org.apache.jackrabbit.util.Timer;
import org.apache.jackrabbit.uuid.UUID;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiIndex {
    private static final Logger log = LoggerFactory.getLogger(MultiIndex.class);
    private static final PathFactory PATH_FACTORY = PathFactoryImpl.getInstance();
    private static final String REDO_LOG = "redo.log";
    private static final String INDEXING_QUEUE_FILE = "indexing_queue.log";
    private final IndexInfos indexNames = new IndexInfos("indexes");
    private final Set deletable = new HashSet();
    private final List indexes = new ArrayList();
    private final NamespaceMappings nsMappings;
    private final File indexDir;
    private final SearchIndex handler;
    private VolatileIndex volatileIndex;
    private boolean updateInProgress = false;
    private CachingMultiIndexReader multiReader;
    private final DocNumberCache cache;
    private final Object updateMonitor = new Object();
    private boolean redoLogApplied = false;
    private long lastFlushTime;
    private final IndexMerger merger;
    private static final Timer FLUSH_TIMER = new Timer(true);
    private final Timer.Task flushTask;
    private final RedoLog redoLog;
    private IndexingQueue indexingQueue;
    private final Set excludedIDs;
    private long nextTransactionId = 0L;
    private long currentTransactionId = -1L;
    private boolean reindexing = false;
    private final IndexFormatVersion version;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MultiIndex(File indexDir, SearchIndex handler, Set excludedIDs, NamespaceMappings mapping) throws IOException {
        IndexingQueueStore store;
        this.indexDir = indexDir;
        this.handler = handler;
        this.cache = new DocNumberCache(handler.getCacheSize());
        this.redoLog = new RedoLog(new File(indexDir, REDO_LOG));
        this.excludedIDs = new HashSet(excludedIDs);
        this.nsMappings = mapping;
        if (this.indexNames.exists(indexDir)) {
            this.indexNames.read(indexDir);
        }
        this.removeDeletable();
        this.merger = new IndexMerger(this);
        this.merger.setMaxMergeDocs(handler.getMaxMergeDocs());
        this.merger.setMergeFactor(handler.getMergeFactor());
        this.merger.setMinMergeDocs(handler.getMinMergeDocs());
        try {
            LocalFileSystem fs = new LocalFileSystem();
            fs.setRoot(indexDir);
            fs.init();
            store = new IndexingQueueStore(fs, INDEXING_QUEUE_FILE);
        }
        catch (FileSystemException e) {
            throw Util.createIOException(e);
        }
        this.indexingQueue = new IndexingQueue(store);
        for (int i = 0; i < this.indexNames.size(); ++i) {
            File sub = new File(indexDir, this.indexNames.getName(i));
            if (!sub.exists()) {
                log.debug("index does not exist anymore: " + sub.getAbsolutePath());
                continue;
            }
            PersistentIndex index = new PersistentIndex(this.indexNames.getName(i), sub, handler.getTextAnalyzer(), handler.getSimilarity(), this.cache, this.indexingQueue);
            index.setMaxMergeDocs(handler.getMaxMergeDocs());
            index.setMergeFactor(handler.getMergeFactor());
            index.setMinMergeDocs(handler.getMinMergeDocs());
            index.setMaxFieldLength(handler.getMaxFieldLength());
            index.setUseCompoundFile(handler.getUseCompoundFile());
            this.indexes.add(index);
            this.merger.indexAdded(index.getName(), index.getNumDocuments());
        }
        this.resetVolatileIndex();
        CachingMultiIndexReader reader = this.getIndexReader();
        try {
            this.version = IndexFormatVersion.getVersion(reader);
        }
        finally {
            reader.release();
        }
        this.indexingQueue.initialize(this);
        this.redoLogApplied = this.redoLog.hasEntries();
        Recovery.run(this, this.redoLog);
        this.enqueueUnusedSegments();
        this.attemptDelete();
        this.merger.start();
        if (this.redoLogApplied) {
            try {
                this.merger.waitUntilIdle();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            this.flush();
        }
        this.flushTask = new Timer.Task(){

            public void run() {
                MultiIndex.this.checkIndexingQueue();
                MultiIndex.this.checkFlush();
            }
        };
        if (this.indexNames.size() > 0) {
            this.scheduleFlushTask();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int numDocs() throws IOException {
        if (this.indexNames.size() == 0) {
            return this.volatileIndex.getNumDocuments();
        }
        CachingMultiIndexReader reader = this.getIndexReader();
        try {
            int n = reader.numDocs();
            return n;
        }
        finally {
            reader.release();
        }
    }

    IndexFormatVersion getIndexFormatVersion() {
        return this.version;
    }

    void createInitialIndex(ItemStateManager stateMgr, NodeId rootId, Path rootPath) throws IOException {
        if (this.indexNames.size() == 0) {
            this.reindexing = true;
            try {
                this.executeAndLog(new Start(-1L));
                NodeState rootState = (NodeState)stateMgr.getItemState(rootId);
                this.createIndex(rootState, rootPath, stateMgr);
                this.executeAndLog(new Commit(this.getTransactionId()));
                this.scheduleFlushTask();
            }
            catch (Exception e) {
                String msg = "Error indexing workspace";
                IOException ex = new IOException(msg);
                ex.initCause(e);
                throw ex;
            }
            finally {
                this.reindexing = false;
            }
        } else {
            throw new IllegalStateException("Index already present");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void update(Iterator remove, Iterator add) throws IOException {
        Object object = this.updateMonitor;
        synchronized (object) {
            this.updateInProgress = true;
        }
        try {
            long transactionId = this.nextTransactionId++;
            this.executeAndLog(new Start(transactionId));
            boolean flush = false;
            while (remove.hasNext()) {
                this.executeAndLog(new DeleteNode(transactionId, (UUID)remove.next()));
            }
            while (add.hasNext()) {
                Document doc = (Document)add.next();
                if (doc == null) continue;
                this.executeAndLog(new AddNode(transactionId, doc));
                flush |= this.checkVolatileCommit();
            }
            this.executeAndLog(new Commit(transactionId));
            if (flush) {
                this.flush();
            }
        }
        finally {
            Object object2 = this.updateMonitor;
            synchronized (object2) {
                this.updateInProgress = false;
                this.updateMonitor.notifyAll();
                this.releaseMultiReader();
            }
        }
    }

    void addDocument(Document doc) throws IOException {
        List<Document> add = Arrays.asList(doc);
        this.update(EmptyIterator.INSTANCE, add.iterator());
    }

    void removeDocument(UUID uuid) throws IOException {
        List<UUID> remove = Arrays.asList(uuid);
        this.update(remove.iterator(), EmptyIterator.INSTANCE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized int removeAllDocuments(UUID uuid) throws IOException {
        int num;
        Object object = this.updateMonitor;
        synchronized (object) {
            this.updateInProgress = true;
        }
        try {
            Term idTerm = new Term(FieldNames.UUID, uuid.toString());
            this.executeAndLog(new Start(-1L));
            num = this.volatileIndex.removeDocument(idTerm);
            if (num > 0) {
                this.redoLog.append(new DeleteNode(this.getTransactionId(), uuid));
            }
            for (int i = 0; i < this.indexes.size(); ++i) {
                PersistentIndex index = (PersistentIndex)this.indexes.get(i);
                if (!this.indexNames.contains(index.getName())) continue;
                int removed = index.removeDocument(idTerm);
                if (removed > 0) {
                    this.redoLog.append(new DeleteNode(this.getTransactionId(), uuid));
                }
                num += removed;
            }
            this.executeAndLog(new Commit(this.getTransactionId()));
        }
        finally {
            Object object2 = this.updateMonitor;
            synchronized (object2) {
                this.updateInProgress = false;
                this.updateMonitor.notifyAll();
                this.releaseMultiReader();
            }
        }
        return num;
    }

    synchronized IndexReader[] getIndexReaders(String[] indexNames, IndexListener listener) throws IOException {
        HashSet<String> names = new HashSet<String>(Arrays.asList(indexNames));
        HashMap<ReadOnlyIndexReader, PersistentIndex> indexReaders = new HashMap<ReadOnlyIndexReader, PersistentIndex>();
        try {
            Iterator it = this.indexes.iterator();
            while (it.hasNext()) {
                PersistentIndex index = (PersistentIndex)it.next();
                if (!names.contains(index.getName())) continue;
                indexReaders.put(index.getReadOnlyIndexReader(listener), index);
            }
        }
        catch (IOException e) {
            Iterator it = indexReaders.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                ReadOnlyIndexReader reader = (ReadOnlyIndexReader)entry.getKey();
                try {
                    reader.release();
                }
                catch (IOException ex) {
                    log.warn("Exception releasing index reader: " + ex);
                }
                ((PersistentIndex)entry.getValue()).resetListener();
            }
            throw e;
        }
        return indexReaders.keySet().toArray(new IndexReader[indexReaders.size()]);
    }

    synchronized PersistentIndex getOrCreateIndex(String indexName) throws IOException {
        File sub;
        Iterator it = this.indexes.iterator();
        while (it.hasNext()) {
            PersistentIndex idx = (PersistentIndex)it.next();
            if (!idx.getName().equals(indexName)) continue;
            return idx;
        }
        if (indexName == null) {
            sub = this.newIndexFolder();
            indexName = sub.getName();
        } else {
            sub = new File(this.indexDir, indexName);
        }
        PersistentIndex index = new PersistentIndex(indexName, sub, this.handler.getTextAnalyzer(), this.handler.getSimilarity(), this.cache, this.indexingQueue);
        index.setMaxMergeDocs(this.handler.getMaxMergeDocs());
        index.setMergeFactor(this.handler.getMergeFactor());
        index.setMinMergeDocs(this.handler.getMinMergeDocs());
        index.setMaxFieldLength(this.handler.getMaxFieldLength());
        index.setUseCompoundFile(this.handler.getUseCompoundFile());
        this.indexes.add(index);
        return index;
    }

    synchronized boolean hasIndex(String indexName) {
        Iterator it = this.indexes.iterator();
        while (it.hasNext()) {
            PersistentIndex idx = (PersistentIndex)it.next();
            if (!idx.getName().equals(indexName)) continue;
            return true;
        }
        return new File(this.indexDir, indexName).exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void replaceIndexes(String[] obsoleteIndexes, PersistentIndex index, Collection deleted) throws IOException {
        MultiIndex multiIndex = this;
        synchronized (multiIndex) {
            Object object = this.updateMonitor;
            synchronized (object) {
                this.updateInProgress = true;
            }
            try {
                if (!this.reindexing) {
                    this.executeAndLog(new Start(-2L));
                }
                HashSet<String> names = new HashSet<String>(Arrays.asList(obsoleteIndexes));
                Iterator it = names.iterator();
                while (it.hasNext()) {
                    String indexName = (String)it.next();
                    if (!this.indexNames.contains(indexName)) continue;
                    this.executeAndLog(new DeleteIndex(this.getTransactionId(), indexName));
                }
                this.executeAndLog(new CreateIndex(this.getTransactionId(), index.getName()));
                this.executeAndLog(new AddIndex(this.getTransactionId(), index.getName()));
                it = deleted.iterator();
                while (it.hasNext()) {
                    Term id = (Term)it.next();
                    index.removeDocument(id);
                }
                index.commit();
                if (!this.reindexing) {
                    this.executeAndLog(new Commit(this.getTransactionId()));
                }
            }
            finally {
                object = this.updateMonitor;
                synchronized (object) {
                    this.updateInProgress = false;
                    this.updateMonitor.notifyAll();
                    this.releaseMultiReader();
                }
            }
        }
        if (this.reindexing) {
            this.attemptDelete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CachingMultiIndexReader getIndexReader() throws IOException {
        Object object = this.updateMonitor;
        synchronized (object) {
            if (this.multiReader != null) {
                this.multiReader.acquire();
                return this.multiReader;
            }
            while (this.updateInProgress) {
                try {
                    this.updateMonitor.wait();
                }
                catch (InterruptedException e) {
                    throw new IOException("Interrupted while waiting to aquire reader");
                }
            }
            if (this.multiReader == null) {
                ArrayList<ReadOnlyIndexReader> readerList = new ArrayList<ReadOnlyIndexReader>();
                for (int i = 0; i < this.indexes.size(); ++i) {
                    PersistentIndex pIdx = (PersistentIndex)this.indexes.get(i);
                    if (!this.indexNames.contains(pIdx.getName())) continue;
                    readerList.add(pIdx.getReadOnlyIndexReader());
                }
                readerList.add(this.volatileIndex.getReadOnlyIndexReader());
                ReadOnlyIndexReader[] readers = readerList.toArray(new ReadOnlyIndexReader[readerList.size()]);
                this.multiReader = new CachingMultiIndexReader(readers, this.cache);
            }
            this.multiReader.acquire();
            return this.multiReader;
        }
    }

    VolatileIndex getVolatileIndex() {
        return this.volatileIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() {
        this.merger.dispose();
        MultiIndex multiIndex = this;
        synchronized (multiIndex) {
            this.flushTask.cancel();
            try {
                this.releaseMultiReader();
            }
            catch (IOException e) {
                log.error("Exception while closing search index.", e);
            }
            try {
                this.flush();
            }
            catch (IOException e) {
                log.error("Exception while closing search index.", e);
            }
            this.volatileIndex.close();
            for (int i = 0; i < this.indexes.size(); ++i) {
                ((PersistentIndex)this.indexes.get(i)).close();
            }
            this.indexingQueue.close();
        }
    }

    NamespaceMappings getNamespaceMappings() {
        return this.nsMappings;
    }

    IndexingQueue getIndexingQueue() {
        return this.indexingQueue;
    }

    Document createDocument(NodeState node) throws RepositoryException {
        return this.handler.createDocument(node, this.nsMappings, this.version);
    }

    Document createDocument(NodeId id) throws RepositoryException {
        try {
            NodeState state = (NodeState)this.handler.getContext().getItemStateManager().getItemState(id);
            return this.createDocument(state);
        }
        catch (NoSuchItemStateException e) {
            throw new RepositoryException("Node " + id + " does not exist", e);
        }
        catch (ItemStateException e) {
            throw new RepositoryException("Error retrieving node: " + id, e);
        }
    }

    boolean getRedoLogApplied() {
        return this.redoLogApplied;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void deleteIndex(PersistentIndex index) {
        this.indexes.remove(index);
        this.indexNames.removeName(index.getName());
        Set set = this.deletable;
        synchronized (set) {
            log.debug("Moved " + index.getName() + " to deletable");
            this.deletable.add(index.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flush() throws IOException {
        MultiIndex multiIndex = this;
        synchronized (multiIndex) {
            this.executeAndLog(new Start(-1L));
            this.commitVolatileIndex();
            for (int i = this.indexes.size() - 1; i >= 0; --i) {
                PersistentIndex index = (PersistentIndex)this.indexes.get(i);
                if (!this.indexNames.contains(index.getName())) continue;
                index.commit();
                if (index.getNumDocuments() != 0) continue;
                this.executeAndLog(new DeleteIndex(this.getTransactionId(), index.getName()));
            }
            this.executeAndLog(new Commit(this.getTransactionId()));
            this.indexNames.write(this.indexDir);
            this.redoLog.clear();
            this.lastFlushTime = System.currentTimeMillis();
        }
        this.attemptDelete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseMultiReader() throws IOException {
        if (this.multiReader != null) {
            try {
                this.multiReader.release();
            }
            finally {
                this.multiReader = null;
            }
        }
    }

    private void enqueueUnusedSegments() {
        File[] segmentDirs = this.indexDir.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isDirectory() && pathname.getName().startsWith("_");
            }
        });
        for (int i = 0; i < segmentDirs.length; ++i) {
            String name = segmentDirs[i].getName();
            if (this.indexNames.contains(name)) continue;
            this.deletable.add(name);
        }
    }

    private void scheduleFlushTask() {
        this.lastFlushTime = System.currentTimeMillis();
        FLUSH_TIMER.schedule(this.flushTask, 0L, 1000L);
    }

    private void resetVolatileIndex() throws IOException {
        this.volatileIndex = new VolatileIndex(this.handler.getTextAnalyzer(), this.handler.getSimilarity(), this.indexingQueue);
        this.volatileIndex.setUseCompoundFile(this.handler.getUseCompoundFile());
        this.volatileIndex.setMaxFieldLength(this.handler.getMaxFieldLength());
        this.volatileIndex.setBufferSize(this.handler.getBufferSize());
    }

    private long getTransactionId() {
        return this.currentTransactionId;
    }

    private Action executeAndLog(Action a) throws IOException {
        a.execute(this);
        this.redoLog.append(a);
        if (a.getType() == 3 || a.getType() == 6) {
            this.redoLog.flush();
        }
        return a;
    }

    private boolean checkVolatileCommit() throws IOException {
        if (this.volatileIndex.getNumDocuments() >= this.handler.getMinMergeDocs()) {
            this.commitVolatileIndex();
            return true;
        }
        return false;
    }

    private void commitVolatileIndex() throws IOException {
        if (this.volatileIndex.getNumDocuments() > 0) {
            long time = System.currentTimeMillis();
            CreateIndex create = new CreateIndex(this.getTransactionId(), null);
            this.executeAndLog(create);
            this.executeAndLog(new VolatileCommit(this.getTransactionId(), create.getIndexName()));
            AddIndex add = new AddIndex(this.getTransactionId(), create.getIndexName());
            this.executeAndLog(add);
            this.resetVolatileIndex();
            time = System.currentTimeMillis() - time;
            log.debug("Committed in-memory index in " + time + "ms.");
        }
    }

    private void createIndex(NodeState node, Path path, ItemStateManager stateMgr) throws IOException, ItemStateException, RepositoryException {
        NodeId id = node.getNodeId();
        if (this.excludedIDs.contains(id)) {
            return;
        }
        this.executeAndLog(new AddNode(this.getTransactionId(), id.getUUID()));
        this.checkVolatileCommit();
        List children = node.getChildNodeEntries();
        Iterator it = children.iterator();
        while (it.hasNext()) {
            ChildNodeEntry child = (ChildNodeEntry)it.next();
            Path childPath = PATH_FACTORY.create(path, child.getName(), child.getIndex(), false);
            NodeState childState = null;
            try {
                childState = (NodeState)stateMgr.getItemState(child.getId());
            }
            catch (NoSuchItemStateException e) {
                this.handler.getOnWorkspaceInconsistencyHandler().handleMissingChildNode(e, this.handler, path, node, child);
            }
            if (childState == null) continue;
            this.createIndex(childState, childPath, stateMgr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void attemptDelete() {
        Set set = this.deletable;
        synchronized (set) {
            Iterator it = this.deletable.iterator();
            while (it.hasNext()) {
                String indexName = (String)it.next();
                File dir = new File(this.indexDir, indexName);
                if (this.deleteIndex(dir)) {
                    it.remove();
                    continue;
                }
                log.info("Unable to delete obsolete index: " + indexName);
            }
        }
    }

    private void removeDeletable() {
        File deletable = new File(this.indexDir, "deletable");
        if (deletable.exists()) {
            deletable.delete();
        }
    }

    private boolean deleteIndex(File directory) {
        if (!directory.exists()) {
            return true;
        }
        File[] files = directory.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].delete()) continue;
            return false;
        }
        return directory.delete();
    }

    private File newIndexFolder() throws IOException {
        File sub;
        while ((sub = new File(this.indexDir, this.indexNames.newName())).exists()) {
        }
        if (!sub.mkdir()) {
            throw new IOException("Unable to create directory: " + sub.getAbsolutePath());
        }
        return sub;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void checkFlush() {
        block15: {
            long idleTime = System.currentTimeMillis() - this.lastFlushTime;
            if (this.handler.getVolatileIdleTime() > 0 && idleTime > (long)(this.handler.getVolatileIdleTime() * 1000)) {
                try {
                    if (!this.redoLog.hasEntries()) break block15;
                    log.debug("Flushing index after being idle for " + idleTime + " ms.");
                    Object object = this.updateMonitor;
                    synchronized (object) {
                        this.updateInProgress = true;
                    }
                    try {
                        this.flush();
                    }
                    finally {
                        object = this.updateMonitor;
                        synchronized (object) {
                            this.updateInProgress = false;
                            this.updateMonitor.notifyAll();
                            this.releaseMultiReader();
                        }
                    }
                }
                catch (IOException e) {
                    log.error("Unable to commit volatile index", e);
                }
            }
        }
    }

    private synchronized void checkIndexingQueue() {
        Document[] docs = this.indexingQueue.getFinishedDocuments();
        HashMap<UUID, Document> finished = new HashMap<UUID, Document>();
        for (int i = 0; i < docs.length; ++i) {
            String uuid = docs[i].get(FieldNames.UUID);
            finished.put(UUID.fromString(uuid), docs[i]);
        }
        if (!finished.isEmpty()) {
            log.debug("updating index with {} nodes from indexing queue.", new Long(finished.size()));
            Iterator it = finished.keySet().iterator();
            while (it.hasNext()) {
                this.indexingQueue.removeDocument(it.next().toString());
            }
            try {
                this.update(finished.keySet().iterator(), finished.values().iterator());
            }
            catch (IOException e) {
                log.warn("Failed to update index with deferred text extraction", e);
            }
        }
    }

    private static class VolatileCommit
    extends Action {
        private final String targetIndex;

        VolatileCommit(long transactionId, String targetIndex) {
            super(transactionId, 4);
            this.targetIndex = targetIndex;
        }

        static VolatileCommit fromString(long transactionId, String arguments) {
            return new VolatileCommit(transactionId, arguments);
        }

        public void execute(MultiIndex index) throws IOException {
            VolatileIndex volatileIndex = index.getVolatileIndex();
            PersistentIndex persistentIndex = index.getOrCreateIndex(this.targetIndex);
            persistentIndex.copyIndex(volatileIndex);
            index.resetVolatileIndex();
        }

        public String toString() {
            StringBuffer logLine = new StringBuffer();
            logLine.append(Long.toString(this.getTransactionId()));
            logLine.append(' ');
            logLine.append("VOL_COM");
            logLine.append(' ');
            logLine.append(this.targetIndex);
            return logLine.toString();
        }
    }

    private static class Start
    extends Action {
        Start(long transactionId) {
            super(transactionId, 0);
        }

        static Start fromString(long transactionId, String arguments) {
            return new Start(transactionId);
        }

        public void execute(MultiIndex index) throws IOException {
            index.currentTransactionId = this.getTransactionId();
        }

        public String toString() {
            return Long.toString(this.getTransactionId()) + ' ' + "STR";
        }
    }

    private static class DeleteNode
    extends Action {
        private static final int ENTRY_LENGTH = Long.toString(Long.MAX_VALUE).length() + "DEL".length() + 36 + 2;
        private final UUID uuid;

        DeleteNode(long transactionId, UUID uuid) {
            super(transactionId, 2);
            this.uuid = uuid;
        }

        static DeleteNode fromString(long transactionId, String arguments) {
            if (arguments.length() != 36) {
                throw new IllegalArgumentException("arguments is not a uuid");
            }
            return new DeleteNode(transactionId, UUID.fromString(arguments));
        }

        public void execute(MultiIndex index) throws IOException {
            String uuidString = this.uuid.toString();
            Document doc = index.indexingQueue.removeDocument(uuidString);
            if (doc != null) {
                Util.disposeDocument(doc);
            }
            Term idTerm = new Term(FieldNames.UUID, uuidString);
            int num = index.volatileIndex.removeDocument(idTerm);
            if (num == 0) {
                for (int i = index.indexes.size() - 1; i >= 0; --i) {
                    PersistentIndex idx = (PersistentIndex)index.indexes.get(i);
                    if (!index.indexNames.contains(idx.getName()) || (num = idx.removeDocument(idTerm)) <= 0) continue;
                    return;
                }
            }
        }

        public String toString() {
            StringBuffer logLine = new StringBuffer(ENTRY_LENGTH);
            logLine.append(Long.toString(this.getTransactionId()));
            logLine.append(' ');
            logLine.append("DEL");
            logLine.append(' ');
            logLine.append(this.uuid);
            return logLine.toString();
        }
    }

    private static class DeleteIndex
    extends Action {
        private String indexName;

        DeleteIndex(long transactionId, String indexName) {
            super(transactionId, 7);
            this.indexName = indexName;
        }

        static DeleteIndex fromString(long transactionId, String arguments) {
            return new DeleteIndex(transactionId, arguments);
        }

        public void execute(MultiIndex index) throws IOException {
            Iterator it = index.indexes.iterator();
            while (it.hasNext()) {
                PersistentIndex idx = (PersistentIndex)it.next();
                if (!idx.getName().equals(this.indexName)) continue;
                idx.close();
                index.deleteIndex(idx);
                break;
            }
        }

        public String toString() {
            StringBuffer logLine = new StringBuffer();
            logLine.append(Long.toString(this.getTransactionId()));
            logLine.append(' ');
            logLine.append("DEL_IDX");
            logLine.append(' ');
            logLine.append(this.indexName);
            return logLine.toString();
        }
    }

    private static class CreateIndex
    extends Action {
        private String indexName;

        CreateIndex(long transactionId, String indexName) {
            super(transactionId, 5);
            this.indexName = indexName;
        }

        static CreateIndex fromString(long transactionId, String arguments) {
            return new CreateIndex(transactionId, arguments);
        }

        public void execute(MultiIndex index) throws IOException {
            PersistentIndex idx = index.getOrCreateIndex(this.indexName);
            this.indexName = idx.getName();
        }

        public void undo(MultiIndex index) throws IOException {
            if (index.hasIndex(this.indexName)) {
                PersistentIndex idx = index.getOrCreateIndex(this.indexName);
                idx.close();
                index.deleteIndex(idx);
            }
        }

        public String toString() {
            StringBuffer logLine = new StringBuffer();
            logLine.append(Long.toString(this.getTransactionId()));
            logLine.append(' ');
            logLine.append("CRE_IDX");
            logLine.append(' ');
            logLine.append(this.indexName);
            return logLine.toString();
        }

        String getIndexName() {
            return this.indexName;
        }
    }

    private static class Commit
    extends Action {
        Commit(long transactionId) {
            super(transactionId, 3);
        }

        static Commit fromString(long transactionId, String arguments) {
            return new Commit(transactionId);
        }

        public void execute(MultiIndex index) throws IOException {
            index.lastFlushTime = System.currentTimeMillis();
        }

        public String toString() {
            return Long.toString(this.getTransactionId()) + ' ' + "COM";
        }
    }

    private static class AddNode
    extends Action {
        private static final int ENTRY_LENGTH = Long.toString(Long.MAX_VALUE).length() + "ADD".length() + 36 + 2;
        private final UUID uuid;
        private Document doc;

        AddNode(long transactionId, UUID uuid) {
            super(transactionId, 1);
            this.uuid = uuid;
        }

        AddNode(long transactionId, Document doc) {
            this(transactionId, UUID.fromString(doc.get(FieldNames.UUID)));
            this.doc = doc;
        }

        static AddNode fromString(long transactionId, String arguments) throws IllegalArgumentException {
            if (arguments.length() != 36) {
                throw new IllegalArgumentException("arguments is not a uuid");
            }
            return new AddNode(transactionId, UUID.fromString(arguments));
        }

        public void execute(MultiIndex index) throws IOException {
            if (this.doc == null) {
                try {
                    this.doc = index.createDocument(new NodeId(this.uuid));
                }
                catch (RepositoryException e) {
                    log.debug(e.getMessage());
                }
            }
            if (this.doc != null) {
                index.volatileIndex.addDocuments(new Document[]{this.doc});
            }
        }

        public String toString() {
            StringBuffer logLine = new StringBuffer(ENTRY_LENGTH);
            logLine.append(Long.toString(this.getTransactionId()));
            logLine.append(' ');
            logLine.append("ADD");
            logLine.append(' ');
            logLine.append(this.uuid);
            return logLine.toString();
        }
    }

    private static class AddIndex
    extends Action {
        private String indexName;

        AddIndex(long transactionId, String indexName) {
            super(transactionId, 6);
            this.indexName = indexName;
        }

        static AddIndex fromString(long transactionId, String arguments) {
            return new AddIndex(transactionId, arguments);
        }

        public void execute(MultiIndex index) throws IOException {
            PersistentIndex idx = index.getOrCreateIndex(this.indexName);
            if (!index.indexNames.contains(this.indexName)) {
                index.indexNames.addName(this.indexName);
                index.merger.indexAdded(this.indexName, idx.getNumDocuments());
            }
        }

        public String toString() {
            StringBuffer logLine = new StringBuffer();
            logLine.append(Long.toString(this.getTransactionId()));
            logLine.append(' ');
            logLine.append("ADD_IDX");
            logLine.append(' ');
            logLine.append(this.indexName);
            return logLine.toString();
        }
    }

    public static abstract class Action {
        static final String START = "STR";
        public static final int TYPE_START = 0;
        static final String ADD_NODE = "ADD";
        public static final int TYPE_ADD_NODE = 1;
        static final String DELETE_NODE = "DEL";
        public static final int TYPE_DELETE_NODE = 2;
        static final String COMMIT = "COM";
        public static final int TYPE_COMMIT = 3;
        static final String VOLATILE_COMMIT = "VOL_COM";
        public static final int TYPE_VOLATILE_COMMIT = 4;
        static final String CREATE_INDEX = "CRE_IDX";
        public static final int TYPE_CREATE_INDEX = 5;
        static final String ADD_INDEX = "ADD_IDX";
        public static final int TYPE_ADD_INDEX = 6;
        static final String DELETE_INDEX = "DEL_IDX";
        public static final int TYPE_DELETE_INDEX = 7;
        static final long INTERNAL_TRANSACTION = -1L;
        static final long INTERNAL_TRANS_REPL_INDEXES = -2L;
        private final long transactionId;
        private final int type;

        Action(long transactionId, int type) {
            this.transactionId = transactionId;
            this.type = type;
        }

        long getTransactionId() {
            return this.transactionId;
        }

        int getType() {
            return this.type;
        }

        public abstract void execute(MultiIndex var1) throws IOException;

        public void undo(MultiIndex index) throws IOException {
        }

        public abstract String toString();

        static Action fromString(String line) throws IllegalArgumentException {
            Action a;
            long transactionId;
            int endTransIdx = line.indexOf(32);
            if (endTransIdx == -1) {
                throw new IllegalArgumentException(line);
            }
            try {
                transactionId = Long.parseLong(line.substring(0, endTransIdx));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(line);
            }
            int endActionIdx = line.indexOf(32, endTransIdx + 1);
            if (endActionIdx == -1) {
                endActionIdx = line.length();
            }
            String actionLabel = line.substring(endTransIdx + 1, endActionIdx);
            String arguments = "";
            if (endActionIdx + 1 <= line.length()) {
                arguments = line.substring(endActionIdx + 1);
            }
            if (actionLabel.equals(ADD_NODE)) {
                a = AddNode.fromString(transactionId, arguments);
            } else if (actionLabel.equals(ADD_INDEX)) {
                a = AddIndex.fromString(transactionId, arguments);
            } else if (actionLabel.equals(COMMIT)) {
                a = Commit.fromString(transactionId, arguments);
            } else if (actionLabel.equals(CREATE_INDEX)) {
                a = CreateIndex.fromString(transactionId, arguments);
            } else if (actionLabel.equals(DELETE_INDEX)) {
                a = DeleteIndex.fromString(transactionId, arguments);
            } else if (actionLabel.equals(DELETE_NODE)) {
                a = DeleteNode.fromString(transactionId, arguments);
            } else if (actionLabel.equals(START)) {
                a = Start.fromString(transactionId, arguments);
            } else if (actionLabel.equals(VOLATILE_COMMIT)) {
                a = VolatileCommit.fromString(transactionId, arguments);
            } else {
                throw new IllegalArgumentException(line);
            }
            return a;
        }
    }
}

