/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.IOException;
import java.util.BitSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.query.lucene.AbstractQueryHits;
import org.apache.jackrabbit.core.query.lucene.ChildNodesQueryHits;
import org.apache.jackrabbit.core.query.lucene.HierarchyResolver;
import org.apache.jackrabbit.core.query.lucene.JackrabbitIndexSearcher;
import org.apache.jackrabbit.core.query.lucene.JackrabbitQuery;
import org.apache.jackrabbit.core.query.lucene.MatchAllDocsQuery;
import org.apache.jackrabbit.core.query.lucene.NodeTraversingQueryHits;
import org.apache.jackrabbit.core.query.lucene.QueryHits;
import org.apache.jackrabbit.core.query.lucene.ScoreNode;
import org.apache.jackrabbit.core.query.lucene.Util;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.HitCollector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.Weight;

class DescendantSelfAxisQuery
extends Query
implements JackrabbitQuery {
    private final Query contextQuery;
    private Scorer contextScorer;
    private final Query subQuery;
    private final int minLevels;
    private Scorer subScorer;

    public DescendantSelfAxisQuery(Query context, boolean includeSelf) {
        this(context, (Query)new MatchAllDocsQuery(), includeSelf);
    }

    public DescendantSelfAxisQuery(Query context, Query sub) {
        this(context, sub, true);
    }

    public DescendantSelfAxisQuery(Query context, Query sub, boolean includeSelf) {
        this(context, sub, includeSelf ? 0 : 1);
    }

    public DescendantSelfAxisQuery(Query context, Query sub, int minLevels) {
        this.contextQuery = context;
        this.subQuery = sub;
        this.minLevels = minLevels;
    }

    Query getContextQuery() {
        return this.contextQuery;
    }

    boolean subQueryMatchesAll() {
        return this.subQuery instanceof MatchAllDocsQuery;
    }

    int getMinLevels() {
        return this.minLevels;
    }

    protected Weight createWeight(Searcher searcher) {
        return new DescendantSelfAxisWeight(searcher);
    }

    public String toString(String field) {
        return "DescendantSelfAxisQuery";
    }

    public void extractTerms(Set terms) {
        this.contextQuery.extractTerms(terms);
        this.subQuery.extractTerms(terms);
    }

    public Query rewrite(IndexReader reader) throws IOException {
        DescendantSelfAxisQuery dsaq;
        Query cQuery = this.contextQuery.rewrite(reader);
        Query sQuery = this.subQuery.rewrite(reader);
        if (this.contextQuery instanceof DescendantSelfAxisQuery && (dsaq = (DescendantSelfAxisQuery)this.contextQuery).subQueryMatchesAll()) {
            return new DescendantSelfAxisQuery(dsaq.getContextQuery(), sQuery, dsaq.getMinLevels() + this.getMinLevels()).rewrite(reader);
        }
        if (cQuery == this.contextQuery && sQuery == this.subQuery) {
            return this;
        }
        return new DescendantSelfAxisQuery(cQuery, sQuery, this.minLevels);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueryHits execute(JackrabbitIndexSearcher searcher, final SessionImpl session, Sort sort) throws IOException {
        if (sort.getSort().length == 0 && this.subQueryMatchesAll()) {
            TreeMap<String, ScoreNode> startingPoints = new TreeMap<String, ScoreNode>();
            QueryHits result = searcher.evaluate(this.getContextQuery(), sort);
            try {
                for (int i = 2; i <= this.getMinLevels(); ++i) {
                    result = new ChildNodesQueryHits(result, session);
                }
                try {
                    ScoreNode sn;
                    while ((sn = result.nextScoreNode()) != null) {
                        NodeImpl node = session.getNodeById(sn.getNodeId());
                        startingPoints.put(node.getPath(), sn);
                    }
                }
                catch (RepositoryException e) {
                    throw Util.createIOException(e);
                }
            }
            finally {
                result.close();
            }
            String previousPath = null;
            Iterator it = startingPoints.keySet().iterator();
            while (it.hasNext()) {
                String path = (String)it.next();
                if (previousPath != null && path.startsWith(previousPath)) {
                    it.remove();
                    continue;
                }
                previousPath = path;
            }
            final Iterator scoreNodes = startingPoints.values().iterator();
            return new AbstractQueryHits(){
                private NodeTraversingQueryHits currentTraversal;
                {
                    this.fetchNextTraversal();
                }

                public void close() throws IOException {
                    if (this.currentTraversal != null) {
                        this.currentTraversal.close();
                    }
                }

                public ScoreNode nextScoreNode() throws IOException {
                    while (this.currentTraversal != null) {
                        ScoreNode sn = this.currentTraversal.nextScoreNode();
                        if (sn != null) {
                            return sn;
                        }
                        this.fetchNextTraversal();
                    }
                    return null;
                }

                private void fetchNextTraversal() throws IOException {
                    if (this.currentTraversal != null) {
                        this.currentTraversal.close();
                    }
                    if (scoreNodes.hasNext()) {
                        ScoreNode sn = (ScoreNode)scoreNodes.next();
                        try {
                            NodeImpl node = session.getNodeById(sn.getNodeId());
                            this.currentTraversal = new NodeTraversingQueryHits(node, DescendantSelfAxisQuery.this.getMinLevels() == 0);
                        }
                        catch (RepositoryException e) {
                            throw Util.createIOException(e);
                        }
                    } else {
                        this.currentTraversal = null;
                    }
                }
            };
        }
        return null;
    }

    private class DescendantSelfAxisScorer
    extends Scorer {
        private final HierarchyResolver hResolver;
        private final BitSet contextHits;
        private boolean contextHitsCalculated;
        private int[] ancestorDocs;

        protected DescendantSelfAxisScorer(Similarity similarity, IndexReader reader, HierarchyResolver hResolver) {
            super(similarity);
            this.contextHitsCalculated = false;
            this.ancestorDocs = new int[2];
            this.hResolver = hResolver;
            this.contextHits = new BitSet(reader.maxDoc());
        }

        public boolean next() throws IOException {
            this.collectContextHits();
            if (!DescendantSelfAxisQuery.this.subScorer.next() || this.contextHits.isEmpty()) {
                return false;
            }
            int nextDoc = DescendantSelfAxisQuery.this.subScorer.doc();
            while (nextDoc > -1) {
                if (this.isValid(nextDoc)) {
                    return true;
                }
                nextDoc = DescendantSelfAxisQuery.this.subScorer.next() ? DescendantSelfAxisQuery.this.subScorer.doc() : -1;
            }
            return false;
        }

        public int doc() {
            return DescendantSelfAxisQuery.this.subScorer.doc();
        }

        public float score() throws IOException {
            return DescendantSelfAxisQuery.this.subScorer.score();
        }

        public boolean skipTo(int target) throws IOException {
            boolean match = DescendantSelfAxisQuery.this.subScorer.skipTo(target);
            if (match) {
                this.collectContextHits();
                if (this.isValid(DescendantSelfAxisQuery.this.subScorer.doc())) {
                    return true;
                }
                return this.next();
            }
            return false;
        }

        private void collectContextHits() throws IOException {
            if (!this.contextHitsCalculated) {
                DescendantSelfAxisQuery.this.contextScorer.score(new HitCollector(){

                    public void collect(int doc, float score) {
                        DescendantSelfAxisScorer.this.contextHits.set(doc);
                    }
                });
                this.contextHitsCalculated = true;
            }
        }

        public Explanation explain(int doc) throws IOException {
            throw new UnsupportedOperationException();
        }

        private boolean isValid(int doc) throws IOException {
            if (DescendantSelfAxisQuery.this.minLevels == 0 && this.contextHits.get(doc)) {
                return true;
            }
            int parentDoc = this.hResolver.getParent(doc);
            int ancestorCount = 0;
            this.ancestorDocs[ancestorCount++] = parentDoc;
            while (!(parentDoc == -1 || this.contextHits.get(parentDoc) && ancestorCount >= DescendantSelfAxisQuery.this.minLevels)) {
                parentDoc = this.hResolver.getParent(parentDoc);
                if (ancestorCount == this.ancestorDocs.length) {
                    int[] copy = new int[this.ancestorDocs.length * 2];
                    System.arraycopy(this.ancestorDocs, 0, copy, 0, this.ancestorDocs.length);
                    this.ancestorDocs = copy;
                }
                this.ancestorDocs[ancestorCount++] = parentDoc;
            }
            if (parentDoc != -1) {
                for (int i = 0; i < ancestorCount; ++i) {
                    this.contextHits.set(this.ancestorDocs[i]);
                }
                return true;
            }
            return false;
        }
    }

    private class DescendantSelfAxisWeight
    implements Weight {
        private final Searcher searcher;

        private DescendantSelfAxisWeight(Searcher searcher) {
            this.searcher = searcher;
        }

        public Query getQuery() {
            return DescendantSelfAxisQuery.this;
        }

        public float getValue() {
            return 1.0f;
        }

        public float sumOfSquaredWeights() throws IOException {
            return 1.0f;
        }

        public void normalize(float norm) {
        }

        public Scorer scorer(IndexReader reader) throws IOException {
            DescendantSelfAxisQuery.this.contextScorer = DescendantSelfAxisQuery.this.contextQuery.weight(this.searcher).scorer(reader);
            DescendantSelfAxisQuery.this.subScorer = DescendantSelfAxisQuery.this.subQuery.weight(this.searcher).scorer(reader);
            HierarchyResolver resolver = (HierarchyResolver)((Object)reader);
            return new DescendantSelfAxisScorer(this.searcher.getSimilarity(), reader, resolver);
        }

        public Explanation explain(IndexReader reader, int doc) throws IOException {
            return new Explanation();
        }
    }
}

