/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.data.db;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.data.DataIdentifier;
import org.apache.jackrabbit.core.data.DataRecord;
import org.apache.jackrabbit.core.data.DataStore;
import org.apache.jackrabbit.core.data.DataStoreException;
import org.apache.jackrabbit.core.data.db.DatabaseHelper;
import org.apache.jackrabbit.core.data.db.DbDataRecord;
import org.apache.jackrabbit.core.data.db.DbInputStream;
import org.apache.jackrabbit.core.data.db.Pool;
import org.apache.jackrabbit.core.data.db.TempFileInputStream;
import org.apache.jackrabbit.core.persistence.bundle.util.ConnectionRecoveryManager;
import org.apache.jackrabbit.core.persistence.bundle.util.TrackingInputStream;
import org.apache.jackrabbit.util.Text;
import org.apache.jackrabbit.uuid.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbDataStore
implements DataStore {
    public static final int DEFAULT_MIN_RECORD_LENGTH = 100;
    public static final int DEFAULT_MAX_CONNECTIONS = 3;
    public static final String STORE_TEMP_FILE = "tempFile";
    public static final String STORE_SIZE_MINUS_ONE = "-1";
    public static final String STORE_SIZE_MAX = "max";
    protected static final String DIGEST = "SHA-1";
    protected static final String TEMP_PREFIX = "TEMP_";
    private static Logger log = LoggerFactory.getLogger(DbDataStore.class);
    protected long minModifiedDate;
    protected String url;
    protected String driver;
    protected String user;
    protected String password;
    protected String databaseType;
    protected int minRecordLength = 100;
    protected int maxConnections = 3;
    protected Pool connectionPool;
    protected String tablePrefix = "";
    protected String tableSQL = "DATASTORE";
    protected String createTableSQL = "CREATE TABLE ${tablePrefix}${table}(ID VARCHAR(255) PRIMARY KEY, LENGTH BIGINT, LAST_MODIFIED BIGINT, DATA BLOB)";
    protected String insertTempSQL = "INSERT INTO ${tablePrefix}${table} VALUES(?, 0, ?, NULL)";
    protected String updateDataSQL = "UPDATE ${tablePrefix}${table} SET DATA=? WHERE ID=?";
    protected String updateLastModifiedSQL = "UPDATE ${tablePrefix}${table} SET LAST_MODIFIED=? WHERE ID=? AND LAST_MODIFIED<?";
    protected String updateSQL = "UPDATE ${tablePrefix}${table} SET ID=?, LENGTH=?, LAST_MODIFIED=? WHERE ID=? AND NOT EXISTS(SELECT ID FROM ${tablePrefix}${table} WHERE ID=?)";
    protected String deleteSQL = "DELETE FROM ${tablePrefix}${table} WHERE ID=?";
    protected String deleteOlderSQL = "DELETE FROM ${tablePrefix}${table} WHERE LAST_MODIFIED<?";
    protected String selectMetaSQL = "SELECT LENGTH, LAST_MODIFIED FROM ${tablePrefix}${table} WHERE ID=?";
    protected String selectAllSQL = "SELECT ID FROM ${tablePrefix}${table}";
    protected String selectDataSQL = "SELECT ID, DATA FROM ${tablePrefix}${table} WHERE ID=?";
    protected String storeStream = "tempFile";
    protected boolean copyWhenReading = true;
    protected Map inUse = Collections.synchronizedMap(new WeakHashMap());
    protected List temporaryInUse = Collections.synchronizedList(new ArrayList());

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DataRecord addRecord(InputStream stream) throws DataStoreException {
        DbDataRecord dbDataRecord;
        String tempId;
        ConnectionRecoveryManager conn;
        TempFileInputStream fileInput;
        ResultSet rs;
        block24: {
            DbDataRecord record;
            ConnectionRecoveryManager.StreamWrapper wrapper;
            long now;
            rs = null;
            fileInput = null;
            conn = this.getConnection();
            String id = null;
            tempId = null;
            for (int i = 0; i < 20; ++i) {
                block23: {
                    now = System.currentTimeMillis();
                    id = UUID.randomUUID().toString();
                    tempId = TEMP_PREFIX + id;
                    PreparedStatement prep = conn.executeStmt(this.selectMetaSQL, new Object[]{tempId});
                    rs = prep.getResultSet();
                    if (!rs.next()) break block23;
                    DatabaseHelper.closeSilently(rs);
                    continue;
                }
                try {
                    conn.executeStmt(this.insertTempSQL, new Object[]{tempId, new Long(now)});
                }
                catch (Exception e) {
                    try {
                        throw this.convert("Can not insert new record", e);
                    }
                    catch (Throwable throwable) {
                        DatabaseHelper.closeSilently(rs);
                        throw throwable;
                    }
                }
                DatabaseHelper.closeSilently(rs);
                break;
            }
            if (id == null) {
                String msg = "Can not create new record";
                log.error(msg);
                throw new DataStoreException(msg);
            }
            this.temporaryInUse.add(tempId);
            MessageDigest digest = this.getDigest();
            DigestInputStream dIn = new DigestInputStream(stream, digest);
            TrackingInputStream in = new TrackingInputStream(dIn);
            if (STORE_SIZE_MINUS_ONE.equals(this.storeStream)) {
                wrapper = new ConnectionRecoveryManager.StreamWrapper(in, -1L);
            } else if (STORE_SIZE_MAX.equals(this.storeStream)) {
                wrapper = new ConnectionRecoveryManager.StreamWrapper(in, Integer.MAX_VALUE);
            } else {
                if (!STORE_TEMP_FILE.equals(this.storeStream)) throw new DataStoreException("Unsupported stream store algorithm: " + this.storeStream);
                File temp = this.moveToTempFile(in);
                fileInput = new TempFileInputStream(temp);
                long length = temp.length();
                wrapper = new ConnectionRecoveryManager.StreamWrapper(fileInput, length);
            }
            conn.executeStmt(this.updateDataSQL, new Object[]{wrapper, tempId});
            now = System.currentTimeMillis();
            long length = in.getPosition();
            DataIdentifier identifier = new DataIdentifier(digest.digest());
            this.usesIdentifier(identifier);
            id = identifier.toString();
            PreparedStatement prep = conn.executeStmt(this.updateSQL, new Object[]{id, new Long(length), new Long(now), tempId, id});
            int count = prep.getUpdateCount();
            if (count == 0) {
                conn.executeStmt(this.deleteSQL, new Object[]{tempId});
                prep = conn.executeStmt(this.selectMetaSQL, new Object[]{id});
                rs = prep.getResultSet();
                if (rs.next()) {
                    long oldLength = rs.getLong(1);
                    long lastModified = rs.getLong(2);
                    if (oldLength != length) {
                        String msg = "SHA-1 collision: temp=" + tempId + " id=" + id + " length=" + length + " oldLength=" + oldLength;
                        log.error(msg);
                        throw new DataStoreException(msg);
                    }
                    this.touch(identifier, lastModified);
                }
            }
            this.usesIdentifier(identifier);
            dbDataRecord = record = new DbDataRecord(this, identifier, length, now);
            if (tempId == null) break block24;
            this.temporaryInUse.remove(tempId);
        }
        DatabaseHelper.closeSilently(rs);
        this.putBack(conn);
        if (fileInput == null) return dbDataRecord;
        try {
            fileInput.close();
            return dbDataRecord;
        }
        catch (IOException e) {
            throw this.convert("Can not close temporary file", e);
        }
        catch (Exception e) {
            try {
                throw this.convert("Can not insert new record", e);
            }
            catch (Throwable throwable) {
                if (tempId != null) {
                    this.temporaryInUse.remove(tempId);
                }
                DatabaseHelper.closeSilently(rs);
                this.putBack(conn);
                if (fileInput == null) throw throwable;
                try {
                    fileInput.close();
                    throw throwable;
                }
                catch (IOException e2) {
                    throw this.convert("Can not close temporary file", e2);
                }
            }
        }
    }

    private File moveToTempFile(InputStream in) throws IOException {
        File temp = File.createTempFile("dbRecord", null);
        TempFileInputStream.writeToFileAndClose(in, temp);
        return temp;
    }

    public synchronized int deleteAllOlderThan(long min) throws DataStoreException {
        ConnectionRecoveryManager conn = this.getConnection();
        try {
            ArrayList<String> touch = new ArrayList<String>();
            Iterator<Object> it = new ArrayList(this.inUse.keySet()).iterator();
            while (it.hasNext()) {
                DataIdentifier identifier = (DataIdentifier)it.next();
                if (identifier == null) continue;
                touch.add(identifier.toString());
            }
            touch.addAll(this.temporaryInUse);
            it = touch.iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                this.updateLastModifiedDate(key, 0L);
            }
            PreparedStatement prep = conn.executeStmt(this.deleteOlderSQL, new Long[]{new Long(min)});
            int n = prep.getUpdateCount();
            return n;
        }
        catch (Exception e) {
            throw this.convert("Can not delete records", e);
        }
        finally {
            this.putBack(conn);
        }
    }

    public Iterator getAllIdentifiers() throws DataStoreException {
        Iterator iterator;
        ConnectionRecoveryManager conn = this.getConnection();
        ArrayList<DataIdentifier> list = new ArrayList<DataIdentifier>();
        ResultSet rs = null;
        try {
            PreparedStatement prep = conn.executeStmt(this.selectAllSQL, new Object[0]);
            rs = prep.getResultSet();
            while (rs.next()) {
                String id = rs.getString(1);
                if (id.startsWith(TEMP_PREFIX)) continue;
                DataIdentifier identifier = new DataIdentifier(id);
                list.add(identifier);
            }
            iterator = list.iterator();
        }
        catch (Exception e) {
            try {
                throw this.convert("Can not read records", e);
            }
            catch (Throwable throwable) {
                DatabaseHelper.closeSilently(rs);
                this.putBack(conn);
                throw throwable;
            }
        }
        DatabaseHelper.closeSilently(rs);
        this.putBack(conn);
        return iterator;
    }

    public int getMinRecordLength() {
        return this.minRecordLength;
    }

    public void setMinRecordLength(int minRecordLength) {
        this.minRecordLength = minRecordLength;
    }

    public DataRecord getRecord(DataIdentifier identifier) throws DataStoreException {
        DbDataRecord dbDataRecord;
        ConnectionRecoveryManager conn = this.getConnection();
        this.usesIdentifier(identifier);
        ResultSet rs = null;
        try {
            String id = identifier.toString();
            PreparedStatement prep = conn.executeStmt(this.selectMetaSQL, new Object[]{id});
            rs = prep.getResultSet();
            if (!rs.next()) {
                throw new DataStoreException("Record not found: " + identifier);
            }
            long length = rs.getLong(1);
            long lastModified = rs.getLong(2);
            this.touch(identifier, lastModified);
            dbDataRecord = new DbDataRecord(this, identifier, length, lastModified);
        }
        catch (Exception e) {
            try {
                throw this.convert("Can not read identifier " + identifier, e);
            }
            catch (Throwable throwable) {
                DatabaseHelper.closeSilently(rs);
                this.putBack(conn);
                throw throwable;
            }
        }
        DatabaseHelper.closeSilently(rs);
        this.putBack(conn);
        return dbDataRecord;
    }

    InputStream openStream(DbInputStream inputStream, DataIdentifier identifier) throws DataStoreException {
        ConnectionRecoveryManager conn = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection();
            PreparedStatement prep = conn.executeStmt(this.selectDataSQL, new Object[]{identifier.toString()});
            rs = prep.getResultSet();
            if (!rs.next()) {
                throw new DataStoreException("Record not found: " + identifier);
            }
            InputStream stream = rs.getBinaryStream(2);
            if (stream == null) {
                stream = new ByteArrayInputStream(new byte[0]);
                DatabaseHelper.closeSilently(rs);
                this.putBack(conn);
            } else if (this.copyWhenReading) {
                File temp = this.moveToTempFile(stream);
                stream = new TempFileInputStream(temp);
                DatabaseHelper.closeSilently(rs);
                this.putBack(conn);
            } else {
                stream = new BufferedInputStream(stream);
                inputStream.setConnection(conn);
                inputStream.setResultSet(rs);
            }
            return stream;
        }
        catch (Exception e) {
            DatabaseHelper.closeSilently(rs);
            this.putBack(conn);
            throw this.convert("Retrieving database resource ", e);
        }
    }

    public synchronized void init(String homeDir) throws DataStoreException {
        try {
            this.initDatabaseType();
            this.connectionPool = new Pool(this, this.maxConnections);
            ConnectionRecoveryManager conn = this.getConnection();
            DatabaseMetaData meta = conn.getConnection().getMetaData();
            log.info("Using JDBC driver " + meta.getDriverName() + " " + meta.getDriverVersion());
            meta.getDriverVersion();
            ResultSet rs = meta.getTables(null, null, this.tableSQL, null);
            boolean exists = rs.next();
            rs.close();
            if (!exists) {
                conn.executeStmt(this.createTableSQL, null);
            }
            this.putBack(conn);
        }
        catch (Exception e) {
            throw this.convert("Can not init data store, driver=" + this.driver + " url=" + this.url + " user=" + this.user + " tableSQL=" + this.tableSQL + " createTableSQL=" + this.createTableSQL, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initDatabaseType() throws DataStoreException {
        boolean failIfNotFound;
        if (this.databaseType == null) {
            if (!this.url.startsWith("jdbc:")) {
                return;
            }
            failIfNotFound = false;
            int start = "jdbc:".length();
            int end = this.url.indexOf(58, start);
            this.databaseType = this.url.substring(start, end);
        } else {
            failIfNotFound = true;
        }
        InputStream in = DbDataStore.class.getResourceAsStream(this.databaseType + ".properties");
        if (in == null) {
            if (failIfNotFound) {
                String msg = "Configuration error: The resource '" + this.databaseType + ".properties' could not be found;" + " Please verify the databaseType property";
                log.debug(msg);
                throw new DataStoreException(msg);
            }
            return;
        }
        Properties prop = new Properties();
        try {
            try {
                prop.load(in);
            }
            finally {
                in.close();
            }
        }
        catch (IOException e) {
            String msg = "Configuration error: Could not read properties '" + this.databaseType + ".properties'";
            log.debug(msg);
            throw new DataStoreException(msg);
        }
        if (this.driver == null) {
            this.driver = this.getProperty(prop, "driver", this.driver);
        }
        this.tableSQL = this.getProperty(prop, "table", this.tableSQL);
        this.createTableSQL = this.getProperty(prop, "createTable", this.createTableSQL);
        this.insertTempSQL = this.getProperty(prop, "insertTemp", this.insertTempSQL);
        this.updateDataSQL = this.getProperty(prop, "updateData", this.updateDataSQL);
        this.updateLastModifiedSQL = this.getProperty(prop, "updateLastModified", this.updateLastModifiedSQL);
        this.updateSQL = this.getProperty(prop, "update", this.updateSQL);
        this.deleteSQL = this.getProperty(prop, "delete", this.deleteSQL);
        this.deleteOlderSQL = this.getProperty(prop, "deleteOlder", this.deleteOlderSQL);
        this.selectMetaSQL = this.getProperty(prop, "selectMeta", this.selectMetaSQL);
        this.selectAllSQL = this.getProperty(prop, "selectAll", this.selectAllSQL);
        this.selectDataSQL = this.getProperty(prop, "selectData", this.selectDataSQL);
        this.storeStream = this.getProperty(prop, "storeStream", this.storeStream);
        if (!(STORE_SIZE_MINUS_ONE.equals(this.storeStream) || STORE_TEMP_FILE.equals(this.storeStream) || STORE_SIZE_MAX.equals(this.storeStream))) {
            String msg = "Unsupported Stream store mechanism: " + this.storeStream + " supported are: " + STORE_SIZE_MINUS_ONE + ", " + STORE_TEMP_FILE + ", " + STORE_SIZE_MAX;
            log.debug(msg);
            throw new DataStoreException(msg);
        }
    }

    protected String getProperty(Properties prop, String key, String defaultValue) {
        String sql = prop.getProperty(key, defaultValue);
        sql = Text.replace(sql, "${table}", this.tableSQL).trim();
        sql = Text.replace(sql, "${tablePrefix}", this.tablePrefix).trim();
        return sql;
    }

    protected DataStoreException convert(String cause, Exception e) {
        log.warn(cause, e);
        if (e instanceof DataStoreException) {
            return (DataStoreException)e;
        }
        return new DataStoreException(cause, e);
    }

    public void updateModifiedDateOnAccess(long before) {
        log.debug("Update modifiedDate on access before " + before);
        this.minModifiedDate = before;
    }

    long touch(DataIdentifier identifier, long lastModified) throws DataStoreException {
        this.usesIdentifier(identifier);
        return this.updateLastModifiedDate(identifier.toString(), lastModified);
    }

    private long updateLastModifiedDate(String key, long lastModified) throws DataStoreException {
        if (lastModified < this.minModifiedDate) {
            long now = System.currentTimeMillis();
            Long n = new Long(now);
            ConnectionRecoveryManager conn = this.getConnection();
            try {
                conn.executeStmt(this.updateLastModifiedSQL, new Object[]{n, key, n});
                long l = now;
                return l;
            }
            catch (Exception e) {
                throw this.convert("Can not update lastModified", e);
            }
            finally {
                this.putBack(conn);
            }
        }
        return lastModified;
    }

    public String getDatabaseType() {
        return this.databaseType;
    }

    public void setDatabaseType(String databaseType) {
        this.databaseType = databaseType;
    }

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public synchronized void close() {
        ArrayList list = this.connectionPool.getAll();
        for (int i = 0; i < list.size(); ++i) {
            ConnectionRecoveryManager conn = (ConnectionRecoveryManager)list.get(i);
            conn.close();
        }
        list.clear();
    }

    protected void usesIdentifier(DataIdentifier identifier) {
        this.inUse.put(identifier, new WeakReference<DataIdentifier>(identifier));
    }

    public void clearInUse() {
        this.inUse.clear();
    }

    protected synchronized MessageDigest getDigest() throws DataStoreException {
        try {
            return MessageDigest.getInstance(DIGEST);
        }
        catch (NoSuchAlgorithmException e) {
            throw this.convert("No such algorithm: SHA-1", e);
        }
    }

    protected ConnectionRecoveryManager getConnection() throws DataStoreException {
        try {
            ConnectionRecoveryManager conn = (ConnectionRecoveryManager)this.connectionPool.get();
            conn.setAutoReconnect(true);
            return conn;
        }
        catch (InterruptedException e) {
            throw new DataStoreException("Interrupted", e);
        }
        catch (RepositoryException e) {
            throw new DataStoreException("Can not open a new connection", e);
        }
    }

    protected void putBack(ConnectionRecoveryManager conn) throws DataStoreException {
        try {
            this.connectionPool.add(conn);
        }
        catch (InterruptedException e) {
            throw new DataStoreException("Interrupted", e);
        }
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
    }

    public ConnectionRecoveryManager createNewConnection() throws RepositoryException {
        ConnectionRecoveryManager conn = new ConnectionRecoveryManager(false, this.driver, this.url, this.user, this.password);
        return conn;
    }

    public boolean getCopyWhenReading() {
        return this.copyWhenReading;
    }

    public void setCopyWhenReading(boolean copyWhenReading) {
        this.copyWhenReading = copyWhenReading;
    }

    public String getTablePrefix() {
        return this.tablePrefix;
    }

    public void setTablePrefix(String tablePrefix) {
        this.tablePrefix = tablePrefix;
    }
}

