/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.LocalField;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.info.JVMInfo;
import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.BaseTypeCompiler;

public final class NumericTypeCompiler
extends BaseTypeCompiler {
    public String interfaceName() {
        return "org.apache.derby.iapi.types.NumberDataValue";
    }

    public String getCorrespondingPrimitiveTypeName() {
        int n = this.getStoredFormatIdFromTypeId();
        switch (n) {
            case 6: {
                return "double";
            }
            case 7: {
                return "int";
            }
            case 11: {
                return "long";
            }
            case 8: {
                return "float";
            }
            case 10: {
                return "short";
            }
            case 195: {
                return "byte";
            }
        }
        return null;
    }

    public String getPrimitiveMethodName() {
        int n = this.getStoredFormatIdFromTypeId();
        switch (n) {
            case 6: {
                return "getDouble";
            }
            case 7: {
                return "getInt";
            }
            case 11: {
                return "getLong";
            }
            case 8: {
                return "getFloat";
            }
            case 10: {
                return "getShort";
            }
            case 195: {
                return "getByte";
            }
        }
        return null;
    }

    public int getCastToCharWidth(DataTypeDescriptor dataTypeDescriptor) {
        int n = this.getStoredFormatIdFromTypeId();
        switch (n) {
            case 197: {
                return dataTypeDescriptor.getPrecision() + 2;
            }
            case 6: {
                return 54;
            }
            case 7: {
                return 11;
            }
            case 11: {
                return 20;
            }
            case 8: {
                return 25;
            }
            case 10: {
                return 6;
            }
            case 195: {
                return 4;
            }
        }
        return 0;
    }

    public DataTypeDescriptor resolveArithmeticOperation(DataTypeDescriptor dataTypeDescriptor, DataTypeDescriptor dataTypeDescriptor2, String string) throws StandardException {
        int n;
        NumericTypeCompiler numericTypeCompiler;
        DataTypeDescriptor dataTypeDescriptor3;
        TypeId typeId = dataTypeDescriptor.getTypeId();
        TypeId typeId2 = dataTypeDescriptor2.getTypeId();
        boolean bl = true;
        if (!typeId2.isNumericTypeId()) {
            bl = false;
        }
        if ("mod".equals(string)) {
            switch (typeId.getJDBCTypeId()) {
                case -6: 
                case -5: 
                case 4: 
                case 5: {
                    break;
                }
                default: {
                    bl = false;
                }
            }
            switch (typeId2.getJDBCTypeId()) {
                case -6: 
                case -5: 
                case 4: 
                case 5: {
                    break;
                }
                default: {
                    bl = false;
                }
            }
        }
        if (!bl) {
            throw StandardException.newException("42Y95", (Object)string, (Object)dataTypeDescriptor.getTypeId().getSQLTypeName(), (Object)dataTypeDescriptor2.getTypeId().getSQLTypeName());
        }
        if (typeId2.typePrecedence() > typeId.typePrecedence()) {
            dataTypeDescriptor3 = dataTypeDescriptor2;
            numericTypeCompiler = (NumericTypeCompiler)this.getTypeCompiler(typeId2);
        } else {
            dataTypeDescriptor3 = dataTypeDescriptor;
            numericTypeCompiler = (NumericTypeCompiler)this.getTypeCompiler(typeId);
        }
        int n2 = numericTypeCompiler.getPrecision(string, dataTypeDescriptor, dataTypeDescriptor2);
        int n3 = numericTypeCompiler.getScale(string, dataTypeDescriptor, dataTypeDescriptor2);
        if (dataTypeDescriptor3.getTypeId().isDecimalTypeId()) {
            int n4 = n = n3 > 0 ? n2 + 3 : n2 + 1;
            if (n < n2) {
                n = Integer.MAX_VALUE;
            }
        } else {
            n = dataTypeDescriptor3.getMaximumWidth();
        }
        boolean bl2 = dataTypeDescriptor.isNullable() || dataTypeDescriptor2.isNullable();
        return new DataTypeDescriptor(dataTypeDescriptor3.getTypeId(), n2, n3, bl2, n);
    }

    public boolean comparable(TypeId typeId, boolean bl, ClassFactory classFactory) {
        return this.numberComparable(typeId, bl, classFactory);
    }

    public boolean convertible(TypeId typeId, boolean bl) {
        return this.numberConvertible(typeId, bl);
    }

    public boolean compatible(TypeId typeId) {
        return typeId.isNumericTypeId();
    }

    public boolean storable(TypeId typeId, ClassFactory classFactory) {
        return this.numberStorable(this.getTypeId(), typeId, classFactory);
    }

    protected String dataValueMethodName() {
        if (this.getStoredFormatIdFromTypeId() == 197) {
            return "getDecimalDataValue";
        }
        return super.dataValueMethodName();
    }

    protected String nullMethodName() {
        int n = this.getStoredFormatIdFromTypeId();
        switch (n) {
            case 197: {
                return "getNullDecimal";
            }
            case 6: {
                return "getNullDouble";
            }
            case 7: {
                return "getNullInteger";
            }
            case 11: {
                return "getNullLong";
            }
            case 8: {
                return "getNullFloat";
            }
            case 10: {
                return "getNullShort";
            }
            case 195: {
                return "getNullByte";
            }
        }
        return null;
    }

    private int getPrecision(String string, DataTypeDescriptor dataTypeDescriptor, DataTypeDescriptor dataTypeDescriptor2) {
        long l;
        if (this.getStoredFormatIdFromTypeId() != 197) {
            return dataTypeDescriptor.getPrecision();
        }
        long l2 = dataTypeDescriptor.getScale();
        long l3 = dataTypeDescriptor2.getScale();
        long l4 = dataTypeDescriptor.getPrecision();
        long l5 = dataTypeDescriptor2.getPrecision();
        if (string == null) {
            l = (long)this.getScale(string, dataTypeDescriptor, dataTypeDescriptor2) + Math.max(l4 - l2, l5 - l3);
        } else if (string.equals("*")) {
            l = l4 + l5;
        } else if (string.equals("sum")) {
            l = l4 - l2 + l5 - l3 + (long)this.getScale(string, dataTypeDescriptor, dataTypeDescriptor2);
        } else if (string.equals("/")) {
            l = Math.min(31L, (long)this.getScale(string, dataTypeDescriptor, dataTypeDescriptor2) + l4 - l2 + l5);
        } else {
            l = (long)this.getScale(string, dataTypeDescriptor, dataTypeDescriptor2) + Math.max(l4 - l2, l5 - l3) + 1L;
            if (l > 31L) {
                l = 31L;
            }
        }
        if (l > Integer.MAX_VALUE) {
            l = Integer.MAX_VALUE;
        }
        l = Math.min(31L, l);
        return (int)l;
    }

    private int getScale(String string, DataTypeDescriptor dataTypeDescriptor, DataTypeDescriptor dataTypeDescriptor2) {
        long l;
        if (this.getStoredFormatIdFromTypeId() != 197) {
            return dataTypeDescriptor.getScale();
        }
        long l2 = dataTypeDescriptor.getScale();
        long l3 = dataTypeDescriptor2.getScale();
        long l4 = dataTypeDescriptor.getPrecision();
        long l5 = dataTypeDescriptor2.getPrecision();
        if ("*".equals(string)) {
            l = l2 + l3;
        } else if ("/".equals(string)) {
            LanguageConnectionContext languageConnectionContext = (LanguageConnectionContext)ContextService.getContext("LanguageConnectionContext");
            l = Math.max(31L - l4 + l2 - l3, 0L);
        } else {
            l = "avg".equals(string) ? Math.max(Math.max(l2, l3), 4L) : Math.max(l2, l3);
        }
        if (l > Integer.MAX_VALUE) {
            l = Integer.MAX_VALUE;
        }
        l = Math.min(31L, l);
        return (int)l;
    }

    public void generateDataValue(MethodBuilder methodBuilder, LocalField localField) {
        if (!JVMInfo.J2ME && this.getTypeId().isDecimalTypeId()) {
            methodBuilder.upCast("java.lang.Number");
        }
        super.generateDataValue(methodBuilder, localField);
    }
}

