/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.xml;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Stack;
import javax.jcr.InvalidSerializedDataException;
import javax.jcr.NamespaceException;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.xml.BufferedStringValue;
import org.apache.jackrabbit.core.xml.Importer;
import org.apache.jackrabbit.core.xml.NodeInfo;
import org.apache.jackrabbit.core.xml.PropInfo;
import org.apache.jackrabbit.core.xml.TargetImportHandler;
import org.apache.jackrabbit.core.xml.TextValue;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.conversion.NameException;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.spi.commons.name.NameFactoryImpl;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

class SysViewImportHandler
extends TargetImportHandler {
    private final Stack stack = new Stack();
    private Name currentPropName;
    private int currentPropType = 0;
    private ArrayList currentPropValues = new ArrayList();
    private BufferedStringValue currentPropValue;

    SysViewImportHandler(Importer importer) {
        super(importer);
    }

    private void processNode(ImportState state, boolean start, boolean end) throws SAXException {
        if (!start && !end) {
            return;
        }
        Name[] mixinNames = null;
        if (state.mixinNames != null) {
            mixinNames = state.mixinNames.toArray(new Name[state.mixinNames.size()]);
        }
        NodeId id = null;
        if (state.uuid != null) {
            id = NodeId.valueOf(state.uuid);
        }
        NodeInfo node = new NodeInfo(state.nodeName, state.nodeTypeName, mixinNames, id);
        try {
            if (start) {
                this.importer.startNode(node, state.props);
                Iterator iter = state.props.iterator();
                while (iter.hasNext()) {
                    PropInfo pi = (PropInfo)iter.next();
                    pi.dispose();
                }
            }
            if (end) {
                this.importer.endNode(node);
            }
        }
        catch (RepositoryException re) {
            throw new SAXException(re);
        }
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        Name name = NameFactoryImpl.getInstance().create(namespaceURI, localName);
        if (name.equals(NameConstants.SV_NODE)) {
            String svName = SysViewImportHandler.getAttribute(atts, NameConstants.SV_NAME);
            if (name == null) {
                throw new SAXException(new InvalidSerializedDataException("missing mandatory sv:name attribute of element sv:node"));
            }
            if (!this.stack.isEmpty()) {
                ImportState current = (ImportState)this.stack.peek();
                if (!current.started) {
                    this.processNode(current, true, false);
                    current.started = true;
                }
            }
            ImportState state = new ImportState();
            try {
                state.nodeName = this.resolver.getQName(svName);
            }
            catch (NameException e) {
                throw new SAXException(new InvalidSerializedDataException("illegal node name: " + name, e));
            }
            catch (NamespaceException e) {
                throw new SAXException(new InvalidSerializedDataException("illegal node name: " + name, e));
            }
            this.stack.push(state);
        } else {
            if (name.equals(NameConstants.SV_PROPERTY)) {
                this.currentPropValues.clear();
                String svName = SysViewImportHandler.getAttribute(atts, NameConstants.SV_NAME);
                if (name == null) {
                    throw new SAXException(new InvalidSerializedDataException("missing mandatory sv:name attribute of element sv:property"));
                }
                try {
                    this.currentPropName = this.resolver.getQName(svName);
                }
                catch (NameException e) {
                    throw new SAXException(new InvalidSerializedDataException("illegal property name: " + name, e));
                }
                catch (NamespaceException e) {
                    throw new SAXException(new InvalidSerializedDataException("illegal property name: " + name, e));
                }
                String type = SysViewImportHandler.getAttribute(atts, NameConstants.SV_TYPE);
                if (type == null) {
                    throw new SAXException(new InvalidSerializedDataException("missing mandatory sv:type attribute of element sv:property"));
                }
                try {
                    this.currentPropType = PropertyType.valueFromName(type);
                }
                catch (IllegalArgumentException e) {
                    throw new SAXException(new InvalidSerializedDataException("Unknown property type: " + type, e));
                }
            }
            if (name.equals(NameConstants.SV_VALUE)) {
                this.currentPropValue = new BufferedStringValue(this.resolver);
            } else {
                throw new SAXException(new InvalidSerializedDataException("Unexpected element in system view xml document: " + name));
            }
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.currentPropValue != null) {
            try {
                this.currentPropValue.append(ch, start, length);
            }
            catch (IOException ioe) {
                throw new SAXException("error while processing property value", ioe);
            }
        }
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (this.currentPropValue != null) {
            try {
                this.currentPropValue.append(ch, start, length);
            }
            catch (IOException ioe) {
                throw new SAXException("error while processing property value", ioe);
            }
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        Name name = NameFactoryImpl.getInstance().create(namespaceURI, localName);
        ImportState state = (ImportState)this.stack.peek();
        if (name.equals(NameConstants.SV_NODE)) {
            if (!state.started) {
                this.processNode(state, true, true);
                state.started = true;
            } else {
                this.processNode(state, false, true);
            }
            this.stack.pop();
        } else if (name.equals(NameConstants.SV_PROPERTY)) {
            if (this.currentPropName.equals(NameConstants.JCR_PRIMARYTYPE)) {
                BufferedStringValue val = (BufferedStringValue)this.currentPropValues.get(0);
                String s = null;
                try {
                    s = val.retrieve();
                    state.nodeTypeName = this.resolver.getQName(s);
                }
                catch (IOException ioe) {
                    throw new SAXException("error while retrieving value", ioe);
                }
                catch (NameException e) {
                    throw new SAXException(new InvalidSerializedDataException("illegal node type name: " + s, e));
                }
                catch (NamespaceException e) {
                    throw new SAXException(new InvalidSerializedDataException("illegal node type name: " + s, e));
                }
            } else if (this.currentPropName.equals(NameConstants.JCR_MIXINTYPES)) {
                if (state.mixinNames == null) {
                    state.mixinNames = new ArrayList(this.currentPropValues.size());
                }
                for (int i = 0; i < this.currentPropValues.size(); ++i) {
                    BufferedStringValue val = (BufferedStringValue)this.currentPropValues.get(i);
                    String s = null;
                    try {
                        s = val.retrieve();
                        Name mixin = this.resolver.getQName(s);
                        state.mixinNames.add(mixin);
                        continue;
                    }
                    catch (IOException ioe) {
                        throw new SAXException("error while retrieving value", ioe);
                    }
                    catch (NameException e) {
                        throw new SAXException(new InvalidSerializedDataException("illegal mixin type name: " + s, e));
                    }
                    catch (NamespaceException e) {
                        throw new SAXException(new InvalidSerializedDataException("illegal mixin type name: " + s, e));
                    }
                }
            } else if (this.currentPropName.equals(NameConstants.JCR_UUID)) {
                BufferedStringValue val = (BufferedStringValue)this.currentPropValues.get(0);
                try {
                    state.uuid = val.retrieve();
                }
                catch (IOException ioe) {
                    throw new SAXException("error while retrieving value", ioe);
                }
            } else {
                PropInfo prop = new PropInfo(this.currentPropName, this.currentPropType, this.currentPropValues.toArray(new TextValue[this.currentPropValues.size()]));
                state.props.add(prop);
            }
            this.currentPropValues.clear();
        } else if (name.equals(NameConstants.SV_VALUE)) {
            this.currentPropValues.add(this.currentPropValue);
            this.currentPropValue = null;
        } else {
            throw new SAXException(new InvalidSerializedDataException("invalid element in system view xml document: " + localName));
        }
    }

    private static String getAttribute(Attributes attributes, Name name) {
        return attributes.getValue(name.getNamespaceURI(), name.getLocalName());
    }

    class ImportState {
        Name nodeName;
        Name nodeTypeName;
        ArrayList mixinNames;
        String uuid;
        ArrayList props = new ArrayList();
        boolean started = false;

        ImportState() {
        }
    }
}

