/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.user;

import java.security.Principal;
import java.security.acl.Group;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import org.apache.jackrabbit.api.jsr283.security.AccessControlPolicy;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.core.ItemImpl;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.observation.SynchronousEventListener;
import org.apache.jackrabbit.core.security.authorization.AbstractAccessControlProvider;
import org.apache.jackrabbit.core.security.authorization.AbstractCompiledPermissions;
import org.apache.jackrabbit.core.security.authorization.AccessControlEditor;
import org.apache.jackrabbit.core.security.authorization.CompiledPermissions;
import org.apache.jackrabbit.core.security.authorization.NamedAccessControlPolicyImpl;
import org.apache.jackrabbit.core.security.principal.ItemBasedPrincipal;
import org.apache.jackrabbit.core.security.principal.PrincipalImpl;
import org.apache.jackrabbit.core.security.user.UserConstants;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserAccessControlProvider
extends AbstractAccessControlProvider
implements UserConstants {
    private static Logger log = LoggerFactory.getLogger(UserAccessControlProvider.class);
    private final AccessControlPolicy policy = new NamedAccessControlPolicyImpl("userPolicy");
    private Path groupsPath;
    private Path usersPath;
    private String userAdminGroup;
    private String groupAdminGroup;

    public boolean isAcItem(Path absPath) throws RepositoryException {
        return false;
    }

    public boolean isAcItem(ItemImpl item) throws RepositoryException {
        return false;
    }

    public void init(Session systemSession, Map configuration) throws RepositoryException {
        SessionImpl sImpl;
        super.init(systemSession, configuration);
        if (systemSession instanceof SessionImpl) {
            sImpl = (SessionImpl)systemSession;
            this.userAdminGroup = configuration.containsKey("UserAdmin") ? configuration.get("UserAdmin").toString() : "UserAdmin";
            this.groupAdminGroup = configuration.containsKey("GroupAdmin") ? configuration.get("GroupAdmin").toString() : "GroupAdmin";
            UserManager uMgr = sImpl.getUserManager();
            if (!UserAccessControlProvider.initGroup(uMgr, this.userAdminGroup)) {
                log.warn("Unable to initialize User admininistrator group -> no user admins.");
                this.userAdminGroup = null;
            }
            if (!UserAccessControlProvider.initGroup(uMgr, this.groupAdminGroup)) {
                log.warn("Unable to initialize Group admininistrator group -> no group admins.");
                this.groupAdminGroup = null;
            }
        } else {
            throw new RepositoryException("SessionImpl (system session) expected.");
        }
        this.usersPath = sImpl.getQPath("/rep:security/rep:authorizables/rep:users");
        this.groupsPath = sImpl.getQPath("/rep:security/rep:authorizables/rep:groups");
    }

    public AccessControlPolicy[] getEffectivePolicies(Path absPath) throws ItemNotFoundException, RepositoryException {
        this.checkInitialized();
        return new AccessControlPolicy[]{this.policy};
    }

    public AccessControlEditor getEditor(Session session) {
        this.checkInitialized();
        return null;
    }

    public CompiledPermissions compilePermissions(Set principals) throws RepositoryException {
        this.checkInitialized();
        if (this.isAdminOrSystem(principals)) {
            return UserAccessControlProvider.getAdminPermissions();
        }
        ItemBasedPrincipal userPrincipal = this.getUserPrincipal(principals);
        NodeImpl userNode = this.getUserNode(userPrincipal);
        if (userNode == null) {
            return this.getReadOnlyPermissions();
        }
        return new CompiledPermissionsImpl(principals, userNode);
    }

    public boolean canAccessRoot(Set principals) throws RepositoryException {
        this.checkInitialized();
        return true;
    }

    private ItemBasedPrincipal getUserPrincipal(Set principals) {
        try {
            UserManager uMgr = this.session.getUserManager();
            Iterator it = principals.iterator();
            while (it.hasNext()) {
                Principal p = (Principal)it.next();
                if (p instanceof Group || !(p instanceof ItemBasedPrincipal) || uMgr.getAuthorizable(p) == null) continue;
                return (ItemBasedPrincipal)p;
            }
        }
        catch (RepositoryException e) {
            log.error("Internal error while retrieving user principal", (Object)e.getMessage());
        }
        return null;
    }

    private NodeImpl getUserNode(ItemBasedPrincipal principal) {
        NodeImpl userNode = null;
        if (principal != null) {
            try {
                String path = principal.getPath();
                userNode = (NodeImpl)this.session.getNode(path);
            }
            catch (RepositoryException e) {
                log.warn("Error while retrieving user node.", (Object)e.getMessage());
            }
        }
        return userNode;
    }

    private Node getExistingNode(Path path) throws RepositoryException {
        String absPath = this.resolver.getJCRPath(path.getNormalizedPath());
        if (this.session.nodeExists(absPath)) {
            return this.session.getNode(absPath);
        }
        if (this.session.propertyExists(absPath)) {
            return this.session.getProperty(absPath).getParent();
        }
        String pPath = Text.getRelativeParent(absPath, 1);
        if (this.session.nodeExists(pPath)) {
            return this.session.getNode(pPath);
        }
        throw new ItemNotFoundException("Unable to determine permissions: No item and no existing parent for target path " + absPath);
    }

    private static boolean containsGroup(Set principals, String groupName) {
        Iterator it = principals.iterator();
        while (it.hasNext() && groupName != null) {
            Principal p = (Principal)it.next();
            if (!p.getName().equals(groupName)) continue;
            return true;
        }
        return false;
    }

    private static boolean initGroup(UserManager uMgr, String principalName) {
        boolean success;
        PrincipalImpl prnc = new PrincipalImpl(principalName);
        try {
            Authorizable auth = uMgr.getAuthorizable(prnc);
            if (auth == null) {
                success = uMgr.createGroup(prnc) != null;
            } else {
                success = auth.isGroup();
                if (!success) {
                    log.warn("Cannot create group '" + principalName + "'; User with that principal already exists.");
                }
            }
        }
        catch (RepositoryException e) {
            log.error("Error while initializing user/group administrators", (Object)e.getMessage());
            success = false;
        }
        return success;
    }

    private class CompiledPermissionsImpl
    extends AbstractCompiledPermissions
    implements SynchronousEventListener {
        private final NodeImpl userNode;
        private boolean isUserAdmin;
        private boolean isGroupAdmin;

        protected CompiledPermissionsImpl(Set principals, NodeImpl userNode) throws RepositoryException {
            this.userNode = userNode;
            this.isUserAdmin = UserAccessControlProvider.containsGroup(principals, UserAccessControlProvider.this.userAdminGroup);
            this.isGroupAdmin = UserAccessControlProvider.containsGroup(principals, UserAccessControlProvider.this.groupAdminGroup);
            int events = 28;
            UserAccessControlProvider.this.observationMgr.addEventListener(this, events, "/rep:security/rep:authorizables/rep:users", true, null, null, false);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected AbstractCompiledPermissions.Result buildResult(Path path) throws RepositoryException {
            Path abs2Path;
            int denies = 0;
            int allows = 1;
            boolean calcPrivs = UserAccessControlProvider.this.session.nodeExists(UserAccessControlProvider.this.resolver.getJCRPath(path.getNormalizedPath()));
            int privs = calcPrivs ? 1 : 0;
            Path path2 = abs2Path = 4 > path.getLength() ? null : path.subPath(0, 4);
            if (UserAccessControlProvider.this.usersPath.equals(abs2Path)) {
                NodeImpl node = (NodeImpl)UserAccessControlProvider.this.getExistingNode(path);
                NodeImpl authN = null;
                if (node.isNodeType(UserConstants.NT_REP_AUTHORIZABLE)) {
                    authN = node;
                } else if (node.isNodeType(UserConstants.NT_REP_AUTHORIZABLE_FOLDER)) {
                    NodeImpl parent = node;
                    while (authN == null && parent.getDepth() > 0) {
                        if ((parent = (NodeImpl)parent.getParent()).isNodeType(UserConstants.NT_REP_AUTHORIZABLE)) {
                            authN = parent;
                            continue;
                        }
                        if (parent.isNodeType(UserConstants.NT_REP_AUTHORIZABLE_FOLDER)) continue;
                    }
                }
                if (authN == null || !authN.isNodeType(UserConstants.NT_REP_USER)) return new AbstractCompiledPermissions.Result(allows, denies, privs, 0);
                int relDepth = UserAccessControlProvider.this.session.getHierarchyManager().getRelativeDepth(this.userNode.getNodeId(), authN.getNodeId());
                boolean isGroupProp = UserConstants.P_GROUPS.equals(path.getNameElement().getName());
                boolean requiredGroups = this.isUserAdmin;
                if (requiredGroups && isGroupProp) {
                    requiredGroups = this.isGroupAdmin;
                }
                switch (relDepth) {
                    case -1: {
                        return new AbstractCompiledPermissions.Result(allows, denies, privs, 0);
                    }
                    case 0: {
                        if (requiredGroups) {
                            allows = 31;
                            if (!calcPrivs) return new AbstractCompiledPermissions.Result(allows, denies, privs, 0);
                            privs |= 0xE;
                            return new AbstractCompiledPermissions.Result(allows, denies, privs, 0);
                        }
                        if (!this.userNode.isSame(node) || isGroupProp && !this.isGroupAdmin) return new AbstractCompiledPermissions.Result(allows, denies, privs, 0);
                        allows |= 0x12;
                        if (!calcPrivs) return new AbstractCompiledPermissions.Result(allows, denies, privs, 0);
                        privs |= 2;
                        return new AbstractCompiledPermissions.Result(allows, denies, privs, 0);
                    }
                    default: {
                        if (!requiredGroups) return new AbstractCompiledPermissions.Result(allows, denies, privs, 0);
                        allows = 31;
                        if (!calcPrivs) return new AbstractCompiledPermissions.Result(allows, denies, privs, 0);
                        privs |= 0xE;
                    }
                }
                return new AbstractCompiledPermissions.Result(allows, denies, privs, 0);
            } else {
                if (!UserAccessControlProvider.this.groupsPath.equals(abs2Path) || !this.isGroupAdmin) return new AbstractCompiledPermissions.Result(allows, denies, privs, 0);
                allows = 31;
                if (!calcPrivs) return new AbstractCompiledPermissions.Result(allows, denies, privs, 0);
                privs |= 0xE;
            }
            return new AbstractCompiledPermissions.Result(allows, denies, privs, 0);
        }

        public void close() {
            try {
                UserAccessControlProvider.this.observationMgr.removeEventListener(this);
            }
            catch (RepositoryException e) {
                log.error("Internal error: ", (Object)e.getMessage());
            }
            super.close();
        }

        public boolean grants(Path absPath, int permissions) throws RepositoryException {
            if (permissions == 1) {
                return true;
            }
            return super.grants(absPath, permissions);
        }

        public boolean canReadAll() throws RepositoryException {
            return true;
        }

        public void onEvent(EventIterator events) {
            while (events.hasNext()) {
                Event ev = events.nextEvent();
                try {
                    String evPath = ev.getPath();
                    String repGroups = UserAccessControlProvider.this.session.getJCRName(UserConstants.P_GROUPS);
                    if (!repGroups.equals(Text.getName(evPath)) || !this.userNode.getPath().equals(Text.getRelativeParent(evPath, 1))) continue;
                    switch (ev.getType()) {
                        case 8: {
                            this.isUserAdmin = false;
                            this.isGroupAdmin = false;
                            break;
                        }
                        case 4: 
                        case 16: {
                            Value[] vs = UserAccessControlProvider.this.session.getProperty(evPath).getValues();
                            String princName = UserAccessControlProvider.this.session.getJCRName(UserConstants.P_PRINCIPAL_NAME);
                            for (int i = 0; i < vs.length; ++i) {
                                Node groupNode = UserAccessControlProvider.this.session.getNodeByUUID(vs[i].getString());
                                String pName = groupNode.getProperty(princName).getString();
                                if (UserAccessControlProvider.this.userAdminGroup.equals(pName)) {
                                    this.isUserAdmin = true;
                                    continue;
                                }
                                if (!UserAccessControlProvider.this.groupAdminGroup.equals(pName)) continue;
                                this.isGroupAdmin = true;
                            }
                            break;
                        }
                    }
                    this.clearCache();
                    break;
                }
                catch (RepositoryException e) {
                    log.error("Internal error ", (Object)e.getMessage());
                }
            }
        }
    }
}

