/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.observation;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.jcr.Session;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import org.apache.jackrabbit.core.ItemId;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.PropertyId;
import org.apache.jackrabbit.core.nodetype.NodeTypeImpl;
import org.apache.jackrabbit.core.nodetype.NodeTypeManagerImpl;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventState {
    private static final Logger log = LoggerFactory.getLogger(EventState.class);
    private final int type;
    private final NodeId parentId;
    private final Path parentPath;
    private final NodeId childId;
    private final Path.Element childRelPath;
    private final Name nodeType;
    private final Set mixins;
    private Set allTypes;
    private final Session session;
    private String stringValue;
    private int hashCode;
    private final boolean external;

    private EventState(int type, NodeId parentId, Path parentPath, NodeId childId, Path.Element childPath, Name nodeType, Set mixins, Session session, boolean external) {
        int mask = 28;
        if ((type & mask) > 0) {
            if (childId != null) {
                throw new IllegalArgumentException("childId only allowed for Node events.");
            }
        } else if (childId == null) {
            throw new IllegalArgumentException("childId must not be null for Node events.");
        }
        this.type = type;
        this.parentId = parentId;
        this.parentPath = parentPath;
        this.childId = childId;
        this.childRelPath = childPath;
        this.nodeType = nodeType;
        this.mixins = mixins;
        this.session = session;
        this.external = external;
    }

    public static EventState childNodeAdded(NodeId parentId, Path parentPath, NodeId childId, Path.Element childPath, Name nodeType, Set mixins, Session session) {
        return EventState.childNodeAdded(parentId, parentPath, childId, childPath, nodeType, mixins, session, false);
    }

    public static EventState childNodeAdded(NodeId parentId, Path parentPath, NodeId childId, Path.Element childPath, Name nodeType, Set mixins, Session session, boolean external) {
        return new EventState(1, parentId, parentPath, childId, childPath, nodeType, mixins, session, external);
    }

    public static EventState childNodeRemoved(NodeId parentId, Path parentPath, NodeId childId, Path.Element childPath, Name nodeType, Set mixins, Session session) {
        return EventState.childNodeRemoved(parentId, parentPath, childId, childPath, nodeType, mixins, session, false);
    }

    public static EventState childNodeRemoved(NodeId parentId, Path parentPath, NodeId childId, Path.Element childPath, Name nodeType, Set mixins, Session session, boolean external) {
        return new EventState(2, parentId, parentPath, childId, childPath, nodeType, mixins, session, external);
    }

    public static EventState propertyAdded(NodeId parentId, Path parentPath, Path.Element childPath, Name nodeType, Set mixins, Session session) {
        return EventState.propertyAdded(parentId, parentPath, childPath, nodeType, mixins, session, false);
    }

    public static EventState propertyAdded(NodeId parentId, Path parentPath, Path.Element childPath, Name nodeType, Set mixins, Session session, boolean external) {
        return new EventState(4, parentId, parentPath, null, childPath, nodeType, mixins, session, external);
    }

    public static EventState propertyRemoved(NodeId parentId, Path parentPath, Path.Element childPath, Name nodeType, Set mixins, Session session) {
        return EventState.propertyRemoved(parentId, parentPath, childPath, nodeType, mixins, session, false);
    }

    public static EventState propertyRemoved(NodeId parentId, Path parentPath, Path.Element childPath, Name nodeType, Set mixins, Session session, boolean external) {
        return new EventState(8, parentId, parentPath, null, childPath, nodeType, mixins, session, external);
    }

    public static EventState propertyChanged(NodeId parentId, Path parentPath, Path.Element childPath, Name nodeType, Set mixins, Session session) {
        return EventState.propertyChanged(parentId, parentPath, childPath, nodeType, mixins, session, false);
    }

    public static EventState propertyChanged(NodeId parentId, Path parentPath, Path.Element childPath, Name nodeType, Set mixins, Session session, boolean external) {
        return new EventState(16, parentId, parentPath, null, childPath, nodeType, mixins, session, external);
    }

    public int getType() {
        return this.type;
    }

    public NodeId getParentId() {
        return this.parentId;
    }

    public Path getParentPath() {
        return this.parentPath;
    }

    public NodeId getChildId() {
        return this.childId;
    }

    public Path.Element getChildRelPath() {
        return this.childRelPath;
    }

    public Name getNodeType() {
        return this.nodeType;
    }

    public Set getMixinNames() {
        return this.mixins;
    }

    public Set getNodeTypes(NodeTypeManagerImpl ntMgr) {
        if (this.allTypes == null) {
            HashSet<NodeTypeImpl> tmp = new HashSet<NodeTypeImpl>();
            try {
                tmp.add(ntMgr.getNodeType(this.nodeType));
            }
            catch (NoSuchNodeTypeException e) {
                log.warn("Unknown node type: " + this.nodeType);
            }
            Iterator it = this.mixins.iterator();
            while (it.hasNext()) {
                Name mixinName = (Name)it.next();
                try {
                    tmp.add(ntMgr.getNodeType(mixinName));
                }
                catch (NoSuchNodeTypeException e) {
                    log.warn("Unknown node type: " + mixinName);
                }
            }
            this.allTypes = Collections.unmodifiableSet(tmp);
        }
        return this.allTypes;
    }

    public String getUserId() {
        return this.session.getUserID();
    }

    Session getSession() {
        return this.session;
    }

    ItemId getTargetId() {
        if (this.childId == null) {
            return new PropertyId(this.parentId, this.childRelPath.getName());
        }
        return this.childId;
    }

    boolean isExternal() {
        return this.external;
    }

    public String toString() {
        if (this.stringValue == null) {
            StringBuffer sb = new StringBuffer();
            sb.append("EventState: ").append(EventState.valueOf(this.type));
            sb.append(", Parent: ").append(this.parentId);
            sb.append(", Child: ").append(this.childRelPath);
            sb.append(", UserId: ").append(this.session.getUserID());
            this.stringValue = sb.toString();
        }
        return this.stringValue;
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            h = 37;
            h = 37 * h + this.type;
            h = 37 * h + this.parentId.hashCode();
            h = 37 * h + this.childRelPath.hashCode();
            this.hashCode = h = 37 * h + this.session.hashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof EventState) {
            EventState other = (EventState)obj;
            return this.type == other.type && this.parentId.equals(other.parentId) && this.childRelPath.equals(other.childRelPath) && this.session.equals(other.session);
        }
        return false;
    }

    public static String valueOf(int eventType) {
        if (eventType == 1) {
            return "NodeAdded";
        }
        if (eventType == 2) {
            return "NodeRemoved";
        }
        if (eventType == 4) {
            return "PropertyAdded";
        }
        if (eventType == 16) {
            return "PropertyOperation";
        }
        if (eventType == 8) {
            return "PropertyRemoved";
        }
        return "UnknownEventType";
    }
}

