/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.authorization.principalbased;

import javax.jcr.Item;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GlobPattern {
    private static Logger log = LoggerFactory.getLogger(GlobPattern.class);
    private static final char ALL = '*';
    public static final String WILDCARD_ALL = "*";
    private final String pattern;

    private GlobPattern(String pattern) {
        this.pattern = pattern;
    }

    static GlobPattern create(String pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException();
        }
        return new GlobPattern(pattern);
    }

    boolean matches(String toMatch) {
        if (WILDCARD_ALL.equals(this.pattern)) {
            return true;
        }
        if (toMatch == null) {
            return false;
        }
        if (this.containsWildCard()) {
            return GlobPattern.matches(this.pattern, toMatch);
        }
        return this.pattern.equals(toMatch) || Text.isDescendant(this.pattern, toMatch);
    }

    boolean matches(Item itemToMatch) {
        try {
            return this.matches(itemToMatch.getPath());
        }
        catch (RepositoryException e) {
            log.error("Unable to determine match.", (Object)e.getMessage());
            return false;
        }
    }

    private boolean containsWildCard() {
        return this.pattern.indexOf(42) > -1;
    }

    private static boolean matches(String pattern, String toMatch) {
        char[] c1 = pattern.toCharArray();
        char[] c2 = toMatch.toCharArray();
        for (int i = 0; i < c1.length; ++i) {
            if (c1[i] == '*') {
                return true;
            }
            if (i < c2.length && c1[i] == c2[i]) continue;
            return false;
        }
        return false;
    }

    public int hashCode() {
        return this.pattern.hashCode();
    }

    public String toString() {
        return this.pattern;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof GlobPattern) {
            return this.pattern.equals(((GlobPattern)obj).pattern);
        }
        return false;
    }
}

