/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.nodetype.compact;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.jcr.NamespaceException;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.version.OnParentVersionAction;
import org.apache.jackrabbit.core.nodetype.ItemDef;
import org.apache.jackrabbit.core.nodetype.NodeDef;
import org.apache.jackrabbit.core.nodetype.NodeTypeDef;
import org.apache.jackrabbit.core.nodetype.PropDef;
import org.apache.jackrabbit.core.nodetype.ValueConstraint;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.namespace.NamespaceResolver;
import org.apache.jackrabbit.util.ISO9075;

public class CompactNodeTypeDefWriter {
    private static final String INDENT = "  ";
    private final NamespaceResolver resolver;
    private final NamePathResolver npResolver;
    private Writer out;
    private Writer nsWriter;
    private HashSet usedNamespaces = new HashSet();

    public CompactNodeTypeDefWriter(Writer out, NamespaceResolver r, NamePathResolver npResolver) {
        this(out, r, npResolver, false);
    }

    public CompactNodeTypeDefWriter(Writer out, NamespaceResolver r, NamePathResolver npResolver, boolean includeNS) {
        this.resolver = r;
        this.npResolver = npResolver;
        if (includeNS) {
            this.out = new StringWriter();
            this.nsWriter = out;
        } else {
            this.out = out;
            this.nsWriter = null;
        }
    }

    public static void write(List l, NamespaceResolver r, NamePathResolver npResolver, Writer out) throws IOException {
        CompactNodeTypeDefWriter w = new CompactNodeTypeDefWriter(out, r, npResolver, true);
        Iterator iter = l.iterator();
        while (iter.hasNext()) {
            NodeTypeDef def = (NodeTypeDef)iter.next();
            w.write(def);
        }
        w.close();
    }

    public void write(NodeTypeDef d) throws IOException {
        this.writeName(d);
        this.writeSupertypes(d);
        this.writeOptions(d);
        this.writePropDefs(d);
        this.writeNodeDefs(d);
        this.out.write("\n\n");
    }

    public void close() throws IOException {
        if (this.nsWriter != null) {
            this.nsWriter.write("\n");
            this.out.close();
            this.nsWriter.write(((StringWriter)this.out).getBuffer().toString());
            this.out = this.nsWriter;
            this.nsWriter = null;
        }
        this.out.flush();
        this.out = null;
    }

    private void writeName(NodeTypeDef ntd) throws IOException {
        this.out.write("[");
        this.out.write(this.resolve(ntd.getName()));
        this.out.write("]");
    }

    private void writeSupertypes(NodeTypeDef ntd) throws IOException {
        Name[] sta = ntd.getSupertypes();
        String delim = " > ";
        for (int i = 0; i < sta.length; ++i) {
            this.out.write(delim);
            this.out.write(this.resolve(sta[i]));
            delim = ", ";
        }
    }

    private void writeOptions(NodeTypeDef ntd) throws IOException {
        if (ntd.hasOrderableChildNodes()) {
            this.out.write("\n  ");
            this.out.write("orderable");
            if (ntd.isMixin()) {
                this.out.write(" mixin");
            }
        } else if (ntd.isMixin()) {
            this.out.write("\n  ");
            this.out.write("mixin");
        }
    }

    private void writePropDefs(NodeTypeDef ntd) throws IOException {
        PropDef[] pda = ntd.getPropertyDefs();
        for (int i = 0; i < pda.length; ++i) {
            PropDef pd = pda[i];
            this.writePropDef(ntd, pd);
        }
    }

    private void writeNodeDefs(NodeTypeDef ntd) throws IOException {
        NodeDef[] nda = ntd.getChildNodeDefs();
        for (int i = 0; i < nda.length; ++i) {
            NodeDef nd = nda[i];
            this.writeNodeDef(ntd, nd);
        }
    }

    private void writePropDef(NodeTypeDef ntd, PropDef pd) throws IOException {
        this.out.write("\n  - ");
        Name name = pd.getName();
        if (name.equals(ItemDef.ANY_NAME)) {
            this.out.write(42);
        } else {
            this.writeItemDefName(name);
        }
        this.out.write(" (");
        this.out.write(PropertyType.nameFromValue(pd.getRequiredType()).toLowerCase());
        this.out.write(")");
        this.writeDefaultValues(pd.getDefaultValues());
        this.out.write(ntd.getPrimaryItemName() != null && ntd.getPrimaryItemName().equals(pd.getName()) ? " primary" : "");
        if (pd.isMandatory()) {
            this.out.write(" mandatory");
        }
        if (pd.isAutoCreated()) {
            this.out.write(" autocreated");
        }
        if (pd.isProtected()) {
            this.out.write(" protected");
        }
        if (pd.isMultiple()) {
            this.out.write(" multiple");
        }
        if (pd.getOnParentVersion() != 1) {
            this.out.write(" ");
            this.out.write(OnParentVersionAction.nameFromValue(pd.getOnParentVersion()).toLowerCase());
        }
        this.writeValueConstraints(pd.getValueConstraints());
    }

    private void writeDefaultValues(InternalValue[] dva) throws IOException {
        if (dva != null && dva.length > 0) {
            String delim = " = '";
            for (int i = 0; i < dva.length; ++i) {
                this.out.write(delim);
                try {
                    this.out.write(this.escape(dva[i].toJCRValue(this.npResolver).getString()));
                }
                catch (RepositoryException e) {
                    this.out.write(this.escape(dva[i].toString()));
                }
                this.out.write("'");
                delim = ", '";
            }
        }
    }

    private void writeValueConstraints(ValueConstraint[] vca) throws IOException {
        if (vca != null && vca.length > 0) {
            String vc = vca[0].getDefinition(this.npResolver);
            this.out.write(" < '");
            this.out.write(this.escape(vc));
            this.out.write("'");
            for (int i = 1; i < vca.length; ++i) {
                vc = vca[i].getDefinition(this.npResolver);
                this.out.write(", '");
                this.out.write(this.escape(vc));
                this.out.write("'");
            }
        }
    }

    private void writeNodeDef(NodeTypeDef ntd, NodeDef nd) throws IOException {
        this.out.write("\n  + ");
        Name name = nd.getName();
        this.writeItemDefName(name);
        this.writeRequiredTypes(nd.getRequiredPrimaryTypes());
        this.writeDefaultType(nd.getDefaultPrimaryType());
        this.out.write(ntd.getPrimaryItemName() != null && ntd.getPrimaryItemName().equals(nd.getName()) ? " primary" : "");
        if (nd.isMandatory()) {
            this.out.write(" mandatory");
        }
        if (nd.isAutoCreated()) {
            this.out.write(" autocreated");
        }
        if (nd.isProtected()) {
            this.out.write(" protected");
        }
        if (nd.allowsSameNameSiblings()) {
            this.out.write(" multiple");
        }
        if (nd.getOnParentVersion() != 1) {
            this.out.write(" ");
            this.out.write(OnParentVersionAction.nameFromValue(nd.getOnParentVersion()).toLowerCase());
        }
    }

    private void writeItemDefName(Name name) throws IOException {
        if (name.equals(ItemDef.ANY_NAME)) {
            this.out.write(42);
        } else {
            this.out.write(this.resolve(name));
        }
    }

    private void writeRequiredTypes(Name[] reqTypes) throws IOException {
        if (reqTypes != null && reqTypes.length > 0) {
            String delim = " (";
            for (int i = 0; i < reqTypes.length; ++i) {
                this.out.write(delim);
                this.out.write(this.resolve(reqTypes[i]));
                delim = ", ";
            }
            this.out.write(")");
        }
    }

    private void writeDefaultType(Name defType) throws IOException {
        if (defType != null && !defType.getLocalName().equals("*")) {
            this.out.write(" = ");
            this.out.write(this.resolve(defType));
        }
    }

    private String resolve(Name qname) throws IOException {
        if (qname == null) {
            return "";
        }
        try {
            String prefix = this.resolver.getPrefix(qname.getNamespaceURI());
            if (this.nsWriter != null && !this.usedNamespaces.contains(prefix)) {
                this.usedNamespaces.add(prefix);
                this.nsWriter.write("<'");
                this.nsWriter.write(prefix);
                this.nsWriter.write("'='");
                this.nsWriter.write(this.escape(qname.getNamespaceURI()));
                this.nsWriter.write("'>\n");
            }
            if (!prefix.equals("")) {
                prefix = prefix + ":";
            }
            String encLocalName = ISO9075.encode(qname.getLocalName());
            String resolvedName = prefix + encLocalName;
            if (resolvedName.indexOf(45) >= 0 || resolvedName.indexOf(43) >= 0) {
                return "'" + resolvedName + "'";
            }
            return resolvedName;
        }
        catch (NamespaceException e) {
            return qname.toString();
        }
    }

    private String escape(String s) {
        StringBuffer sb = new StringBuffer(s);
        for (int i = 0; i < sb.length(); ++i) {
            if (sb.charAt(i) == '\\') {
                sb.insert(i, '\\');
                ++i;
                continue;
            }
            if (sb.charAt(i) != '\'') continue;
            sb.insert(i, '\'');
            ++i;
        }
        return sb.toString();
    }
}

