/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.usermodel;

import java.awt.Dimension;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import org.apache.poi.ddf.EscherBSERecord;
import org.apache.poi.ddf.EscherContainerRecord;
import org.apache.poi.ddf.EscherRecord;
import org.apache.poi.hslf.HSLFSlideShow;
import org.apache.poi.hslf.exceptions.CorruptPowerPointFileException;
import org.apache.poi.hslf.exceptions.HSLFException;
import org.apache.poi.hslf.model.MasterSheet;
import org.apache.poi.hslf.model.Shape;
import org.apache.poi.hslf.model.SlideMaster;
import org.apache.poi.hslf.model.TitleMaster;
import org.apache.poi.hslf.record.Document;
import org.apache.poi.hslf.record.DocumentAtom;
import org.apache.poi.hslf.record.FontCollection;
import org.apache.poi.hslf.record.MainMaster;
import org.apache.poi.hslf.record.Notes;
import org.apache.poi.hslf.record.ParentAwareRecord;
import org.apache.poi.hslf.record.PersistPtrHolder;
import org.apache.poi.hslf.record.PositionDependentRecord;
import org.apache.poi.hslf.record.PositionDependentRecordContainer;
import org.apache.poi.hslf.record.Record;
import org.apache.poi.hslf.record.RecordContainer;
import org.apache.poi.hslf.record.RecordTypes;
import org.apache.poi.hslf.record.Slide;
import org.apache.poi.hslf.record.SlideListWithText;
import org.apache.poi.hslf.record.SlidePersistAtom;
import org.apache.poi.hslf.record.UserEditAtom;
import org.apache.poi.hslf.usermodel.PictureData;
import org.apache.poi.util.ArrayUtil;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;

public class SlideShow {
    private HSLFSlideShow _hslfSlideShow;
    private Record[] _records;
    private Record[] _mostRecentCoreRecords;
    private Hashtable _sheetIdToCoreRecordsLookup;
    private int _highestSheetId;
    private Document _documentRecord;
    private SlideMaster[] _masters;
    private TitleMaster[] _titleMasters;
    private org.apache.poi.hslf.model.Slide[] _slides;
    private org.apache.poi.hslf.model.Notes[] _notes;
    private FontCollection _fonts;
    private POILogger logger = POILogFactory.getLogger(this.getClass());

    public SlideShow(HSLFSlideShow hslfSlideShow) throws IOException {
        this._hslfSlideShow = hslfSlideShow;
        this._records = this._hslfSlideShow.getRecords();
        for (int i = 0; i < this._records.length; ++i) {
            this.handleParentAwareRecords(this._records[i]);
        }
        this.findMostRecentCoreRecords();
        this.buildSlidesAndNotes();
    }

    public SlideShow() throws IOException {
        this(new HSLFSlideShow());
    }

    public SlideShow(InputStream inputStream) throws IOException {
        this(new HSLFSlideShow(inputStream));
    }

    private void handleParentAwareRecords(Record baseRecord) {
        if (baseRecord instanceof RecordContainer) {
            RecordContainer br = (RecordContainer)baseRecord;
            Record[] childRecords = br.getChildRecords();
            for (int i = 0; i < childRecords.length; ++i) {
                Record record = childRecords[i];
                if (record instanceof ParentAwareRecord) {
                    ((ParentAwareRecord)((Object)record)).setParentRecord(br);
                }
                if (!(record instanceof RecordContainer)) continue;
                this.handleParentAwareRecords(record);
            }
        }
    }

    private void findMostRecentCoreRecords() {
        int i;
        Hashtable mostRecentByBytes = new Hashtable();
        for (int i2 = 0; i2 < this._records.length; ++i2) {
            if (!(this._records[i2] instanceof PersistPtrHolder)) continue;
            PersistPtrHolder pph = (PersistPtrHolder)this._records[i2];
            int[] ids = pph.getKnownSlideIDs();
            for (int j = 0; j < ids.length; ++j) {
                Integer id = new Integer(ids[j]);
                if (!mostRecentByBytes.containsKey(id)) continue;
                mostRecentByBytes.remove(id);
            }
            Hashtable thisSetOfLocations = pph.getSlideLocationsLookup();
            for (int j = 0; j < ids.length; ++j) {
                Integer id = new Integer(ids[j]);
                mostRecentByBytes.put(id, thisSetOfLocations.get(id));
            }
        }
        this._mostRecentCoreRecords = new Record[mostRecentByBytes.size()];
        this._sheetIdToCoreRecordsLookup = new Hashtable();
        int[] allIDs = new int[this._mostRecentCoreRecords.length];
        Enumeration ids = mostRecentByBytes.keys();
        for (i = 0; i < allIDs.length; ++i) {
            Integer id = (Integer)ids.nextElement();
            allIDs[i] = id;
        }
        Arrays.sort(allIDs);
        for (i = 0; i < allIDs.length; ++i) {
            this._sheetIdToCoreRecordsLookup.put(new Integer(allIDs[i]), new Integer(i));
        }
        this._highestSheetId = allIDs[allIDs.length - 1];
        for (i = 0; i < this._records.length; ++i) {
            if (!(this._records[i] instanceof PositionDependentRecord)) continue;
            PositionDependentRecord pdr = (PositionDependentRecord)((Object)this._records[i]);
            Integer recordAt = new Integer(pdr.getLastOnDiskOffset());
            for (int j = 0; j < allIDs.length; ++j) {
                Integer thisID = new Integer(allIDs[j]);
                Integer thatRecordAt = (Integer)mostRecentByBytes.get(thisID);
                if (!thatRecordAt.equals(recordAt)) continue;
                Integer storeAtI = (Integer)this._sheetIdToCoreRecordsLookup.get(thisID);
                int storeAt = storeAtI;
                if (pdr instanceof PositionDependentRecordContainer) {
                    PositionDependentRecordContainer pdrc = (PositionDependentRecordContainer)this._records[i];
                    pdrc.setSheetId(thisID);
                }
                this._mostRecentCoreRecords[storeAt] = this._records[i];
            }
        }
        for (i = 0; i < this._mostRecentCoreRecords.length; ++i) {
            if (this._mostRecentCoreRecords[i] == null || this._mostRecentCoreRecords[i].getRecordType() != (long)RecordTypes.Document.typeID) continue;
            this._documentRecord = (Document)this._mostRecentCoreRecords[i];
            this._fonts = this._documentRecord.getEnvironment().getFontCollection();
        }
    }

    private Record getCoreRecordForSAS(SlideListWithText.SlideAtomsSet sas) {
        SlidePersistAtom spa = sas.getSlidePersistAtom();
        int refID = spa.getRefID();
        return this.getCoreRecordForRefID(refID);
    }

    private Record getCoreRecordForRefID(int refID) {
        Integer coreRecordId = (Integer)this._sheetIdToCoreRecordsLookup.get(new Integer(refID));
        if (coreRecordId != null) {
            Record r = this._mostRecentCoreRecords[coreRecordId];
            return r;
        }
        this.logger.log(7, "We tried to look up a reference to a core record, but there was no core ID for reference ID " + refID);
        return null;
    }

    private void buildSlidesAndNotes() {
        int i;
        Slide[] slidesRecords;
        Notes[] notesRecords;
        if (this._documentRecord == null) {
            throw new CorruptPowerPointFileException("The PowerPoint file didn't contain a Document Record in its PersistPtr blocks. It is probably corrupt.");
        }
        SlideListWithText masterSLWT = this._documentRecord.getMasterSlideListWithText();
        SlideListWithText slidesSLWT = this._documentRecord.getSlideSlideListWithText();
        SlideListWithText notesSLWT = this._documentRecord.getNotesSlideListWithText();
        SlideListWithText.SlideAtomsSet[] masterSets = new SlideListWithText.SlideAtomsSet[]{};
        if (masterSLWT != null) {
            masterSets = masterSLWT.getSlideAtomsSets();
            ArrayList<MasterSheet> mmr = new ArrayList<MasterSheet>();
            ArrayList<MasterSheet> tmr = new ArrayList<MasterSheet>();
            for (int i2 = 0; i2 < masterSets.length; ++i2) {
                MasterSheet master;
                Record r = this.getCoreRecordForSAS(masterSets[i2]);
                SlideListWithText.SlideAtomsSet sas = masterSets[i2];
                int sheetNo = sas.getSlidePersistAtom().getSlideIdentifier();
                if (r instanceof Slide) {
                    master = new TitleMaster((Slide)r, sheetNo);
                    master.setSlideShow(this);
                    tmr.add(master);
                    continue;
                }
                if (!(r instanceof MainMaster)) continue;
                master = new SlideMaster((MainMaster)r, sheetNo);
                ((SlideMaster)master).setSlideShow(this);
                mmr.add(master);
            }
            this._masters = new SlideMaster[mmr.size()];
            mmr.toArray(this._masters);
            this._titleMasters = new TitleMaster[tmr.size()];
            tmr.toArray(this._titleMasters);
        }
        SlideListWithText.SlideAtomsSet[] notesSets = new SlideListWithText.SlideAtomsSet[]{};
        Hashtable<Integer, Integer> slideIdToNotes = new Hashtable<Integer, Integer>();
        if (notesSLWT == null) {
            notesRecords = new Notes[]{};
        } else {
            notesSets = notesSLWT.getSlideAtomsSets();
            ArrayList<Notes> notesRecordsL = new ArrayList<Notes>();
            for (int i3 = 0; i3 < notesSets.length; ++i3) {
                Record r = this.getCoreRecordForSAS(notesSets[i3]);
                if (r instanceof Notes) {
                    Notes notesRecord = (Notes)r;
                    notesRecordsL.add(notesRecord);
                    SlidePersistAtom spa = notesSets[i3].getSlidePersistAtom();
                    Integer slideId = new Integer(spa.getSlideIdentifier());
                    slideIdToNotes.put(slideId, new Integer(i3));
                    continue;
                }
                this.logger.log(7, "A Notes SlideAtomSet at " + i3 + " said its record was at refID " + notesSets[i3].getSlidePersistAtom().getRefID() + ", but that was actually a " + r);
            }
            notesRecords = new Notes[notesRecordsL.size()];
            notesRecords = notesRecordsL.toArray(notesRecords);
        }
        SlideListWithText.SlideAtomsSet[] slidesSets = new SlideListWithText.SlideAtomsSet[]{};
        if (slidesSLWT == null) {
            slidesRecords = new Slide[]{};
        } else {
            slidesSets = slidesSLWT.getSlideAtomsSets();
            slidesRecords = new Slide[slidesSets.length];
            for (int i4 = 0; i4 < slidesSets.length; ++i4) {
                Record r = this.getCoreRecordForSAS(slidesSets[i4]);
                if (r instanceof Slide) {
                    slidesRecords[i4] = (Slide)r;
                    continue;
                }
                this.logger.log(7, "A Slide SlideAtomSet at " + i4 + " said its record was at refID " + slidesSets[i4].getSlidePersistAtom().getRefID() + ", but that was actually a " + r);
            }
        }
        this._notes = new org.apache.poi.hslf.model.Notes[notesRecords.length];
        for (i = 0; i < this._notes.length; ++i) {
            this._notes[i] = new org.apache.poi.hslf.model.Notes(notesRecords[i]);
            this._notes[i].setSlideShow(this);
        }
        this._slides = new org.apache.poi.hslf.model.Slide[slidesRecords.length];
        for (i = 0; i < this._slides.length; ++i) {
            SlideListWithText.SlideAtomsSet sas = slidesSets[i];
            int slideIdentifier = sas.getSlidePersistAtom().getSlideIdentifier();
            org.apache.poi.hslf.model.Notes notes = null;
            int noteId = slidesRecords[i].getSlideAtom().getNotesID();
            if (noteId != 0) {
                Integer notesPos = (Integer)slideIdToNotes.get(new Integer(noteId));
                if (notesPos != null) {
                    notes = this._notes[notesPos];
                } else {
                    this.logger.log(7, "Notes not found for noteId=" + noteId);
                }
            }
            this._slides[i] = new org.apache.poi.hslf.model.Slide(slidesRecords[i], notes, sas, slideIdentifier, i + 1);
            this._slides[i].setSlideShow(this);
        }
    }

    public void write(OutputStream out) throws IOException {
        this._hslfSlideShow.write(out);
    }

    public Record[] getMostRecentCoreRecords() {
        return this._mostRecentCoreRecords;
    }

    public org.apache.poi.hslf.model.Slide[] getSlides() {
        return this._slides;
    }

    public org.apache.poi.hslf.model.Notes[] getNotes() {
        return this._notes;
    }

    public SlideMaster[] getSlidesMasters() {
        return this._masters;
    }

    public TitleMaster[] getTitleMasters() {
        return this._titleMasters;
    }

    public PictureData[] getPictureData() {
        return this._hslfSlideShow.getPictures();
    }

    public Dimension getPageSize() {
        DocumentAtom docatom = this._documentRecord.getDocumentAtom();
        int pgx = (int)docatom.getSlideSizeX() * 72 / 576;
        int pgy = (int)docatom.getSlideSizeY() * 72 / 576;
        return new Dimension(pgx, pgy);
    }

    public void setPageSize(Dimension pgsize) {
        DocumentAtom docatom = this._documentRecord.getDocumentAtom();
        docatom.setSlideSizeX(pgsize.width * 576 / 72);
        docatom.setSlideSizeY(pgsize.height * 576 / 72);
    }

    protected FontCollection getFontCollection() {
        return this._fonts;
    }

    public Document getDocumentRecord() {
        return this._documentRecord;
    }

    public void reorderSlide(int oldSlideNumer, int newSlideNumber) {
        if (oldSlideNumer < 1 || newSlideNumber < 1) {
            throw new IllegalArgumentException("Old and new slide numbers must be greater than 0");
        }
        if (oldSlideNumer > this._slides.length || newSlideNumber > this._slides.length) {
            throw new IllegalArgumentException("Old and new slide numbers must not exceed the number of slides (" + this._slides.length + ")");
        }
        SlideListWithText slwt = this._documentRecord.getSlideSlideListWithText();
        slwt.repositionSlideAtomsSet(slwt.getSlideAtomsSets()[oldSlideNumer - 1], newSlideNumber - 1);
        ArrayUtil.arrayMoveWithin(this._slides, oldSlideNumer - 1, newSlideNumber - 1, 1);
        for (int i = 0; i < this._slides.length; ++i) {
            this._slides[i].setSlideNumber(i + 1);
        }
    }

    public org.apache.poi.hslf.model.Slide createSlide() throws IOException {
        SlideListWithText slist = null;
        slist = this._documentRecord.getSlideSlideListWithText();
        if (slist == null) {
            slist = new SlideListWithText();
            this._documentRecord.addSlideListWithText(slist);
        }
        SlidePersistAtom prev = null;
        SlideListWithText.SlideAtomsSet[] sas = slist.getSlideAtomsSets();
        for (int j = 0; j < sas.length; ++j) {
            SlidePersistAtom spa = sas[j].getSlidePersistAtom();
            if (spa.getSlideIdentifier() < 0) continue;
            if (prev == null) {
                prev = spa;
            }
            if (prev.getSlideIdentifier() >= spa.getSlideIdentifier()) continue;
            prev = spa;
        }
        SlidePersistAtom sp = new SlidePersistAtom();
        ++this._highestSheetId;
        sp.setRefID(this._highestSheetId);
        sp.setSlideIdentifier(prev == null ? 256 : prev.getSlideIdentifier() + 1);
        slist.addSlidePersistAtom(sp);
        org.apache.poi.hslf.model.Slide slide = new org.apache.poi.hslf.model.Slide(sp.getSlideIdentifier(), sp.getRefID(), this._slides.length + 1);
        org.apache.poi.hslf.model.Slide[] s = new org.apache.poi.hslf.model.Slide[this._slides.length + 1];
        System.arraycopy(this._slides, 0, s, 0, this._slides.length);
        s[this._slides.length] = slide;
        this._slides = s;
        this.logger.log(3, "Added slide " + this._slides.length + " with ref " + sp.getRefID() + " and identifier " + sp.getSlideIdentifier());
        Slide slideRecord = slide.getSlideRecord();
        slideRecord.setSheetId(sp.getRefID());
        int slideRecordPos = this._hslfSlideShow.appendRootLevelRecord(slideRecord);
        this._records = this._hslfSlideShow.getRecords();
        int offset = 0;
        int slideOffset = 0;
        PersistPtrHolder ptr = null;
        UserEditAtom usr = null;
        for (int i = 0; i < this._records.length; ++i) {
            Record record = this._records[i];
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            record.writeOut(out);
            if (this._records[i].getRecordType() == (long)RecordTypes.PersistPtrIncrementalBlock.typeID) {
                ptr = (PersistPtrHolder)this._records[i];
            }
            if (this._records[i].getRecordType() == (long)RecordTypes.UserEditAtom.typeID) {
                usr = (UserEditAtom)this._records[i];
            }
            if (i == slideRecordPos) {
                slideOffset = offset;
            }
            offset += out.size();
        }
        slideRecord.setLastOnDiskOffset(slideOffset);
        ptr.addSlideLookup(sp.getRefID(), slideOffset);
        this.logger.log(3, "New slide ended up at " + slideOffset);
        usr.setLastViewType((short)1);
        usr.setMaxPersistWritten(this._highestSheetId);
        slide.setSlideShow(this);
        return slide;
    }

    public int addPicture(byte[] data, int format) throws IOException {
        int i;
        byte[] uid = PictureData.getChecksum(data);
        int offset = 0;
        EscherContainerRecord dggContainer = this._documentRecord.getPPDrawingGroup().getDggContainer();
        EscherContainerRecord bstore = (EscherContainerRecord)Shape.getEscherChild(dggContainer, -4095);
        if (bstore == null) {
            bstore = new EscherContainerRecord();
            bstore.setRecordId((short)-4095);
            List child = dggContainer.getChildRecords();
            for (i = 0; i < child.size(); ++i) {
                EscherRecord rec = (EscherRecord)child.get(i);
                if (rec.getRecordId() != -4085) continue;
                child.add(i, bstore);
                ++i;
            }
            dggContainer.setChildRecords(child);
        } else {
            List lst = bstore.getChildRecords();
            for (i = 0; i < lst.size(); ++i) {
                EscherBSERecord bse = (EscherBSERecord)lst.get(i);
                if (Arrays.equals(bse.getUid(), uid)) {
                    return i + 1;
                }
                offset += bse.getSize();
            }
        }
        PictureData pict = PictureData.create(format);
        pict.setData(data);
        pict.setOffset(offset);
        EscherBSERecord bse = new EscherBSERecord();
        bse.setRecordId((short)-4089);
        bse.setOptions((short)(2 | format << 4));
        bse.setSize(pict.getRawData().length + 8);
        bse.setUid(uid);
        bse.setBlipTypeMacOS((byte)format);
        bse.setBlipTypeWin32((byte)format);
        if (format == 2) {
            bse.setBlipTypeMacOS((byte)4);
        } else if (format == 3) {
            bse.setBlipTypeMacOS((byte)4);
        } else if (format == 4) {
            bse.setBlipTypeWin32((byte)3);
        }
        bse.setRef(1);
        bse.setOffset(offset);
        bstore.addChildRecord(bse);
        int count = bstore.getChildRecords().size();
        bstore.setOptions((short)(count << 4 | 0xF));
        this._hslfSlideShow.addPicture(pict);
        return count;
    }

    public int addPicture(File pict, int format) throws IOException {
        int length = (int)pict.length();
        byte[] data = new byte[length];
        try {
            FileInputStream is = new FileInputStream(pict);
            is.read(data);
            is.close();
        }
        catch (IOException e) {
            throw new HSLFException(e);
        }
        return this.addPicture(data, format);
    }
}

