/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.rmi.value;

import java.io.Serializable;
import java.util.Calendar;
import javax.jcr.ValueFormatException;
import org.apache.jackrabbit.rmi.value.BaseNonStreamValue;
import org.apache.jackrabbit.rmi.value.StatefulValue;

public class LongValue
extends BaseNonStreamValue
implements Serializable,
StatefulValue {
    private static final long serialVersionUID = 2115837525193497922L;
    private final long value;

    protected LongValue(long value) {
        this.value = value;
    }

    protected LongValue(String value) throws ValueFormatException {
        this(LongValue.toLong(value));
    }

    protected static long toLong(String value) throws ValueFormatException {
        try {
            return Long.valueOf(value);
        }
        catch (NumberFormatException e) {
            throw new ValueFormatException(e);
        }
    }

    public int getType() {
        return 3;
    }

    public Calendar getDate() throws ValueFormatException {
        Calendar date = Calendar.getInstance();
        date.setTimeInMillis(this.value);
        return date;
    }

    public long getLong() {
        return this.value;
    }

    public String getString() {
        return Long.toString(this.value);
    }

    public double getDouble() {
        return this.value;
    }
}

