/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.rmi.server;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.rmi.RemoteException;
import javax.jcr.Credentials;
import javax.jcr.Item;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import org.apache.jackrabbit.rmi.remote.RemoteItem;
import org.apache.jackrabbit.rmi.remote.RemoteNode;
import org.apache.jackrabbit.rmi.remote.RemoteProperty;
import org.apache.jackrabbit.rmi.remote.RemoteSession;
import org.apache.jackrabbit.rmi.remote.RemoteWorkspace;
import org.apache.jackrabbit.rmi.remote.security.RemoteAccessControlManager;
import org.apache.jackrabbit.rmi.server.RemoteAdapterFactory;
import org.apache.jackrabbit.rmi.server.ServerObject;

public class ServerSession
extends ServerObject
implements RemoteSession {
    private Session session;
    private RemoteWorkspace remoteWorkspace;

    public ServerSession(Session session, RemoteAdapterFactory factory) throws RemoteException {
        super(factory);
        this.session = session;
    }

    @Override
    public String getUserID() throws RemoteException {
        return this.session.getUserID();
    }

    @Override
    public Object getAttribute(String name) throws RemoteException {
        return this.session.getAttribute(name);
    }

    @Override
    public String[] getAttributeNames() throws RemoteException {
        return this.session.getAttributeNames();
    }

    @Override
    public RemoteSession impersonate(Credentials credentials) throws RepositoryException, RemoteException {
        try {
            Session newSession = this.session.impersonate(credentials);
            return this.getFactory().getRemoteSession(newSession);
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    @Override
    public RemoteWorkspace getWorkspace() throws RemoteException {
        if (this.remoteWorkspace == null) {
            this.remoteWorkspace = this.getFactory().getRemoteWorkspace(this.session.getWorkspace());
        }
        return this.remoteWorkspace;
    }

    @Override
    public boolean hasPermission(String path, String actions) throws RepositoryException, RemoteException {
        return this.session.hasPermission(path, actions);
    }

    @Override
    public String getNamespacePrefix(String uri) throws RepositoryException, RemoteException {
        try {
            return this.session.getNamespacePrefix(uri);
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    @Override
    public String[] getNamespacePrefixes() throws RepositoryException, RemoteException {
        try {
            return this.session.getNamespacePrefixes();
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    @Override
    public String getNamespaceURI(String prefix) throws RepositoryException, RemoteException {
        try {
            return this.session.getNamespaceURI(prefix);
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    @Override
    public void setNamespacePrefix(String prefix, String uri) throws RepositoryException, RemoteException {
        try {
            this.session.setNamespacePrefix(prefix, uri);
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    @Override
    public boolean itemExists(String path) throws RepositoryException, RemoteException {
        return this.session.itemExists(path);
    }

    @Override
    public boolean nodeExists(String path) throws RepositoryException, RemoteException {
        return this.session.nodeExists(path);
    }

    @Override
    public boolean propertyExists(String path) throws RepositoryException, RemoteException {
        return this.session.propertyExists(path);
    }

    @Override
    public RemoteNode getNodeByIdentifier(String id) throws RepositoryException, RemoteException {
        try {
            return this.getRemoteNode(this.session.getNodeByIdentifier(id));
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    @Override
    public RemoteNode getNodeByUUID(String uuid) throws RepositoryException, RemoteException {
        try {
            return this.getRemoteNode(this.session.getNodeByUUID(uuid));
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    @Override
    public RemoteNode getRootNode() throws RepositoryException, RemoteException {
        try {
            return this.getRemoteNode(this.session.getRootNode());
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    @Override
    public RemoteItem getItem(String path) throws RepositoryException, RemoteException {
        try {
            return this.getRemoteItem(this.session.getItem(path));
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    @Override
    public RemoteNode getNode(String path) throws RepositoryException, RemoteException {
        try {
            return this.getRemoteNode(this.session.getNode(path));
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    @Override
    public RemoteProperty getProperty(String path) throws RepositoryException, RemoteException {
        try {
            return (RemoteProperty)this.getRemoteItem((Item)this.session.getProperty(path));
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    @Override
    public boolean hasPendingChanges() throws RepositoryException, RemoteException {
        try {
            return this.session.hasPendingChanges();
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    @Override
    public void removeItem(String path) throws RepositoryException, RemoteException {
        try {
            this.session.removeItem(path);
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    @Override
    public void move(String from, String to) throws RepositoryException, RemoteException {
        try {
            this.session.move(from, to);
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    @Override
    public void save() throws RepositoryException, RemoteException {
        try {
            this.session.save();
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    @Override
    public void refresh(boolean keepChanges) throws RepositoryException, RemoteException {
        try {
            this.session.refresh(keepChanges);
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    @Override
    public void logout() throws RemoteException {
        this.session.logout();
    }

    @Override
    public boolean isLive() throws RemoteException {
        return this.session.isLive();
    }

    @Override
    public void importXML(String path, byte[] xml, int mode) throws IOException, RepositoryException, RemoteException {
        try {
            this.session.importXML(path, (InputStream)new ByteArrayInputStream(xml), mode);
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    @Override
    public void addLockToken(String token) throws RemoteException {
        this.session.addLockToken(token);
    }

    @Override
    public String[] getLockTokens() throws RemoteException {
        return this.session.getLockTokens();
    }

    @Override
    public void removeLockToken(String token) throws RemoteException {
        this.session.removeLockToken(token);
    }

    @Override
    public byte[] exportDocumentView(String path, boolean binaryAsLink, boolean noRecurse) throws IOException, RepositoryException, RemoteException {
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            this.session.exportDocumentView(path, (OutputStream)buffer, binaryAsLink, noRecurse);
            return buffer.toByteArray();
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    @Override
    public byte[] exportSystemView(String path, boolean binaryAsLink, boolean noRecurse) throws IOException, RepositoryException, RemoteException {
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            this.session.exportSystemView(path, (OutputStream)buffer, binaryAsLink, noRecurse);
            return buffer.toByteArray();
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    @Override
    public RemoteAccessControlManager getAccessControlManager() throws UnsupportedRepositoryOperationException, RepositoryException, RemoteException {
        try {
            return this.getFactory().getRemoteAccessControlManager(this.session.getAccessControlManager());
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }
}

