/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.xhtml.applib;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.util.Map;
import org.apache.isis.viewer.xhtml.applib.StringUtils;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

final class UrlConnectionUtils {
    static final String MIME_TYPE = "application/xhtml+xml";

    private UrlConnectionUtils() {
    }

    static void writeMapToConnectionOutputStream(Map<String, String> formArgumentsByParameter, HttpURLConnection connection) throws IOException {
        OutputStream os = connection.getOutputStream();
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(os));
        StringUtils.writeMap(formArgumentsByParameter, writer);
    }

    static Document readDocFromConnectionInputStream(HttpURLConnection connection) throws JDOMException, IOException {
        InputStream stream = connection.getInputStream();
        SAXBuilder saxBuilder = new SAXBuilder();
        return saxBuilder.build(stream);
    }

    static HttpURLConnection createConnection(String uri) throws MalformedURLException, IOException {
        URL url = new URL(uri);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setInstanceFollowRedirects(false);
        connection.setRequestProperty("Content-Type", MIME_TYPE);
        return connection;
    }

    static HttpURLConnection createPostConnection(String uri) throws IOException, ProtocolException {
        HttpURLConnection connection = UrlConnectionUtils.createConnection(uri);
        connection.setDoOutput(true);
        connection.setRequestMethod("POST");
        return connection;
    }

    static HttpURLConnection createGetConnection(String uri) throws IOException, ProtocolException {
        HttpURLConnection connection = UrlConnectionUtils.createConnection(uri);
        connection.setRequestMethod("GET");
        return connection;
    }
}

