/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.xhtml.applib;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.util.Map;
import org.apache.isis.viewer.xhtml.applib.RestfulClientException;
import org.apache.isis.viewer.xhtml.applib.StringUtils;
import org.apache.isis.viewer.xhtml.applib.UrlConnectionUtils;
import org.apache.isis.viewer.xhtml.applib.UrlEncodeUtils;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.output.XMLOutputter;

public abstract class AbstractRestfulClient {
    private static Logger LOG = Logger.getLogger(AbstractRestfulClient.class);
    private final String hostUri;

    public String getHostUri() {
        return this.hostUri;
    }

    public AbstractRestfulClient(String hostUri) {
        this.hostUri = hostUri;
    }

    public Document get(String uri) throws RestfulClientException {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("getting from '" + uri + "'"));
        }
        try {
            HttpURLConnection connection = UrlConnectionUtils.createGetConnection(uri);
            Document document = UrlConnectionUtils.readDocFromConnectionInputStream(connection);
            if (LOG.isTraceEnabled()) {
                StringWriter sw = new StringWriter();
                new XMLOutputter().output(document, (Writer)sw);
                LOG.trace((Object)sw.toString());
            }
            return document;
        }
        catch (ProtocolException e) {
            throw new RestfulClientException(e);
        }
        catch (IOException e) {
            throw new RestfulClientException(e);
        }
        catch (JDOMException e) {
            throw new RestfulClientException(e);
        }
    }

    public Document post(String uri, String ... paramArgs) {
        return this.post(uri, StringUtils.asMap(paramArgs));
    }

    private Document post(String uri, Map<String, String> formArgumentsByParameter) {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("posting form arguments to '" + uri + "'"));
            LOG.info((Object)StringUtils.asString(formArgumentsByParameter));
        }
        try {
            Map<String, String> encodedMap = UrlEncodeUtils.urlEncode(formArgumentsByParameter);
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)StringUtils.asString(encodedMap));
            }
            HttpURLConnection connection = UrlConnectionUtils.createPostConnection(uri);
            UrlConnectionUtils.writeMapToConnectionOutputStream(encodedMap, connection);
            return UrlConnectionUtils.readDocFromConnectionInputStream(connection);
        }
        catch (IOException e) {
            throw new RestfulClientException(e);
        }
        catch (JDOMException e) {
            throw new RestfulClientException(e);
        }
    }

    protected static String combine(String ... pathParts) {
        StringBuilder buf = new StringBuilder();
        for (String part : pathParts) {
            buf.append(part);
        }
        return buf.toString();
    }
}

