/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.scimpi.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.isis.core.commons.debug.DebugBuilder;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.viewer.scimpi.dispatcher.DispatchException;
import org.apache.isis.viewer.scimpi.dispatcher.ScimpiException;
import org.apache.isis.viewer.scimpi.dispatcher.ScimpiNotFoundException;
import org.apache.isis.viewer.scimpi.dispatcher.context.RequestContext;
import org.apache.isis.viewer.scimpi.dispatcher.debug.DebugUsers;
import org.apache.isis.viewer.scimpi.dispatcher.debug.DebugWriter;
import org.apache.isis.viewer.scimpi.servlet.ImageLookup;

public class ServletRequestContext
extends RequestContext {
    private HttpServletRequest request;
    private HttpServletResponse response;
    private ServletContext servletContext;
    private boolean isAborted;

    public ServletRequestContext(DebugUsers debugUsers) {
        super(debugUsers);
    }

    public void append(DebugWriter view) {
        Cookie[] cookies;
        view.appendTitle("Request");
        view.appendln("Auth type", (Object)this.request.getAuthType());
        view.appendln("Character encoding", (Object)this.request.getCharacterEncoding());
        view.appendln("Class", this.request.getClass());
        view.appendln("Content type", (Object)this.request.getContentType());
        view.appendln("Context path", (Object)this.getContextPath());
        view.appendln("Locale", (Object)this.request.getLocale());
        view.appendln("Method", (Object)this.request.getMethod());
        view.appendln("Path info", (Object)this.request.getPathInfo());
        view.appendln("Path translated", (Object)this.request.getPathTranslated());
        view.appendln("Protocol", (Object)this.request.getProtocol());
        view.appendln("Query string", (Object)this.request.getQueryString());
        view.appendln("Remote host", (Object)this.request.getRemoteHost());
        view.appendln("Remote user", (Object)this.request.getRemoteUser());
        view.appendln("Real path", (Object)this.servletContext.getRealPath("/"));
        view.appendln("Scheme", (Object)this.request.getScheme());
        view.appendln("Server name", (Object)this.request.getServerName());
        view.appendln("Servlet path", (Object)this.request.getServletPath());
        view.appendln("Session", (Object)this.request.getSession());
        view.appendln("Session ID", (Object)this.request.getRequestedSessionId());
        view.appendln("URI", (Object)this.request.getRequestURI());
        view.appendln("URL", (Object)this.request.getRequestURL());
        view.appendln("User principle", (Object)this.request.getUserPrincipal());
        view.appendTitle("Cookies");
        for (Cookie cookie : cookies = this.request.getCookies()) {
            view.appendln(cookie.getName(), (Object)cookie.getValue());
        }
        Enumeration attributeNames = this.request.getAttributeNames();
        if (attributeNames.hasMoreElements()) {
            view.appendTitle("Attributes");
            while (attributeNames.hasMoreElements()) {
                String name = (String)attributeNames.nextElement();
                view.appendln(name, this.request.getAttribute(name));
            }
        }
        view.appendTitle("Headers");
        Enumeration headerNames = this.request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String name = (String)headerNames.nextElement();
            view.appendln(name, (Object)this.request.getHeader(name));
        }
        view.appendTitle("Parameters");
        Enumeration parameterNames = this.request.getParameterNames();
        while (parameterNames.hasMoreElements()) {
            String name = (String)parameterNames.nextElement();
            view.appendln(name, (Object)this.request.getParameter(name));
        }
        view.appendTitle("Servlet Context");
        ServletContext context = this.getServletContext();
        view.appendln("Name", (Object)context.getServletContextName());
        view.appendln("Server Info", (Object)context.getServerInfo());
        view.appendln("Version", (Object)(context.getMajorVersion() + "." + context.getMinorVersion()));
        view.appendln("Attributes", (Object)this.getAttributes(context));
        view.appendln("Init parameters", (Object)this.getParameters(context));
        view.appendln("Real path", (Object)context.getRealPath("/"));
        super.append((DebugBuilder)view);
    }

    private String getAttributes(ServletContext context) {
        StringBuffer buf = new StringBuffer();
        Enumeration names = context.getAttributeNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            buf.append(name + "=" + context.getAttribute(name));
        }
        return buf.toString();
    }

    private String getParameters(ServletContext context) {
        StringBuffer buf = new StringBuffer();
        Enumeration names = context.getInitParameterNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            buf.append(name + "=" + context.getInitParameter(name));
        }
        return buf.toString();
    }

    public void startRequest(HttpServletRequest request, HttpServletResponse response, ServletContext servletContext) {
        this.request = request;
        this.response = response;
        this.servletContext = servletContext;
        Enumeration parameterNames = request.getParameterNames();
        while (parameterNames.hasMoreElements()) {
            String name = (String)parameterNames.nextElement();
            this.addParameter(name, request.getParameter(name));
        }
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public PrintWriter getWriter() {
        try {
            return this.response.getWriter();
        }
        catch (IOException e) {
            throw new ScimpiException((Throwable)e);
        }
    }

    public String findFile(String fileName) {
        try {
            if (this.getServletContext().getResource(fileName) == null) {
                return null;
            }
            return fileName;
        }
        catch (MalformedURLException e) {
            throw new ScimpiException((Throwable)e);
        }
    }

    public InputStream openStream(String path) {
        InputStream in = this.servletContext.getResourceAsStream(path);
        if (in == null) {
            this.servletContext.getResourcePaths("/");
            try {
                this.servletContext.getResource(path);
            }
            catch (MalformedURLException e) {
                throw new ScimpiException((Throwable)e);
            }
            throw new ScimpiNotFoundException("Cannot find file " + path);
        }
        return in;
    }

    public void startHttpSession() {
        this.addVariable("_auth_session", this.getSession(), RequestContext.Scope.SESSION);
        HttpSession httpSession = this.request.getSession(true);
        Map sessionData = this.getSessionData();
        httpSession.setAttribute("scimpi-context", (Object)sessionData);
    }

    protected String getSessionId() {
        return this.request.getSession().getId();
    }

    public String clearSession() {
        this.request.getSession().invalidate();
        return null;
    }

    public void reset() {
        try {
            this.response.getWriter().print("<h1>RESET</h1>");
        }
        catch (IOException e) {
            throw new DispatchException((Throwable)e);
        }
        this.response.reset();
    }

    public void forward(String view) {
        try {
            this.isAborted = true;
            this.getRequest().getRequestDispatcher(view).forward((ServletRequest)this.getRequest(), (ServletResponse)this.getResponse());
        }
        catch (IOException e) {
            throw new DispatchException((Throwable)e);
        }
        catch (ServletException e) {
            throw new DispatchException((Throwable)e);
        }
    }

    public void redirectTo(String view) {
        try {
            this.isAborted = true;
            this.getResponse().sendRedirect(view);
        }
        catch (IOException e) {
            throw new DispatchException((Throwable)e);
        }
    }

    public void raiseError(int status) {
        try {
            this.isAborted = true;
            this.getResponse().sendError(status);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.getResponse().setStatus(status);
    }

    public boolean isAborted() {
        return this.isAborted;
    }

    public void setContentType(String string) {
        this.getResponse().setContentType(string);
    }

    public String imagePath(ObjectAdapter object) {
        String contextPath = this.getContextPath();
        return ImageLookup.imagePath(object, contextPath);
    }

    public String imagePath(ObjectSpecification specification) {
        String contextPath = this.getContextPath();
        return ImageLookup.imagePath(specification, contextPath);
    }

    public String getContextPath() {
        return this.request.getContextPath();
    }

    public String getHeader(String name) {
        return this.request.getHeader(name);
    }

    public String getQueryString() {
        return this.request.getQueryString();
    }

    public String getUri() {
        return this.request.getRequestURI() + "?" + this.request.getQueryString();
    }

    public String getUrlBase() {
        StringBuffer url = this.request.getRequestURL();
        url.setLength(url.length() - this.request.getRequestURI().length());
        return url.toString();
    }

    public void addCookie(String name, String value, int minutesUtilExpires) {
        Cookie cookie = new Cookie(name, value);
        cookie.setMaxAge(minutesUtilExpires * 60);
        this.response.addCookie(cookie);
    }

    public String getCookie(String name) {
        Cookie[] cookies = this.request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(name)) continue;
                return cookie.getValue();
            }
        }
        return null;
    }
}

