/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.scimpi.servlet;

import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.isis.runtimes.dflt.runtime.system.context.IsisContext;
import org.apache.isis.viewer.scimpi.dispatcher.Dispatcher;
import org.apache.isis.viewer.scimpi.dispatcher.UserManager;
import org.apache.isis.viewer.scimpi.dispatcher.context.RequestContext;
import org.apache.isis.viewer.scimpi.dispatcher.debug.DebugUsers;
import org.apache.isis.viewer.scimpi.servlet.ImageLookup;
import org.apache.isis.viewer.scimpi.servlet.ServletRequestContext;
import org.apache.log4j.Logger;

public class DispatcherServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getLogger(DispatcherServlet.class);
    private Dispatcher dispatcher;
    private DebugUsers debugUsers;

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        LOG.debug((Object)("post " + request.getServletPath() + "  " + request.getQueryString()));
        this.process(request, response);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        LOG.debug((Object)("get  " + request.getServletPath() + "  " + request.getQueryString()));
        this.process(request, response);
    }

    private void process(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            HashMap data;
            ServletRequestContext context = new ServletRequestContext(this.debugUsers);
            HttpSession httpSession = request.getSession(false);
            if (httpSession != null && (data = (HashMap)httpSession.getAttribute("scimpi-context")) != null) {
                context.setSessionData(data);
            }
            context.startRequest(request, response, this.getServletContext());
            this.dispatcher.process((RequestContext)context, request.getServletPath());
        }
        catch (RuntimeException e) {
            LOG.error((Object)"servlet exception", (Throwable)e);
            throw e;
        }
    }

    public void init() throws ServletException {
        super.init();
        ImageLookup.setImageDirectory(this.getServletContext(), "images");
        this.debugUsers = new DebugUsers();
        this.debugUsers.initialize();
        this.dispatcher = new Dispatcher();
        Enumeration initParameterNames = this.getInitParameterNames();
        while (initParameterNames.hasMoreElements()) {
            String name = (String)initParameterNames.nextElement();
            String value = this.getInitParameter(name);
            this.dispatcher.addParameter(name, value);
        }
        String dir = this.getServletContext().getRealPath("/WEB-INF");
        this.dispatcher.init(dir, this.debugUsers);
        new UserManager(IsisContext.getAuthenticationManager());
    }
}

