/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.rendering.util;

import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.oid.Oid;
import org.apache.isis.core.metamodel.adapter.oid.OidMarshaller;
import org.apache.isis.core.metamodel.adapter.oid.RootOid;
import org.apache.isis.core.metamodel.adapter.oid.TypedOid;
import org.apache.isis.viewer.restfulobjects.rendering.RendererContext;

public final class OidUtils {
    private OidUtils() {
    }

    public static String getDomainType(ObjectAdapter objectAdapter) {
        Oid oid = objectAdapter.getOid();
        if (oid == null || !(oid instanceof TypedOid)) {
            return null;
        }
        TypedOid typedOid = (TypedOid)oid;
        return typedOid.getObjectSpecId().asString();
    }

    public static String getInstanceId(RendererContext renderContext, ObjectAdapter objectAdapter) {
        String oidStr = OidUtils.getOidStr(renderContext, objectAdapter);
        return oidStr != null ? OidUtils.getOidMarshaller().splitInstanceId(oidStr) : null;
    }

    public static String getOidStr(RendererContext renderContext, ObjectAdapter objectAdapter) {
        Oid oid = objectAdapter.getOid();
        if (!(oid instanceof RootOid)) {
            throw new IllegalArgumentException("objectAdapter must be a root adapter");
        }
        return oid != null ? oid.enStringNoVersion(OidUtils.getOidMarshaller()) : null;
    }

    private static OidMarshaller getOidMarshaller() {
        return new OidMarshaller();
    }
}

