/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.rendering.eventserializer;

import java.io.IOException;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.isis.applib.annotation.Hidden;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.annotation.Where;
import org.apache.isis.applib.services.publish.EventMetadata;
import org.apache.isis.applib.services.publish.EventPayload;
import org.apache.isis.applib.services.publish.EventSerializer;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.util.JsonMapper;
import org.apache.isis.viewer.restfulobjects.rendering.RendererContext;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.DomainObjectReprRenderer;
import org.apache.isis.viewer.restfulobjects.rendering.eventserializer.EventSerializerRendererContext;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.map.JsonMappingException;

@Hidden
public class RestfulObjectsSpecEventSerializer
implements EventSerializer {
    private static final JsonMapper jsonMapper = JsonMapper.instance();
    private static final String BASE_URL_KEY = "isis.viewer.restfulobjects.RestfulObjectsSpecEventSerializer.baseUrl";
    private static final String BASE_URL_DEFAULT = "http://localhost:8080/restful/";
    private String baseUrl;

    @PostConstruct
    public void init(Map<String, String> props) {
        String baseUrlFromConfig = props.get(BASE_URL_KEY);
        this.baseUrl = baseUrlFromConfig != null ? baseUrlFromConfig : BASE_URL_DEFAULT;
    }

    @PreDestroy
    public void shutdown() {
    }

    @Programmatic
    public Object serialize(EventMetadata metadata, EventPayload payload) {
        EventSerializerRendererContext rendererContext = new EventSerializerRendererContext(this.baseUrl, Where.OBJECT_FORMS);
        JsonRepresentation payloadRepr = this.asPayloadRepr(rendererContext, payload);
        JsonRepresentation eventRepr = this.asEventRepr(metadata, payloadRepr);
        return this.jsonFor(eventRepr);
    }

    JsonRepresentation asEventRepr(EventMetadata metadata, JsonRepresentation payloadRepr) {
        JsonRepresentation eventRepr = JsonRepresentation.newMap((String[])new String[0]);
        JsonRepresentation metadataRepr = JsonRepresentation.newMap((String[])new String[0]);
        eventRepr.mapPut("metadata", metadataRepr);
        metadataRepr.mapPut("id", metadata.getId());
        metadataRepr.mapPut("transactionId", (Object)metadata.getTransactionId());
        metadataRepr.mapPut("sequence", metadata.getSequence());
        metadataRepr.mapPut("eventType", (Object)metadata.getEventType());
        metadataRepr.mapPut("user", metadata.getUser());
        metadataRepr.mapPut("timestamp", metadata.getTimestamp());
        eventRepr.mapPut("payload", payloadRepr);
        return eventRepr;
    }

    JsonRepresentation asPayloadRepr(RendererContext rendererContext, EventPayload payload) {
        DomainObjectReprRenderer renderer = new DomainObjectReprRenderer(rendererContext, null, JsonRepresentation.newMap((String[])new String[0]));
        ObjectAdapter objectAdapter = rendererContext.getAdapterManager().adapterFor((Object)payload);
        renderer.with(objectAdapter).asEventSerialization();
        return renderer.render();
    }

    String jsonFor(Object object) {
        try {
            return this.getJsonMapper().write(object);
        }
        catch (JsonGenerationException e) {
            throw new RuntimeException(e);
        }
        catch (JsonMappingException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    JsonMapper getJsonMapper() {
        return jsonMapper;
    }
}

