/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.rendering.domaintypes;

import org.apache.isis.core.metamodel.facets.maxlen.MaxLengthFacet;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.OneToOneAssociation;
import org.apache.isis.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.Rel;
import org.apache.isis.viewer.restfulobjects.applib.RepresentationType;
import org.apache.isis.viewer.restfulobjects.rendering.LinkBuilder;
import org.apache.isis.viewer.restfulobjects.rendering.LinkFollowSpecs;
import org.apache.isis.viewer.restfulobjects.rendering.RendererContext;
import org.apache.isis.viewer.restfulobjects.rendering.domaintypes.AbstractTypeMemberReprRenderer;
import org.apache.isis.viewer.restfulobjects.rendering.domaintypes.DomainTypeReprRenderer;

public class PropertyDescriptionReprRenderer
extends AbstractTypeMemberReprRenderer<PropertyDescriptionReprRenderer, OneToOneAssociation> {
    public static LinkBuilder newLinkToBuilder(RendererContext resourceContext, Rel rel, ObjectSpecification objectSpecification, OneToOneAssociation property) {
        String domainType = objectSpecification.getSpecId().asString();
        String propertyId = property.getId();
        String url = "domain-types/" + domainType + "/properties/" + propertyId;
        return LinkBuilder.newBuilder(resourceContext, rel.getName(), RepresentationType.PROPERTY_DESCRIPTION, url, new Object[0]);
    }

    public PropertyDescriptionReprRenderer(RendererContext resourceContext, LinkFollowSpecs linkFollower, JsonRepresentation representation) {
        super(resourceContext, linkFollower, RepresentationType.PROPERTY_DESCRIPTION, representation);
    }

    @Override
    protected void addLinksSpecificToFeature() {
        this.addLinkToReturnTypeIfAny();
    }

    @Override
    protected void addPropertiesSpecificToFeature() {
        this.representation.mapPut("optional", !((OneToOneAssociation)this.getObjectFeature()).isMandatory());
        MaxLengthFacet maxLength = (MaxLengthFacet)((OneToOneAssociation)this.getObjectFeature()).getFacet(MaxLengthFacet.class);
        if (maxLength != null && !maxLength.isNoop()) {
            this.representation.mapPut("maxLength", maxLength.value());
        }
    }

    private void addLinkToReturnTypeIfAny() {
        ObjectSpecification returnType = ((OneToOneAssociation)this.getObjectFeature()).getSpecification();
        if (returnType == null) {
            return;
        }
        LinkBuilder linkBuilder = DomainTypeReprRenderer.newLinkToBuilder(this.getRendererContext(), Rel.RETURN_TYPE, returnType);
        this.getLinks().arrayAdd(linkBuilder.build());
    }

    @Override
    protected void putExtensionsSpecificToFeature() {
        this.putExtensionsName();
        this.putExtensionsDescriptionIfAvailable();
    }
}

