/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.rendering.domainobjects;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.facets.object.encodeable.EncodableFacet;
import org.apache.isis.core.metamodel.spec.ObjectSpecId;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.viewer.restfulobjects.applib.JsonRepresentation;
import org.codehaus.jackson.node.NullNode;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;

public final class JsonValueEncoder {
    private static Map<ObjectSpecId, JsonValueConverter> converterBySpec = Maps.newLinkedHashMap();

    private JsonValueEncoder() {
    }

    private static void putConverter(JsonValueConverter jvc) {
        List<ObjectSpecId> specIds = jvc.getSpecIds();
        for (ObjectSpecId specId : specIds) {
            converterBySpec.put(specId, jvc);
        }
    }

    public static ObjectAdapter asAdapter(ObjectSpecification objectSpec, JsonRepresentation argRepr) {
        if (objectSpec == null) {
            String reason = "ObjectSpec is null, cannot validate";
            argRepr.mapPut("invalidReason", reason);
            throw new IllegalArgumentException(reason);
        }
        EncodableFacet encodableFacet = (EncodableFacet)objectSpec.getFacet(EncodableFacet.class);
        if (encodableFacet == null) {
            String reason = "ObjectSpec expected to have an EncodableFacet";
            argRepr.mapPut("invalidReason", reason);
            throw new IllegalArgumentException(reason);
        }
        if (!argRepr.mapHas("value")) {
            String reason = "No 'value' key";
            argRepr.mapPut("invalidReason", reason);
            throw new IllegalArgumentException(reason);
        }
        JsonRepresentation argValueRepr = argRepr.getRepresentation("value", new Object[0]);
        if (argValueRepr == null) {
            return null;
        }
        if (!argValueRepr.isValue()) {
            String reason = "Representation must be of a value";
            argRepr.mapPut("invalidReason", reason);
            throw new IllegalArgumentException(reason);
        }
        JsonValueConverter jvc = converterBySpec.get(objectSpec.getSpecId());
        if (jvc == null) {
            if (argValueRepr.isString()) {
                String argStr = argValueRepr.asString();
                return encodableFacet.fromEncodedString(argStr);
            }
            String reason = "Unable to parse value";
            argRepr.mapPut("invalidReason", "Unable to parse value");
            throw new IllegalArgumentException("Unable to parse value");
        }
        ObjectAdapter asAdapter = jvc.asAdapter(argValueRepr);
        if (asAdapter != null) {
            return asAdapter;
        }
        if (argValueRepr.isString()) {
            String argStr = argValueRepr.asString();
            return encodableFacet.fromEncodedString(argStr);
        }
        String reason = "Could not parse value '" + argValueRepr.asString() + "' as a " + objectSpec.getFullIdentifier();
        argRepr.mapPut("invalidReason", reason);
        throw new IllegalArgumentException(reason);
    }

    public static void appendValueAndFormat(ObjectSpecification objectSpec, ObjectAdapter objectAdapter, JsonRepresentation repr) {
        JsonValueConverter jvc = converterBySpec.get(objectSpec.getSpecId());
        if (jvc != null) {
            jvc.appendValueAndFormat(objectAdapter, repr);
        } else {
            EncodableFacet encodableFacet = (EncodableFacet)objectSpec.getFacet(EncodableFacet.class);
            if (encodableFacet == null) {
                throw new IllegalArgumentException("objectSpec expected to have EncodableFacet");
            }
            NullNode value = objectAdapter != null ? encodableFacet.toEncodedString(objectAdapter) : NullNode.getInstance();
            JsonValueEncoder.append(repr, value, "decimal", "bigdecimal");
        }
    }

    public static Object asObject(ObjectAdapter objectAdapter) {
        if (objectAdapter == null) {
            throw new IllegalArgumentException("objectAdapter cannot be null");
        }
        ObjectSpecification objectSpec = objectAdapter.getSpecification();
        JsonValueConverter jvc = converterBySpec.get(objectSpec.getSpecId());
        if (jvc != null) {
            return jvc.asObject(objectAdapter);
        }
        EncodableFacet encodableFacet = (EncodableFacet)objectSpec.getFacet(EncodableFacet.class);
        if (encodableFacet == null) {
            throw new IllegalArgumentException("objectSpec expected to have EncodableFacet");
        }
        return encodableFacet.toEncodedString(objectAdapter);
    }

    private static void append(JsonRepresentation repr, Object value, String format, String xIsisFormat) {
        repr.mapPut("value", value);
        if (format != null) {
            repr.mapPut("format", format);
        }
        if (xIsisFormat != null) {
            repr.mapPut("x-isis-format", xIsisFormat);
        }
    }

    private static void append(JsonRepresentation repr, ObjectAdapter value, String format, String xIsisFormat) {
        JsonValueEncoder.append(repr, JsonValueEncoder.unwrap(value), format, xIsisFormat);
    }

    private static Object unwrap(ObjectAdapter objectAdapter) {
        return objectAdapter != null ? objectAdapter.getObject() : NullNode.getInstance();
    }

    private static ObjectAdapter adapterFor(Object value) {
        return JsonValueEncoder.getAdapterManager().adapterFor(value);
    }

    public static AdapterManager getAdapterManager() {
        return IsisContext.getPersistenceSession().getAdapterManager();
    }

    static {
        JsonValueEncoder.putConverter(new JsonValueConverter(null, "boolean", new Class[]{Boolean.TYPE, Boolean.class}){

            @Override
            public ObjectAdapter asAdapter(JsonRepresentation repr) {
                if (repr.isBoolean()) {
                    return JsonValueEncoder.adapterFor(repr.asBoolean());
                }
                return null;
            }
        });
        JsonValueEncoder.putConverter(new JsonValueConverter(null, "byte", new Class[]{Byte.TYPE, Byte.class}){

            @Override
            public ObjectAdapter asAdapter(JsonRepresentation repr) {
                if (repr.isNumber()) {
                    return JsonValueEncoder.adapterFor(repr.asNumber().byteValue());
                }
                if (repr.isInt()) {
                    return JsonValueEncoder.adapterFor((byte)repr.asInt().intValue());
                }
                if (repr.isLong()) {
                    return JsonValueEncoder.adapterFor((byte)repr.asLong().longValue());
                }
                if (repr.isBigInteger()) {
                    return JsonValueEncoder.adapterFor(repr.asBigInteger().byteValue());
                }
                return null;
            }
        });
        JsonValueEncoder.putConverter(new JsonValueConverter(null, "short", new Class[]{Short.TYPE, Short.class}){

            @Override
            public ObjectAdapter asAdapter(JsonRepresentation repr) {
                if (repr.isNumber()) {
                    return JsonValueEncoder.adapterFor(repr.asNumber().shortValue());
                }
                if (repr.isInt()) {
                    return JsonValueEncoder.adapterFor((short)repr.asInt().intValue());
                }
                if (repr.isLong()) {
                    return JsonValueEncoder.adapterFor((short)repr.asLong().longValue());
                }
                if (repr.isBigInteger()) {
                    return JsonValueEncoder.adapterFor(repr.asBigInteger().shortValue());
                }
                return null;
            }
        });
        JsonValueEncoder.putConverter(new JsonValueConverter("int", "int", new Class[]{Integer.TYPE, Integer.class}){

            @Override
            public ObjectAdapter asAdapter(JsonRepresentation repr) {
                if (repr.isInt()) {
                    return JsonValueEncoder.adapterFor(repr.asInt());
                }
                if (repr.isLong()) {
                    return JsonValueEncoder.adapterFor((int)repr.asLong().longValue());
                }
                if (repr.isBigInteger()) {
                    return JsonValueEncoder.adapterFor(repr.asBigInteger().intValue());
                }
                if (repr.isNumber()) {
                    return JsonValueEncoder.adapterFor(repr.asNumber().intValue());
                }
                return null;
            }
        });
        JsonValueEncoder.putConverter(new JsonValueConverter("int", "long", new Class[]{Long.TYPE, Long.class}){

            @Override
            public ObjectAdapter asAdapter(JsonRepresentation repr) {
                if (repr.isLong()) {
                    return JsonValueEncoder.adapterFor(repr.asLong());
                }
                if (repr.isInt()) {
                    return JsonValueEncoder.adapterFor(repr.asInt());
                }
                if (repr.isBigInteger()) {
                    return JsonValueEncoder.adapterFor(repr.asBigInteger().longValue());
                }
                if (repr.isNumber()) {
                    return JsonValueEncoder.adapterFor(repr.asNumber().longValue());
                }
                return null;
            }
        });
        JsonValueEncoder.putConverter(new JsonValueConverter("decimal", "float", new Class[]{Float.TYPE, Float.class}){

            @Override
            public ObjectAdapter asAdapter(JsonRepresentation repr) {
                if (repr.isDouble()) {
                    return JsonValueEncoder.adapterFor(Float.valueOf((float)repr.asDouble().doubleValue()));
                }
                if (repr.isNumber()) {
                    return JsonValueEncoder.adapterFor(Float.valueOf(repr.asNumber().floatValue()));
                }
                if (repr.isLong()) {
                    return JsonValueEncoder.adapterFor(Float.valueOf(repr.asLong().longValue()));
                }
                if (repr.isInt()) {
                    return JsonValueEncoder.adapterFor(Float.valueOf(repr.asInt().intValue()));
                }
                if (repr.isBigInteger()) {
                    return JsonValueEncoder.adapterFor(Float.valueOf(repr.asBigInteger().floatValue()));
                }
                return null;
            }
        });
        JsonValueEncoder.putConverter(new JsonValueConverter("decimal", "double", new Class[]{Double.TYPE, Double.class}){

            @Override
            public ObjectAdapter asAdapter(JsonRepresentation repr) {
                if (repr.isDouble()) {
                    return JsonValueEncoder.adapterFor(repr.asDouble());
                }
                if (repr.isLong()) {
                    return JsonValueEncoder.adapterFor(repr.asLong());
                }
                if (repr.isInt()) {
                    return JsonValueEncoder.adapterFor(repr.asInt());
                }
                if (repr.isBigInteger()) {
                    return JsonValueEncoder.adapterFor(repr.asBigInteger().doubleValue());
                }
                if (repr.isBigDecimal()) {
                    return JsonValueEncoder.adapterFor(repr.asBigDecimal().doubleValue());
                }
                if (repr.isNumber()) {
                    return JsonValueEncoder.adapterFor(repr.asNumber().doubleValue());
                }
                return null;
            }
        });
        JsonValueEncoder.putConverter(new JsonValueConverter(null, "char", new Class[]{Character.TYPE, Character.class}){

            @Override
            public ObjectAdapter asAdapter(JsonRepresentation repr) {
                String str;
                if (repr.isString() && (str = repr.asString()) != null && str.length() > 0) {
                    return JsonValueEncoder.adapterFor(Character.valueOf(str.charAt(0)));
                }
                return null;
            }
        });
        JsonValueEncoder.putConverter(new JsonValueConverter("int", "biginteger", new Class[]{BigInteger.class}){

            @Override
            public ObjectAdapter asAdapter(JsonRepresentation repr) {
                if (repr.isBigInteger()) {
                    return JsonValueEncoder.adapterFor(repr.asBigInteger());
                }
                if (repr.isLong()) {
                    return JsonValueEncoder.adapterFor(BigInteger.valueOf(repr.asLong()));
                }
                if (repr.isInt()) {
                    return JsonValueEncoder.adapterFor(BigInteger.valueOf(repr.asInt().intValue()));
                }
                if (repr.isNumber()) {
                    return JsonValueEncoder.adapterFor(BigInteger.valueOf(repr.asNumber().longValue()));
                }
                return null;
            }
        });
        JsonValueEncoder.putConverter(new JsonValueConverter("decimal", "bigdecimal", new Class[]{BigDecimal.class}){

            @Override
            public ObjectAdapter asAdapter(JsonRepresentation repr) {
                if (repr.isBigDecimal()) {
                    return JsonValueEncoder.adapterFor(repr.asBigDecimal());
                }
                if (repr.isBigInteger()) {
                    return JsonValueEncoder.adapterFor(new BigDecimal(repr.asBigInteger()));
                }
                if (repr.isDouble()) {
                    return JsonValueEncoder.adapterFor(BigDecimal.valueOf(repr.asDouble()));
                }
                if (repr.isLong()) {
                    return JsonValueEncoder.adapterFor(BigDecimal.valueOf(repr.asLong()));
                }
                if (repr.isInt()) {
                    return JsonValueEncoder.adapterFor(BigDecimal.valueOf(repr.asInt().intValue()));
                }
                return null;
            }
        });
        JsonValueEncoder.putConverter(new JsonValueConverter("date", "jodalocaldate", new Class[]{LocalDate.class}){
            final DateTimeFormatter yyyyMMdd = JsonRepresentation.yyyyMMdd;

            @Override
            public ObjectAdapter asAdapter(JsonRepresentation repr) {
                if (repr.isString()) {
                    String dateStr = repr.asString();
                    try {
                        Date parsedDate = this.yyyyMMdd.parseDateTime(dateStr).toDate();
                        return JsonValueEncoder.adapterFor(parsedDate);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
                return null;
            }

            @Override
            public void appendValueAndFormat(ObjectAdapter objectAdapter, JsonRepresentation repr) {
                LocalDate date = (LocalDate)JsonValueEncoder.unwrap(objectAdapter);
                String dateStr = this.yyyyMMdd.print((ReadableInstant)date.toDateTimeAtStartOfDay());
                JsonValueEncoder.append(repr, dateStr, this.format, this.xIsisFormat);
            }
        });
        JsonValueEncoder.putConverter(new JsonValueConverter("date-time", "jodalocaldatetime", new Class[]{LocalDateTime.class}){
            final DateTimeFormatter yyyyMMddHHmmss = JsonRepresentation.yyyyMMddTHHmmssZ;

            @Override
            public ObjectAdapter asAdapter(JsonRepresentation repr) {
                if (repr.isString()) {
                    String dateStr = repr.asString();
                    try {
                        Date parsedDate = this.yyyyMMddHHmmss.parseDateTime(dateStr).toDate();
                        return JsonValueEncoder.adapterFor(parsedDate);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
                return null;
            }

            @Override
            public void appendValueAndFormat(ObjectAdapter objectAdapter, JsonRepresentation repr) {
                LocalDateTime date = (LocalDateTime)JsonValueEncoder.unwrap(objectAdapter);
                String dateStr = this.yyyyMMddHHmmss.print((ReadableInstant)date.toDateTime());
                JsonValueEncoder.append(repr, dateStr, this.format, this.xIsisFormat);
            }
        });
    }

    public static abstract class JsonValueConverter {
        protected final String format;
        protected final String xIsisFormat;
        private final Class<?>[] classes;

        public JsonValueConverter(String format, String xIsisFormat, Class<?> ... classes) {
            this.format = format;
            this.xIsisFormat = xIsisFormat;
            this.classes = classes;
        }

        public List<ObjectSpecId> getSpecIds() {
            return Lists.newArrayList((Iterable)Iterables.transform(Arrays.asList(this.classes), (Function)new Function<Class<?>, ObjectSpecId>(){

                public ObjectSpecId apply(Class<?> cls) {
                    return new ObjectSpecId(cls.getName());
                }
            }));
        }

        public abstract ObjectAdapter asAdapter(JsonRepresentation var1);

        public void appendValueAndFormat(ObjectAdapter objectAdapter, JsonRepresentation repr) {
            JsonValueEncoder.append(repr, objectAdapter, this.format, this.xIsisFormat);
        }

        public Object asObject(ObjectAdapter objectAdapter) {
            return objectAdapter.getObject();
        }
    }

    public static class ExpectedStringRepresentingValueException
    extends IllegalArgumentException {
        private static final long serialVersionUID = 1L;
    }
}

