/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.rendering.domainobjects;

import org.apache.isis.applib.annotation.Where;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.consent.Consent;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.ObjectMember;
import org.apache.isis.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.Rel;
import org.apache.isis.viewer.restfulobjects.applib.RepresentationType;
import org.apache.isis.viewer.restfulobjects.rendering.LinkFollowSpecs;
import org.apache.isis.viewer.restfulobjects.rendering.RendererContext;
import org.apache.isis.viewer.restfulobjects.rendering.ReprRendererAbstract;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.DomainObjectLinkTo;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.MemberType;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.MutatorSpec;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.ObjectAdapterLinkTo;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.ObjectAndMember;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.NullNode;

public abstract class AbstractObjectMemberReprRenderer<R extends ReprRendererAbstract<R, ObjectAndMember<T>>, T extends ObjectMember>
extends ReprRendererAbstract<R, ObjectAndMember<T>> {
    protected ObjectAdapterLinkTo linkTo;
    protected ObjectAdapter objectAdapter;
    protected MemberType memberType;
    protected T objectMember;
    protected Mode mode = Mode.INLINE;
    private final String memberId;
    private final Where where;

    public AbstractObjectMemberReprRenderer(RendererContext resourceContext, LinkFollowSpecs linkFollower, String memberId, RepresentationType representationType, JsonRepresentation representation, Where where) {
        super(resourceContext, linkFollower, representationType, representation);
        this.memberId = memberId;
        this.where = where;
    }

    protected String getMemberId() {
        return this.memberId;
    }

    @Override
    public R with(ObjectAndMember<T> objectAndMember) {
        this.objectAdapter = objectAndMember.getObjectAdapter();
        this.objectMember = objectAndMember.getMember();
        this.memberType = MemberType.determineFrom(this.objectMember);
        this.usingLinkTo(new DomainObjectLinkTo());
        this.representation.mapPut("memberType", this.memberType.getName());
        return AbstractObjectMemberReprRenderer.cast(this);
    }

    public R usingLinkTo(ObjectAdapterLinkTo linkTo) {
        this.linkTo = linkTo.usingUrlBase(this.rendererContext).with(this.objectAdapter);
        return AbstractObjectMemberReprRenderer.cast(this);
    }

    public R asStandalone() {
        this.mode = Mode.STANDALONE;
        return AbstractObjectMemberReprRenderer.cast(this);
    }

    public R asFollowed() {
        this.mode = Mode.FOLLOWED;
        return AbstractObjectMemberReprRenderer.cast(this);
    }

    public R asMutated() {
        this.mode = Mode.MUTATED;
        return AbstractObjectMemberReprRenderer.cast(this);
    }

    public R asArguments() {
        this.mode = Mode.ARGUMENTS;
        return AbstractObjectMemberReprRenderer.cast(this);
    }

    protected void renderMemberContent() {
        if (this.mode.isInline()) {
            this.addDetailsLinkIfPersistent();
        }
        if (this.mode.isStandalone()) {
            this.addLinkToSelf();
        }
        if (this.mode.isStandalone() || this.mode.isMutated()) {
            this.addLinkToUp();
        }
        if (this.mode.isFollowed() || this.mode.isStandalone() || this.mode.isMutated()) {
            this.addMutatorsIfEnabled();
            this.putExtensionsIsisProprietary();
            this.addLinksToFormalDomainModel();
            this.addLinksIsisProprietary();
        }
    }

    private void addLinkToSelf() {
        this.getLinks().arrayAdd(this.linkTo.memberBuilder(Rel.SELF, this.memberType, (ObjectMember)this.objectMember, new String[0]).build());
    }

    private void addLinkToUp() {
        this.getLinks().arrayAdd(this.linkTo.builder(Rel.UP).build());
    }

    protected abstract void addMutatorsIfEnabled();

    protected void addLinkFor(MutatorSpec mutatorSpec) {
        if (!this.hasMemberFacet(mutatorSpec.mutatorFacetType)) {
            return;
        }
        JsonRepresentation arguments = this.mutatorArgs(mutatorSpec);
        RepresentationType representationType = this.memberType.getRepresentationType();
        JsonRepresentation mutatorLink = this.linkToForMutatorInvoke().memberBuilder(mutatorSpec.rel, this.memberType, (ObjectMember)this.objectMember, representationType, mutatorSpec.suffix).withHttpMethod(mutatorSpec.httpMethod).withArguments(arguments).build();
        this.getLinks().arrayAdd(mutatorLink);
    }

    protected ObjectAdapterLinkTo linkToForMutatorInvoke() {
        return this.linkTo;
    }

    protected JsonRepresentation mutatorArgs(MutatorSpec mutatorSpec) {
        if (mutatorSpec.arguments.isNone()) {
            return null;
        }
        if (mutatorSpec.arguments.isOne()) {
            JsonRepresentation repr = JsonRepresentation.newMap((String[])new String[0]);
            repr.mapPut("value", (JsonNode)NullNode.getInstance());
            return repr;
        }
        throw new UnsupportedOperationException("override mutatorArgs() to populate for many arguments");
    }

    private void addDetailsLinkIfPersistent() {
        if (!this.objectAdapter.representsPersistent()) {
            return;
        }
        JsonRepresentation link = this.linkTo.memberBuilder(Rel.DETAILS, this.memberType, (ObjectMember)this.objectMember, new String[0]).build();
        this.getLinks().arrayAdd(link);
        LinkFollowSpecs membersLinkFollower = this.getLinkFollowSpecs();
        LinkFollowSpecs detailsLinkFollower = membersLinkFollower.follow("links", new Object[0]);
        JsonRepresentation memberMap = JsonRepresentation.newMap((String[])new String[0]);
        memberMap.mapPut(this.getMemberId(), this.representation);
        if (membersLinkFollower.matches(memberMap) && detailsLinkFollower.matches(link)) {
            this.followDetailsLink(link);
        }
    }

    protected abstract void followDetailsLink(JsonRepresentation var1);

    protected final void putDisabledReasonIfDisabled() {
        String disabledReasonRep = this.usability().getReason();
        this.representation.mapPut("disabledReason", disabledReasonRep);
    }

    protected abstract void putExtensionsIsisProprietary();

    protected abstract void addLinksToFormalDomainModel();

    protected abstract void addLinksIsisProprietary();

    public boolean isMemberVisible() {
        return this.visibility().isAllowed();
    }

    protected <F extends Facet> F getMemberSpecFacet(Class<F> facetType) {
        ObjectSpecification otoaSpec = this.objectMember.getSpecification();
        return (F)otoaSpec.getFacet(facetType);
    }

    protected boolean hasMemberFacet(Class<? extends Facet> facetType) {
        return this.objectMember.getFacet(facetType) != null;
    }

    protected Consent usability() {
        return this.objectMember.isUsable(this.getRendererContext().getAuthenticationSession(), this.objectAdapter, this.where);
    }

    protected Consent visibility() {
        return this.objectMember.isVisible(this.getRendererContext().getAuthenticationSession(), this.objectAdapter, this.where);
    }

    protected static enum Mode {
        INLINE,
        FOLLOWED,
        STANDALONE,
        MUTATED,
        ARGUMENTS;


        public boolean isInline() {
            return this == INLINE;
        }

        public boolean isFollowed() {
            return this == FOLLOWED;
        }

        public boolean isStandalone() {
            return this == STANDALONE;
        }

        public boolean isMutated() {
            return this == MUTATED;
        }

        public boolean isArguments() {
            return this == ARGUMENTS;
        }
    }
}

