/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.rendering;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.core.runtime.system.transaction.UpdateNotifier;
import org.apache.isis.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.Rel;
import org.apache.isis.viewer.restfulobjects.applib.RepresentationType;
import org.apache.isis.viewer.restfulobjects.rendering.LinkBuilder;
import org.apache.isis.viewer.restfulobjects.rendering.LinkFollowSpecs;
import org.apache.isis.viewer.restfulobjects.rendering.RendererContext;
import org.apache.isis.viewer.restfulobjects.rendering.ReprRenderer;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.DomainObjectReprRenderer;
import org.apache.isis.viewer.restfulobjects.rendering.domaintypes.DomainTypeReprRenderer;

public abstract class ReprRendererAbstract<R extends ReprRendererAbstract<R, T>, T>
implements ReprRenderer<R, T> {
    protected final RendererContext rendererContext;
    private final LinkFollowSpecs linkFollower;
    private final RepresentationType representationType;
    protected final JsonRepresentation representation;
    private final Map<String, String> mediaTypeParams = Maps.newLinkedHashMap();
    protected boolean includesSelf;

    public ReprRendererAbstract(RendererContext rendererContext, LinkFollowSpecs linkFollower, RepresentationType representationType, JsonRepresentation representation) {
        this.rendererContext = rendererContext;
        this.linkFollower = this.asProvidedElseCreate(linkFollower);
        this.representationType = representationType;
        this.representation = representation;
    }

    public RendererContext getRendererContext() {
        return this.rendererContext;
    }

    public LinkFollowSpecs getLinkFollowSpecs() {
        return this.linkFollower;
    }

    private LinkFollowSpecs asProvidedElseCreate(LinkFollowSpecs linkFollower) {
        if (linkFollower != null) {
            return linkFollower;
        }
        return LinkFollowSpecs.create(this.rendererContext.getFollowLinks());
    }

    @Override
    public MediaType getMediaType() {
        return this.representationType.getMediaType(this.mediaTypeParams);
    }

    protected void addMediaTypeParams(String param, String paramValue) {
        this.mediaTypeParams.put(param, paramValue);
    }

    public R includesSelf() {
        this.includesSelf = true;
        return (R)this;
    }

    public R withLink(Rel rel, String href) {
        if (href != null) {
            this.getLinks().arrayAdd(LinkBuilder.newBuilder(this.rendererContext, rel.getName(), this.representationType, href, new Object[0]).build());
        }
        return ReprRendererAbstract.cast(this);
    }

    public R withLink(Rel rel, JsonRepresentation link) {
        String relStr = link.getString("rel");
        if (relStr == null || !relStr.equals(rel.getName())) {
            throw new IllegalArgumentException("Provided link does not have a 'rel' of '" + rel.getName() + "'; was: " + link);
        }
        if (link != null) {
            this.getLinks().arrayAdd(link);
        }
        return ReprRendererAbstract.cast(this);
    }

    protected JsonRepresentation getLinks() {
        JsonRepresentation links = this.representation.getArray("links");
        if (links == null) {
            links = JsonRepresentation.newArray();
            this.representation.mapPut("links", links);
        }
        return links;
    }

    protected void addLink(Rel rel, ObjectSpecification objectSpec) {
        if (objectSpec == null) {
            return;
        }
        LinkBuilder linkBuilder = DomainTypeReprRenderer.newLinkToBuilder(this.getRendererContext(), rel, objectSpec);
        JsonRepresentation link = linkBuilder.build();
        this.getLinks().arrayAdd(link);
        LinkFollowSpecs linkFollower = this.getLinkFollowSpecs().follow("links", new Object[0]);
        if (linkFollower.matches(link)) {
            DomainTypeReprRenderer renderer = new DomainTypeReprRenderer(this.getRendererContext(), linkFollower, JsonRepresentation.newMap((String[])new String[0])).with(objectSpec);
            link.mapPut("value", renderer.render());
        }
    }

    protected JsonRepresentation getExtensions() {
        JsonRepresentation extensions = this.representation.getMap("extensions");
        if (extensions == null) {
            extensions = JsonRepresentation.newMap((String[])new String[0]);
            this.representation.mapPut("extensions", extensions);
        }
        return extensions;
    }

    public R withExtensions(JsonRepresentation extensions) {
        if (!extensions.isMap()) {
            throw new IllegalArgumentException("extensions must be a map");
        }
        this.representation.mapPut("extensions", extensions);
        return ReprRendererAbstract.cast(this);
    }

    protected static <R extends ReprRendererAbstract<R, T>, T> R cast(ReprRendererAbstract<R, T> builder) {
        return (R)builder;
    }

    @Override
    public abstract JsonRepresentation render();

    protected final void addExtensionsIsisProprietaryChangedObjects() {
        UpdateNotifier updateNotifier = this.getUpdateNotifier();
        this.addToExtensions("changed", updateNotifier.getChangedObjects());
        this.addToExtensions("disposed", updateNotifier.getDisposedObjects());
    }

    private void addToExtensions(String key, List<ObjectAdapter> adapters) {
        JsonRepresentation adapterList = JsonRepresentation.newArray();
        this.getExtensions().mapPut(key, adapterList);
        for (ObjectAdapter adapter : adapters) {
            adapterList.arrayAdd(DomainObjectReprRenderer.newLinkToBuilder(this.getRendererContext(), Rel.VALUE, adapter).build());
        }
    }

    protected List<ObjectAdapter> getServiceAdapters() {
        return IsisContext.getPersistenceSession().getServices();
    }

    protected UpdateNotifier getUpdateNotifier() {
        return IsisContext.getCurrentTransaction().getUpdateNotifier();
    }
}

