/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.rendering.domainobjects;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facets.object.encodeable.EncodableFacet;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.isis.viewer.restfulobjects.rendering.domainobjects.JsonValueEncoder;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.BigIntegerNode;
import org.codehaus.jackson.node.BooleanNode;
import org.codehaus.jackson.node.DecimalNode;
import org.codehaus.jackson.node.DoubleNode;
import org.codehaus.jackson.node.IntNode;
import org.codehaus.jackson.node.LongNode;
import org.codehaus.jackson.node.TextNode;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JMock.class)
public class JsonValueEncoderTest_asAdapter {
    private final Mockery context = new JUnit4Mockery();
    private JsonValueEncoder jsonValueEncoder;
    private JsonRepresentation representation;
    private ObjectSpecification objectSpec;
    private EncodableFacet encodableFacet;
    private ObjectAdapter objectAdapter;

    @Before
    public void setUp() throws Exception {
        this.objectSpec = (ObjectSpecification)this.context.mock(ObjectSpecification.class);
        this.encodableFacet = (EncodableFacet)this.context.mock(EncodableFacet.class);
        this.objectAdapter = (ObjectAdapter)this.context.mock(ObjectAdapter.class);
        this.representation = new JsonRepresentation((JsonNode)TextNode.valueOf((String)"aString"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void whenSpecIsNull() throws Exception {
        JsonValueEncoder.asAdapter(null, (JsonRepresentation)this.representation);
    }

    @Test(expected=IllegalArgumentException.class)
    public void whenReprIsNull() throws Exception {
        this.allowingObjectSpecHas(EncodableFacet.class, this.encodableFacet);
        JsonValueEncoder.asAdapter((ObjectSpecification)this.objectSpec, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void whenReprIsAnArray() throws Exception {
        this.allowingObjectSpecHas(EncodableFacet.class, this.encodableFacet);
        JsonValueEncoder.asAdapter((ObjectSpecification)this.objectSpec, (JsonRepresentation)JsonRepresentation.newArray());
    }

    @Test(expected=IllegalArgumentException.class)
    public void whenReprIsAMap() throws Exception {
        this.allowingObjectSpecHas(EncodableFacet.class, this.encodableFacet);
        Assert.assertNull((Object)JsonValueEncoder.asAdapter((ObjectSpecification)this.objectSpec, (JsonRepresentation)JsonRepresentation.newMap((String[])new String[0])));
    }

    @Test(expected=IllegalArgumentException.class)
    public void whenSpecDoesNotHaveAnEncodableFacet() throws Exception {
        this.allowingObjectSpecHas(EncodableFacet.class, null);
        Assert.assertNull((Object)JsonValueEncoder.asAdapter((ObjectSpecification)this.objectSpec, (JsonRepresentation)this.representation));
    }

    @Test
    public void whenReprIsBooleanPrimitive() throws Exception {
        this.whenReprIsBoolean(Boolean.TYPE);
    }

    @Test
    public void whenReprIsBooleanWrapper() throws Exception {
        this.whenReprIsBoolean(Boolean.class);
    }

    private void whenReprIsBoolean(Class<?> correspondingClass) {
        this.allowingObjectSpecHas(EncodableFacet.class, this.encodableFacet);
        this.allowingObjectSpecCorrespondingClassIs(correspondingClass);
        boolean value = true;
        this.representation = new JsonRepresentation((JsonNode)BooleanNode.valueOf((boolean)true));
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((EncodableFacet)this.one(JsonValueEncoderTest_asAdapter.this.encodableFacet)).fromEncodedString("true");
                this.will(1.returnValue((Object)JsonValueEncoderTest_asAdapter.this.objectAdapter));
            }
        });
        ObjectAdapter adapter = JsonValueEncoder.asAdapter((ObjectSpecification)this.objectSpec, (JsonRepresentation)this.representation);
        Assert.assertSame((Object)this.objectAdapter, (Object)adapter);
    }

    @Test(expected=IllegalArgumentException.class)
    public void whenObjectSpecIsBooleanButReprIsNot() throws Exception {
        this.allowingObjectSpecHas(EncodableFacet.class, this.encodableFacet);
        this.allowingObjectSpecCorrespondingClassIs(Boolean.TYPE);
        JsonValueEncoder.asAdapter((ObjectSpecification)this.objectSpec, (JsonRepresentation)this.representation);
    }

    @Test
    public void whenReprIsIntegerPrimitive() throws Exception {
        this.whenReprIsInteger(Integer.TYPE);
    }

    @Test
    public void whenReprIsIntegerWrapper() throws Exception {
        this.whenReprIsInteger(Integer.class);
    }

    private void whenReprIsInteger(Class<?> correspondingClass) {
        this.allowingObjectSpecHas(EncodableFacet.class, this.encodableFacet);
        this.allowingObjectSpecCorrespondingClassIs(correspondingClass);
        int value = 123;
        this.representation = new JsonRepresentation((JsonNode)IntNode.valueOf((int)123));
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((EncodableFacet)this.one(JsonValueEncoderTest_asAdapter.this.encodableFacet)).fromEncodedString("123");
                this.will(2.returnValue((Object)JsonValueEncoderTest_asAdapter.this.objectAdapter));
            }
        });
        ObjectAdapter adapter = JsonValueEncoder.asAdapter((ObjectSpecification)this.objectSpec, (JsonRepresentation)this.representation);
        Assert.assertSame((Object)this.objectAdapter, (Object)adapter);
    }

    @Test(expected=IllegalArgumentException.class)
    public void whenObjectSpecIsIntegerButReprIsNot() throws Exception {
        this.allowingObjectSpecHas(EncodableFacet.class, this.encodableFacet);
        this.allowingObjectSpecCorrespondingClassIs(Integer.TYPE);
        this.representation = JsonRepresentation.newMap((String[])new String[]{"foo", "bar"});
        JsonValueEncoder.asAdapter((ObjectSpecification)this.objectSpec, (JsonRepresentation)this.representation);
    }

    @Test
    public void whenReprIsLongPrimitive() throws Exception {
        this.whenReprIsLong(Long.TYPE);
    }

    @Test
    public void whenReprIsLongWrapper() throws Exception {
        this.whenReprIsLong(Long.class);
    }

    private void whenReprIsLong(Class<?> correspondingClass) {
        this.allowingObjectSpecHas(EncodableFacet.class, this.encodableFacet);
        this.allowingObjectSpecCorrespondingClassIs(correspondingClass);
        long value = 1234567890L;
        this.representation = new JsonRepresentation((JsonNode)LongNode.valueOf((long)1234567890L));
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((EncodableFacet)this.one(JsonValueEncoderTest_asAdapter.this.encodableFacet)).fromEncodedString("1234567890");
                this.will(3.returnValue((Object)JsonValueEncoderTest_asAdapter.this.objectAdapter));
            }
        });
        ObjectAdapter adapter = JsonValueEncoder.asAdapter((ObjectSpecification)this.objectSpec, (JsonRepresentation)this.representation);
        Assert.assertSame((Object)this.objectAdapter, (Object)adapter);
    }

    @Test(expected=IllegalArgumentException.class)
    public void whenObjectSpecIsLongButReprIsNot() throws Exception {
        this.allowingObjectSpecHas(EncodableFacet.class, this.encodableFacet);
        this.allowingObjectSpecCorrespondingClassIs(Long.TYPE);
        JsonValueEncoder.asAdapter((ObjectSpecification)this.objectSpec, (JsonRepresentation)this.representation);
    }

    @Test
    public void whenReprIsDoublePrimitive() throws Exception {
        this.whenReprIsDouble(Double.TYPE);
    }

    @Test
    public void whenReprIsDoubleWrapper() throws Exception {
        this.whenReprIsDouble(Double.class);
    }

    private void whenReprIsDouble(Class<?> correspondingClass) {
        this.allowingObjectSpecHas(EncodableFacet.class, this.encodableFacet);
        this.allowingObjectSpecCorrespondingClassIs(correspondingClass);
        double value = 123.45;
        this.representation = new JsonRepresentation((JsonNode)DoubleNode.valueOf((double)123.45));
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((EncodableFacet)this.one(JsonValueEncoderTest_asAdapter.this.encodableFacet)).fromEncodedString("123.45");
                this.will(4.returnValue((Object)JsonValueEncoderTest_asAdapter.this.objectAdapter));
            }
        });
        ObjectAdapter adapter = JsonValueEncoder.asAdapter((ObjectSpecification)this.objectSpec, (JsonRepresentation)this.representation);
        Assert.assertSame((Object)this.objectAdapter, (Object)adapter);
    }

    @Test(expected=IllegalArgumentException.class)
    public void whenObjectSpecIsDoubleButReprIsNot() throws Exception {
        this.allowingObjectSpecHas(EncodableFacet.class, this.encodableFacet);
        this.allowingObjectSpecCorrespondingClassIs(Double.TYPE);
        this.representation = JsonRepresentation.newMap((String[])new String[]{"foo", "bar"});
        JsonValueEncoder.asAdapter((ObjectSpecification)this.objectSpec, (JsonRepresentation)this.representation);
    }

    @Test
    public void whenReprIsBigInteger() throws Exception {
        this.allowingObjectSpecHas(EncodableFacet.class, this.encodableFacet);
        this.allowingObjectSpecCorrespondingClassIs(BigInteger.class);
        final BigInteger value = BigInteger.valueOf(123L);
        this.representation = new JsonRepresentation((JsonNode)BigIntegerNode.valueOf((BigInteger)value));
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((EncodableFacet)this.one(JsonValueEncoderTest_asAdapter.this.encodableFacet)).fromEncodedString("" + value);
                this.will(5.returnValue((Object)JsonValueEncoderTest_asAdapter.this.objectAdapter));
            }
        });
        ObjectAdapter adapter = JsonValueEncoder.asAdapter((ObjectSpecification)this.objectSpec, (JsonRepresentation)this.representation);
        Assert.assertSame((Object)this.objectAdapter, (Object)adapter);
    }

    @Test(expected=IllegalArgumentException.class)
    public void whenObjectSpecIsBigIntegerButReprIsNot() throws Exception {
        this.allowingObjectSpecHas(EncodableFacet.class, this.encodableFacet);
        this.allowingObjectSpecCorrespondingClassIs(BigInteger.class);
        this.representation = JsonRepresentation.newMap((String[])new String[]{"foo", "bar"});
        JsonValueEncoder.asAdapter((ObjectSpecification)this.objectSpec, (JsonRepresentation)this.representation);
    }

    @Test
    public void whenReprIsBigDecimal() throws Exception {
        this.allowingObjectSpecHas(EncodableFacet.class, this.encodableFacet);
        this.allowingObjectSpecCorrespondingClassIs(BigDecimal.class);
        final BigDecimal value = new BigDecimal("123234234.45612312343535");
        this.representation = new JsonRepresentation((JsonNode)DecimalNode.valueOf((BigDecimal)value));
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((EncodableFacet)this.one(JsonValueEncoderTest_asAdapter.this.encodableFacet)).fromEncodedString("" + value);
                this.will(6.returnValue((Object)JsonValueEncoderTest_asAdapter.this.objectAdapter));
            }
        });
        ObjectAdapter adapter = JsonValueEncoder.asAdapter((ObjectSpecification)this.objectSpec, (JsonRepresentation)this.representation);
        Assert.assertSame((Object)this.objectAdapter, (Object)adapter);
    }

    @Test(expected=IllegalArgumentException.class)
    public void whenObjectSpecIsBigDecimalButReprIsNot() throws Exception {
        this.allowingObjectSpecHas(EncodableFacet.class, this.encodableFacet);
        this.allowingObjectSpecCorrespondingClassIs(BigDecimal.class);
        this.representation = JsonRepresentation.newMap((String[])new String[]{"foo", "bar"});
        JsonValueEncoder.asAdapter((ObjectSpecification)this.objectSpec, (JsonRepresentation)this.representation);
    }

    @Test
    public void whenReprIsString() throws Exception {
        this.allowingObjectSpecHas(EncodableFacet.class, this.encodableFacet);
        this.allowingObjectSpecCorrespondingClassIs(String.class);
        this.representation = new JsonRepresentation((JsonNode)TextNode.valueOf((String)"aString"));
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((EncodableFacet)this.one(JsonValueEncoderTest_asAdapter.this.encodableFacet)).fromEncodedString("aString");
                this.will(7.returnValue((Object)JsonValueEncoderTest_asAdapter.this.objectAdapter));
            }
        });
        ObjectAdapter adapter = JsonValueEncoder.asAdapter((ObjectSpecification)this.objectSpec, (JsonRepresentation)this.representation);
        Assert.assertSame((Object)this.objectAdapter, (Object)adapter);
    }

    private <T extends Facet> void allowingObjectSpecHas(final Class<T> facetClass, final T encodableFacet) {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((ObjectSpecification)this.allowing(JsonValueEncoderTest_asAdapter.this.objectSpec)).getFacet(facetClass);
                this.will(8.returnValue((Object)encodableFacet));
            }
        });
    }

    private void allowingObjectSpecCorrespondingClassIs(final Class<?> result) {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((ObjectSpecification)this.allowing(JsonValueEncoderTest_asAdapter.this.objectSpec)).getCorrespondingClass();
                this.will(9.returnValue((Object)result));
            }
        });
    }
}

