/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.applib.domainobjects;

import org.apache.isis.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.LinkRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.Rel;
import org.codehaus.jackson.JsonNode;

public abstract class DomainRepresentation
extends JsonRepresentation
implements JsonRepresentation.HasLinkToSelf,
JsonRepresentation.HasLinks,
JsonRepresentation.HasExtensions {
    public DomainRepresentation(JsonNode jsonNode) {
        super(jsonNode);
    }

    @Override
    public LinkRepresentation getSelf() {
        return this.getLinkWithRel(Rel.SELF);
    }

    @Override
    public JsonRepresentation getLinks() {
        return this.getArray("links").ensureArray();
    }

    public LinkRepresentation getLinkWithRel(Rel rel) {
        for (LinkRepresentation linkRepr : this.getLinks().arrayIterable(LinkRepresentation.class)) {
            if (!rel.matches(linkRepr.getRel())) continue;
            return linkRepr;
        }
        return null;
    }

    public LinkRepresentation getLinkWithRel(String rel) {
        return this.getLink(String.format("links[rel=%s]", rel));
    }

    @Override
    public JsonRepresentation getExtensions() {
        return this.getMap("extensions");
    }
}

