/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.applib.domainobjects;

import java.io.InputStream;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.annotations.ClientResponseType;

@Path(value="/services")
public interface DomainServiceResource {
    @GET
    @Path(value="/")
    @Produces(value={"application/json", "application/json;profile=urn:org.restfulobjects:repr-types/list", "application/json;profile=urn:org.restfulobjects:repr-types/error"})
    @ClientResponseType(entityType=String.class)
    public Response services();

    @GET
    @Path(value="/{serviceId}")
    @Produces(value={"application/json", "application/json;profile=urn:org.restfulobjects:repr-types/object", "application/json;profile=urn:org.restfulobjects:repr-types/error"})
    @ClientResponseType(entityType=String.class)
    public Response service(@PathParam(value="serviceId") String var1);

    @GET
    @Path(value="/{serviceId}/properties/{propertyId}")
    @Produces(value={"application/json", "application/json;profile=urn:org.restfulobjects:repr-types/object-property", "application/json;profile=urn:org.restfulobjects:repr-types/error"})
    public Response propertyDetails(@PathParam(value="serviceId") String var1, @PathParam(value="propertyId") String var2);

    @GET
    @Path(value="/{serviceId}/actions/{actionId}")
    @Produces(value={"application/json", "application/json;profile=urn:org.restfulobjects:repr-types/object-action", "application/json;profile=urn:org.restfulobjects:repr-types/error"})
    @ClientResponseType(entityType=String.class)
    public Response actionPrompt(@PathParam(value="serviceId") String var1, @PathParam(value="actionId") String var2);

    @GET
    @Path(value="/{serviceId}/actions/{actionId}/invoke")
    @Produces(value={"application/json", "application/json;profile=urn:org.restfulobjects:repr-types/action-result", "application/json;profile=urn:org.restfulobjects:repr-types/error"})
    @ClientResponseType(entityType=String.class)
    public Response invokeActionQueryOnly(@PathParam(value="serviceId") String var1, @PathParam(value="actionId") String var2, @QueryParam(value="x-isis-querystring") String var3);

    @PUT
    @Path(value="/{serviceId}/actions/{actionId}/invoke")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json", "application/json;profile=urn:org.restfulobjects:repr-types/action-result", "application/json;profile=urn:org.restfulobjects:repr-types/error"})
    @ClientResponseType(entityType=String.class)
    public Response invokeActionIdempotent(@PathParam(value="serviceId") String var1, @PathParam(value="actionId") String var2, InputStream var3);

    @POST
    @Path(value="/{serviceId}/actions/{actionId}/invoke")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json", "application/json;profile=urn:org.restfulobjects:repr-types/action-result", "application/json;profile=urn:org.restfulobjects:repr-types/error"})
    @ClientResponseType(entityType=String.class)
    public Response invokeAction(@PathParam(value="serviceId") String var1, @PathParam(value="actionId") String var2, InputStream var3);
}

