/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.applib.domainobjects;

import org.apache.isis.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.LinkRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.Rel;
import org.apache.isis.viewer.restfulobjects.applib.domainobjects.DomainObjectMemberRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.domainobjects.DomainRepresentation;
import org.codehaus.jackson.JsonNode;

public class DomainObjectRepresentation
extends DomainRepresentation {
    public DomainObjectRepresentation(JsonNode jsonNode) {
        super(jsonNode);
    }

    public String getTitle() {
        return this.getString("title");
    }

    public String getDomainType() {
        return this.getString("domainType");
    }

    public String getInstanceId() {
        return this.getString("instanceId");
    }

    public String getServiceId() {
        return this.getString("serviceId");
    }

    public JsonRepresentation getMembers() {
        return this.getRepresentation("members", new Object[0]);
    }

    public DomainObjectMemberRepresentation getProperty(String id) {
        return this.getMember(id, "property");
    }

    public JsonRepresentation getProperties() {
        return this.getRepresentation("members[memberType=property]", new Object[0]).ensureArray();
    }

    public DomainObjectMemberRepresentation getCollection(String id) {
        return this.getMember(id, "collection");
    }

    public JsonRepresentation getCollections() {
        return this.getRepresentation("members[memberType=collection]", new Object[0]).ensureArray();
    }

    public DomainObjectMemberRepresentation getAction(String id) {
        return this.getMember(id, "action");
    }

    private DomainObjectMemberRepresentation getMember(String id, String memberType) {
        JsonRepresentation jsonRepr = this.getRepresentation("members.%s", id);
        if (jsonRepr == null) {
            return null;
        }
        DomainObjectMemberRepresentation member = jsonRepr.as(DomainObjectMemberRepresentation.class);
        return member.getMemberType().equals(memberType) ? member : null;
    }

    public JsonRepresentation getActions() {
        return this.getRepresentation("members[memberType=action]", new Object[0]);
    }

    public LinkRepresentation getPersistLink() {
        return this.getLinkWithRel(Rel.PERSIST);
    }

    public String getOid() {
        return this.getString("extensions.oid");
    }
}

