/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.applib.client;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.isis.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.client.ClientRequestConfigurer;
import org.apache.isis.viewer.restfulobjects.applib.client.RestfulResponse;
import org.apache.isis.viewer.restfulobjects.applib.util.Parser;
import org.jboss.resteasy.client.ClientResponse;
import org.jboss.resteasy.client.core.BaseClientResponse;

public final class RestfulRequest {
    private final ClientRequestConfigurer clientRequestConfigurer;
    private final Map<RequestParameter<?>, Object> args = Maps.newLinkedHashMap();

    public RestfulRequest(ClientRequestConfigurer clientRequestConfigurer) {
        this.clientRequestConfigurer = clientRequestConfigurer;
    }

    public <T> RestfulRequest withHeader(Header<T> header, T t) {
        header.setHeader(this.clientRequestConfigurer, t);
        return this;
    }

    public <T> RestfulRequest withHeader(Header<List<T>> header, T ... ts) {
        header.setHeader(this.clientRequestConfigurer, Arrays.asList(ts));
        return this;
    }

    public <Q> RestfulRequest withArg(RequestParameter<Q> queryParam, String argStrFormat, Object ... args) {
        String argStr = String.format(argStrFormat, args);
        Q arg = queryParam.getParser().valueOf(argStr);
        return this.withArg(queryParam, arg);
    }

    public <Q> RestfulRequest withArg(RequestParameter<Q> queryParam, Q arg) {
        this.args.put(queryParam, arg);
        return this;
    }

    public RestfulResponse<JsonRepresentation> execute() {
        try {
            if (!this.args.isEmpty()) {
                this.clientRequestConfigurer.configureArgs(this.args);
            }
            ClientResponse response = this.clientRequestConfigurer.getClientRequest().execute();
            BaseClientResponse restEasyResponse = (BaseClientResponse)response;
            restEasyResponse.setReturnType(String.class);
            return RestfulResponse.ofT((Response)response);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public <T extends JsonRepresentation> RestfulResponse<T> executeT() {
        RestfulResponse<JsonRepresentation> restfulResponse = this.execute();
        return restfulResponse;
    }

    ClientRequestConfigurer getClientRequestConfigurer() {
        return this.clientRequestConfigurer;
    }

    public static class Header<X> {
        public static Header<String> IF_MATCH = new Header<String>("If-Match", Parser.forString());
        public static Header<List<MediaType>> ACCEPT = new Header<List<MediaType>>("Accept", Parser.forListOfJaxRsMediaTypes());
        private final String name;
        private final Parser<X> parser;

        public Header(String name, Parser<X> parser) {
            this.name = name;
            this.parser = parser;
        }

        public String getName() {
            return this.name;
        }

        public Parser<X> getParser() {
            return this.parser;
        }

        void setHeader(ClientRequestConfigurer clientRequestConfigurer, X t) {
            clientRequestConfigurer.header(this.getName(), this.parser.asString(t));
        }

        public String toString() {
            return this.getName();
        }
    }

    public static class RequestParameter<Q> {
        public static RequestParameter<List<List<String>>> FOLLOW_LINKS = new RequestParameter("x-ro-follow-links", Parser.forListOfListOfStrings(), Collections.emptyList());
        public static RequestParameter<Integer> PAGE = new RequestParameter<Integer>("x-ro-page", Parser.forInteger(), 1);
        public static RequestParameter<Integer> PAGE_SIZE = new RequestParameter<Integer>("x-ro-page-size", Parser.forInteger(), 25);
        public static RequestParameter<List<String>> SORT_BY = new RequestParameter("x-ro-sort-by", Parser.forListOfStrings(), Collections.emptyList());
        public static RequestParameter<DomainModel> DOMAIN_MODEL = new RequestParameter<DomainModel>("x-ro-domain-model", DomainModel.parser(), DomainModel.FORMAL);
        public static RequestParameter<Boolean> VALIDATE_ONLY = new RequestParameter<Boolean>("x-ro-validate-only", Parser.forBoolean(), false);
        private final String name;
        private final Parser<Q> parser;
        private final Q defaultValue;

        private RequestParameter(String name, Parser<Q> parser, Q defaultValue) {
            this.name = name;
            this.parser = parser;
            this.defaultValue = defaultValue;
        }

        public String getName() {
            return this.name;
        }

        public Parser<Q> getParser() {
            return this.parser;
        }

        public Q valueOf(JsonRepresentation parameterRepresentation) {
            if (parameterRepresentation == null) {
                return this.defaultValue;
            }
            if (!parameterRepresentation.isMap()) {
                return this.defaultValue;
            }
            Q parsedValue = this.getParser().valueOf(parameterRepresentation.getRepresentation(this.getName(), new Object[0]));
            return parsedValue != null ? parsedValue : this.defaultValue;
        }

        public Q getDefault() {
            return this.defaultValue;
        }

        public String toString() {
            return this.getName();
        }
    }

    public static enum DomainModel {
        NONE,
        SIMPLE,
        FORMAL,
        SELECTABLE;


        public static Parser<DomainModel> parser() {
            return new Parser<DomainModel>(){

                @Override
                public DomainModel valueOf(String str) {
                    return DomainModel.valueOf(str.toUpperCase());
                }

                @Override
                public String asString(DomainModel t) {
                    return t.name().toLowerCase();
                }
            };
        }

        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

