/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.applib;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.isis.viewer.restfulobjects.applib.LinkRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.util.JsonNodeUtils;
import org.apache.isis.viewer.restfulobjects.applib.util.PathNode;
import org.apache.isis.viewer.restfulobjects.applib.util.UrlEncodingUtils;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.JsonNodeFactory;
import org.codehaus.jackson.node.NullNode;
import org.codehaus.jackson.node.ObjectNode;
import org.codehaus.jackson.node.POJONode;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class JsonRepresentation {
    private static Map<Class<?>, Function<JsonNode, ?>> REPRESENTATION_INSTANTIATORS = Maps.newHashMap();
    protected final JsonNode jsonNode;
    public static final DateTimeFormatter yyyyMMdd;
    public static final DateTimeFormatter yyyyMMddTHHmmssZ;
    private static final Function<Map.Entry<String, JsonNode>, Map.Entry<String, JsonRepresentation>> MAP_ENTRY_JSON_NODE_TO_JSON_REPRESENTATION;

    private static <T> Function<JsonNode, ?> representationInstantiatorFor(final Class<T> representationType) {
        Function transformer = REPRESENTATION_INSTANTIATORS.get(representationType);
        if (transformer == null) {
            transformer = new Function<JsonNode, T>(){

                public T apply(JsonNode input) {
                    try {
                        Constructor constructor = representationType.getConstructor(JsonNode.class);
                        return constructor.newInstance(input);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("Conversions from JsonNode to " + representationType + " are not supported");
                    }
                }
            };
            REPRESENTATION_INSTANTIATORS.put(representationType, transformer);
        }
        return transformer;
    }

    public static JsonRepresentation newMap(String ... keyValuePairs) {
        JsonRepresentation repr = new JsonRepresentation((JsonNode)new ObjectNode(JsonNodeFactory.instance));
        String key = null;
        for (String keyOrValue : keyValuePairs) {
            if (key != null) {
                repr.mapPut(key, keyOrValue);
                key = null;
                continue;
            }
            key = keyOrValue;
        }
        if (key != null) {
            throw new IllegalArgumentException("must provide an even number of keys and values");
        }
        return repr;
    }

    public static JsonRepresentation newArray() {
        return JsonRepresentation.newArray(0);
    }

    public static JsonRepresentation newArray(int initialSize) {
        ArrayNode arrayNode = new ArrayNode(JsonNodeFactory.instance);
        for (int i = 0; i < initialSize; ++i) {
            arrayNode.addNull();
        }
        return new JsonRepresentation((JsonNode)arrayNode);
    }

    public JsonRepresentation(JsonNode jsonNode) {
        this.jsonNode = jsonNode;
    }

    public JsonNode asJsonNode() {
        return this.jsonNode;
    }

    public int size() {
        if (!this.isMap() && !this.isArray()) {
            throw new IllegalStateException("not a map or an array");
        }
        return this.jsonNode.size();
    }

    public boolean isValue() {
        return this.jsonNode.isValueNode();
    }

    public JsonRepresentation getRepresentation(String pathTemplate, Object ... args) {
        String pathStr = String.format(pathTemplate, args);
        JsonNode node = this.getNode(pathStr);
        if (JsonRepresentation.representsNull(node)) {
            return null;
        }
        return new JsonRepresentation(node);
    }

    public boolean isArray(String path) {
        return this.isArray(this.getNode(path));
    }

    public boolean isArray() {
        return this.isArray(this.asJsonNode());
    }

    private boolean isArray(JsonNode node) {
        return !JsonRepresentation.representsNull(node) && node.isArray();
    }

    public JsonRepresentation getArray(String path) {
        return this.getArray(path, this.getNode(path));
    }

    public JsonRepresentation asArray() {
        return this.getArray(null, this.asJsonNode());
    }

    private JsonRepresentation getArray(String path, JsonNode node) {
        if (JsonRepresentation.representsNull(node)) {
            return null;
        }
        if (!this.isArray(node)) {
            throw new IllegalArgumentException(JsonRepresentation.formatExMsg(path, "is not an array"));
        }
        return new JsonRepresentation(node);
    }

    public JsonRepresentation getArrayEnsured(String path) {
        return this.getArrayEnsured(path, this.getNode(path));
    }

    private JsonRepresentation getArrayEnsured(String path, JsonNode node) {
        if (JsonRepresentation.representsNull(node)) {
            return null;
        }
        return new JsonRepresentation(node).ensureArray();
    }

    public boolean isMap(String path) {
        return this.isMap(this.getNode(path));
    }

    public boolean isMap() {
        return this.isMap(this.asJsonNode());
    }

    private boolean isMap(JsonNode node) {
        return !JsonRepresentation.representsNull(node) && !node.isArray() && !node.isValueNode();
    }

    public JsonRepresentation getMap(String path) {
        return this.getMap(path, this.getNode(path));
    }

    public JsonRepresentation asMap() {
        return this.getMap(null, this.asJsonNode());
    }

    private JsonRepresentation getMap(String path, JsonNode node) {
        if (JsonRepresentation.representsNull(node)) {
            return null;
        }
        if (this.isArray(node) || node.isValueNode()) {
            throw new IllegalArgumentException(JsonRepresentation.formatExMsg(path, "is not a map"));
        }
        return new JsonRepresentation(node);
    }

    public boolean isNumber(String path) {
        return this.isNumber(this.getNode(path));
    }

    public boolean isNumber() {
        return this.isNumber(this.asJsonNode());
    }

    private boolean isNumber(JsonNode node) {
        return !JsonRepresentation.representsNull(node) && node.isValueNode() && node.isNumber();
    }

    public Number asNumber() {
        return this.getNumber(null, this.asJsonNode());
    }

    private Number getNumber(String path, JsonNode node) {
        if (JsonRepresentation.representsNull(node)) {
            return null;
        }
        JsonRepresentation.checkValue(path, node, "a number");
        if (!node.isNumber()) {
            throw new IllegalArgumentException(JsonRepresentation.formatExMsg(path, "is not a number"));
        }
        return node.getNumberValue();
    }

    public boolean isIntegralNumber(String path) {
        return this.isIntegralNumber(this.getNode(path));
    }

    public boolean isIntegralNumber() {
        return this.isIntegralNumber(this.asJsonNode());
    }

    private boolean isIntegralNumber(JsonNode node) {
        return !JsonRepresentation.representsNull(node) && node.isValueNode() && node.isIntegralNumber();
    }

    public Date getDate(String path) {
        return this.getDate(path, this.getNode(path));
    }

    public Date asDate() {
        return this.getDate(null, this.asJsonNode());
    }

    private Date getDate(String path, JsonNode node) {
        if (JsonRepresentation.representsNull(node)) {
            return null;
        }
        JsonRepresentation.checkValue(path, node, "a date");
        if (!node.isTextual()) {
            throw new IllegalArgumentException(JsonRepresentation.formatExMsg(path, "is not a date"));
        }
        String textValue = node.getTextValue();
        return new Date(yyyyMMdd.parseMillis(textValue));
    }

    public Date getDateTime(String path) {
        return this.getDateTime(path, this.getNode(path));
    }

    public Date asDateTime() {
        return this.getDateTime(null, this.asJsonNode());
    }

    private Date getDateTime(String path, JsonNode node) {
        if (JsonRepresentation.representsNull(node)) {
            return null;
        }
        JsonRepresentation.checkValue(path, node, "a date-time");
        if (!node.isTextual()) {
            throw new IllegalArgumentException(JsonRepresentation.formatExMsg(path, "is not a date-time"));
        }
        String textValue = node.getTextValue();
        return new Date(yyyyMMddTHHmmssZ.parseMillis(textValue));
    }

    public boolean isBoolean(String path) {
        return this.isBoolean(this.getNode(path));
    }

    public boolean isBoolean() {
        return this.isBoolean(this.asJsonNode());
    }

    private boolean isBoolean(JsonNode node) {
        return !JsonRepresentation.representsNull(node) && node.isValueNode() && node.isBoolean();
    }

    public Boolean getBoolean(String path) {
        return this.getBoolean(path, this.getNode(path));
    }

    public Boolean asBoolean() {
        return this.getBoolean(null, this.asJsonNode());
    }

    private Boolean getBoolean(String path, JsonNode node) {
        if (JsonRepresentation.representsNull(node)) {
            return null;
        }
        JsonRepresentation.checkValue(path, node, "a boolean");
        if (!node.isBoolean()) {
            throw new IllegalArgumentException(JsonRepresentation.formatExMsg(path, "is not a boolean"));
        }
        return node.getBooleanValue();
    }

    public Byte getByte(String path) {
        JsonNode node = this.getNode(path);
        return this.getByte(path, node);
    }

    public Byte asByte() {
        return this.getByte(null, this.asJsonNode());
    }

    private Byte getByte(String path, JsonNode node) {
        if (JsonRepresentation.representsNull(node)) {
            return null;
        }
        JsonRepresentation.checkValue(path, node, "an byte");
        if (!node.isNumber()) {
            throw new IllegalArgumentException(JsonRepresentation.formatExMsg(path, "is not a number"));
        }
        return node.getNumberValue().byteValue();
    }

    public Short getShort(String path) {
        JsonNode node = this.getNode(path);
        return this.getShort(path, node);
    }

    public Short asShort() {
        return this.getShort(null, this.asJsonNode());
    }

    private Short getShort(String path, JsonNode node) {
        if (JsonRepresentation.representsNull(node)) {
            return null;
        }
        JsonRepresentation.checkValue(path, node, "an short");
        if (!node.isNumber()) {
            throw new IllegalArgumentException(JsonRepresentation.formatExMsg(path, "is not a number"));
        }
        return node.getNumberValue().shortValue();
    }

    public Character getChar(String path) {
        JsonNode node = this.getNode(path);
        return this.getChar(path, node);
    }

    public Character asChar() {
        return this.getChar(null, this.asJsonNode());
    }

    private Character getChar(String path, JsonNode node) {
        if (JsonRepresentation.representsNull(node)) {
            return null;
        }
        JsonRepresentation.checkValue(path, node, "an short");
        if (!node.isTextual()) {
            throw new IllegalArgumentException(JsonRepresentation.formatExMsg(path, "is not textual"));
        }
        String textValue = node.getTextValue();
        if (textValue == null || textValue.length() == 0) {
            return null;
        }
        return Character.valueOf(textValue.charAt(0));
    }

    public boolean isInt(String path) {
        return this.isInt(this.getNode(path));
    }

    public boolean isInt() {
        return this.isInt(this.asJsonNode());
    }

    private boolean isInt(JsonNode node) {
        return !JsonRepresentation.representsNull(node) && node.isValueNode() && node.isInt();
    }

    public Integer getInt(String path) {
        JsonNode node = this.getNode(path);
        return this.getInt(path, node);
    }

    public Integer asInt() {
        return this.getInt(null, this.asJsonNode());
    }

    private Integer getInt(String path, JsonNode node) {
        if (JsonRepresentation.representsNull(node)) {
            return null;
        }
        JsonRepresentation.checkValue(path, node, "an int");
        if (!node.isInt()) {
            throw new IllegalArgumentException(JsonRepresentation.formatExMsg(path, "is not an int"));
        }
        return node.getIntValue();
    }

    public boolean isLong(String path) {
        return this.isLong(this.getNode(path));
    }

    public boolean isLong() {
        return this.isLong(this.asJsonNode());
    }

    private boolean isLong(JsonNode node) {
        return !JsonRepresentation.representsNull(node) && node.isValueNode() && node.isLong();
    }

    public Long getLong(String path) {
        JsonNode node = this.getNode(path);
        return this.getLong(path, node);
    }

    public Long asLong() {
        return this.getLong(null, this.asJsonNode());
    }

    private Long getLong(String path, JsonNode node) {
        if (JsonRepresentation.representsNull(node)) {
            return null;
        }
        JsonRepresentation.checkValue(path, node, "a long");
        if (!node.isLong()) {
            throw new IllegalArgumentException(JsonRepresentation.formatExMsg(path, "is not a long"));
        }
        return node.getLongValue();
    }

    public Float getFloat(String path) {
        JsonNode node = this.getNode(path);
        return this.getFloat(path, node);
    }

    public Float asFloat() {
        return this.getFloat(null, this.asJsonNode());
    }

    private Float getFloat(String path, JsonNode node) {
        if (JsonRepresentation.representsNull(node)) {
            return null;
        }
        JsonRepresentation.checkValue(path, node, "a float");
        if (!node.isNumber()) {
            throw new IllegalArgumentException(JsonRepresentation.formatExMsg(path, "is not a number"));
        }
        return Float.valueOf(node.getNumberValue().floatValue());
    }

    public boolean isDouble(String path) {
        return this.isDouble(this.getNode(path));
    }

    public boolean isDouble() {
        return this.isDouble(this.asJsonNode());
    }

    private boolean isDouble(JsonNode node) {
        return !JsonRepresentation.representsNull(node) && node.isValueNode() && node.isDouble();
    }

    public Double getDouble(String path) {
        JsonNode node = this.getNode(path);
        return this.getDouble(path, node);
    }

    public Double asDouble() {
        return this.getDouble(null, this.asJsonNode());
    }

    private Double getDouble(String path, JsonNode node) {
        if (JsonRepresentation.representsNull(node)) {
            return null;
        }
        JsonRepresentation.checkValue(path, node, "a double");
        if (!node.isDouble()) {
            throw new IllegalArgumentException(JsonRepresentation.formatExMsg(path, "is not a double"));
        }
        return node.getDoubleValue();
    }

    public boolean isBigInteger(String path) {
        return this.isBigInteger(this.getNode(path));
    }

    public boolean isBigInteger() {
        return this.isBigInteger(this.asJsonNode());
    }

    private boolean isBigInteger(JsonNode node) {
        return !JsonRepresentation.representsNull(node) && node.isValueNode() && node.isBigInteger();
    }

    public BigInteger getBigInteger(String path) {
        JsonNode node = this.getNode(path);
        return this.getBigInteger(path, node);
    }

    public BigInteger asBigInteger() {
        return this.getBigInteger(null, this.asJsonNode());
    }

    private BigInteger getBigInteger(String path, JsonNode node) {
        if (JsonRepresentation.representsNull(node)) {
            return null;
        }
        JsonRepresentation.checkValue(path, node, "a biginteger");
        if (!node.isBigInteger()) {
            throw new IllegalArgumentException(JsonRepresentation.formatExMsg(path, "is not a biginteger"));
        }
        return node.getBigIntegerValue();
    }

    public boolean isBigDecimal(String path) {
        return this.isBigDecimal(this.getNode(path));
    }

    public boolean isBigDecimal() {
        return this.isBigDecimal(this.asJsonNode());
    }

    private boolean isBigDecimal(JsonNode node) {
        return !JsonRepresentation.representsNull(node) && node.isValueNode() && node.isBigDecimal();
    }

    public BigDecimal getBigDecimal(String path) {
        JsonNode node = this.getNode(path);
        return this.getBigDecimal(path, node);
    }

    public BigDecimal asBigDecimal() {
        return this.getBigDecimal(null, this.asJsonNode());
    }

    private BigDecimal getBigDecimal(String path, JsonNode node) {
        if (JsonRepresentation.representsNull(node)) {
            return null;
        }
        JsonRepresentation.checkValue(path, node, "a biginteger");
        if (!node.isBigDecimal()) {
            throw new IllegalArgumentException(JsonRepresentation.formatExMsg(path, "is not a biginteger"));
        }
        return node.getDecimalValue();
    }

    public boolean isString(String path) {
        return this.isString(this.getNode(path));
    }

    public boolean isString() {
        return this.isString(this.asJsonNode());
    }

    private boolean isString(JsonNode node) {
        return !JsonRepresentation.representsNull(node) && node.isValueNode() && node.isTextual();
    }

    public String getString(String path) {
        JsonNode node = this.getNode(path);
        return this.getString(path, node);
    }

    public String asString() {
        return this.getString(null, this.asJsonNode());
    }

    private String getString(String path, JsonNode node) {
        if (JsonRepresentation.representsNull(node)) {
            return null;
        }
        JsonRepresentation.checkValue(path, node, "a string");
        if (!node.isTextual()) {
            throw new IllegalArgumentException(JsonRepresentation.formatExMsg(path, "is not a string"));
        }
        return node.getTextValue();
    }

    public String asArg() {
        if (this.isValue()) {
            return this.asJsonNode().getValueAsText();
        }
        return this.asJsonNode().toString();
    }

    public boolean isLink() {
        return this.isLink(this.asJsonNode());
    }

    public boolean isLink(String path) {
        return this.isLink(this.getNode(path));
    }

    public boolean isLink(JsonNode node) {
        if (JsonRepresentation.representsNull(node) || this.isArray(node) || node.isValueNode()) {
            return false;
        }
        LinkRepresentation link = new LinkRepresentation(node);
        return link.getHref() != null;
    }

    public LinkRepresentation getLink(String path) {
        return this.getLink(path, this.getNode(path));
    }

    public LinkRepresentation asLink() {
        return this.getLink(null, this.asJsonNode());
    }

    private LinkRepresentation getLink(String path, JsonNode node) {
        if (JsonRepresentation.representsNull(node)) {
            return null;
        }
        if (this.isArray(node)) {
            throw new IllegalArgumentException(JsonRepresentation.formatExMsg(path, "is an array that does not represent a link"));
        }
        if (node.isValueNode()) {
            throw new IllegalArgumentException(JsonRepresentation.formatExMsg(path, "is a value that does not represent a link"));
        }
        LinkRepresentation link = new LinkRepresentation(node);
        if (link.getHref() == null) {
            throw new IllegalArgumentException(JsonRepresentation.formatExMsg(path, "is a map that does not fully represent a link"));
        }
        return link;
    }

    public boolean isNull() {
        return this.isNull(this.asJsonNode());
    }

    public Boolean isNull(String path) {
        return this.isNull(this.getNode(path));
    }

    private Boolean isNull(JsonNode node) {
        if (node == null || node.isMissingNode()) {
            return null;
        }
        return node.isNull();
    }

    public JsonRepresentation getNull(String path) {
        return this.getNull(path, this.getNode(path));
    }

    public JsonRepresentation asNull() {
        return this.getNull(null, this.asJsonNode());
    }

    private JsonRepresentation getNull(String path, JsonNode node) {
        if (node == null || node.isMissingNode()) {
            return null;
        }
        JsonRepresentation.checkValue(path, node, "the null value");
        if (!node.isNull()) {
            throw new IllegalArgumentException(JsonRepresentation.formatExMsg(path, "is not the null value"));
        }
        return new JsonRepresentation(node);
    }

    public LinkRepresentation mapValueAsLink() {
        if (this.asJsonNode().size() != 1) {
            throw new IllegalStateException("does not represent link");
        }
        String linkPropertyName = (String)this.asJsonNode().getFieldNames().next();
        return this.getLink(linkPropertyName);
    }

    public InputStream asInputStream() {
        return JsonNodeUtils.asInputStream(this.jsonNode);
    }

    protected ArrayNode asArrayNode() {
        if (!this.isArray()) {
            throw new IllegalStateException("does not represent array");
        }
        return (ArrayNode)this.asJsonNode();
    }

    protected ObjectNode asObjectNode() {
        if (!this.isMap()) {
            throw new IllegalStateException("does not represent map");
        }
        return (ObjectNode)this.asJsonNode();
    }

    public <T extends JsonRepresentation> T as(Class<T> cls) {
        try {
            Constructor<T> constructor = cls.getConstructor(JsonNode.class);
            return (T)((JsonRepresentation)constructor.newInstance(this.jsonNode));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String asUrlEncoded() {
        return UrlEncodingUtils.urlEncode(this.asJsonNode());
    }

    public void arrayAdd(Object value) {
        if (!this.isArray()) {
            throw new IllegalStateException("does not represent array");
        }
        this.asArrayNode().add((JsonNode)new POJONode(value));
    }

    public void arrayAdd(JsonRepresentation value) {
        if (!this.isArray()) {
            throw new IllegalStateException("does not represent array");
        }
        this.asArrayNode().add(value.asJsonNode());
    }

    public void arrayAdd(String value) {
        if (!this.isArray()) {
            throw new IllegalStateException("does not represent array");
        }
        this.asArrayNode().add(value);
    }

    public void arrayAdd(JsonNode value) {
        if (!this.isArray()) {
            throw new IllegalStateException("does not represent array");
        }
        this.asArrayNode().add(value);
    }

    public void arrayAdd(long value) {
        if (!this.isArray()) {
            throw new IllegalStateException("does not represent array");
        }
        this.asArrayNode().add(value);
    }

    public void arrayAdd(int value) {
        if (!this.isArray()) {
            throw new IllegalStateException("does not represent array");
        }
        this.asArrayNode().add(value);
    }

    public void arrayAdd(double value) {
        if (!this.isArray()) {
            throw new IllegalStateException("does not represent array");
        }
        this.asArrayNode().add(value);
    }

    public void arrayAdd(float value) {
        if (!this.isArray()) {
            throw new IllegalStateException("does not represent array");
        }
        this.asArrayNode().add(value);
    }

    public void arrayAdd(boolean value) {
        if (!this.isArray()) {
            throw new IllegalStateException("does not represent array");
        }
        this.asArrayNode().add(value);
    }

    public Iterable<JsonRepresentation> arrayIterable() {
        return this.arrayIterable(JsonRepresentation.class);
    }

    public <T> Iterable<T> arrayIterable(final Class<T> requiredType) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return JsonRepresentation.this.arrayIterator(requiredType);
            }
        };
    }

    public Iterator<JsonRepresentation> arrayIterator() {
        return this.arrayIterator(JsonRepresentation.class);
    }

    public <T> Iterator<T> arrayIterator(Class<T> requiredType) {
        this.ensureIsAnArrayAtLeastAsLargeAs(0);
        Function<JsonNode, ?> transformer = JsonRepresentation.representationInstantiatorFor(requiredType);
        ArrayNode arrayNode = (ArrayNode)this.jsonNode;
        Iterator iterator = arrayNode.iterator();
        Function<JsonNode, T> typedTransformer = JsonRepresentation.asT(transformer);
        return Iterators.transform((Iterator)iterator, typedTransformer);
    }

    private static <T> Function<JsonNode, T> asT(Function<JsonNode, ?> transformer) {
        return transformer;
    }

    public JsonRepresentation arrayGet(int i) {
        this.ensureIsAnArrayAtLeastAsLargeAs(i + 1);
        return new JsonRepresentation(this.jsonNode.get(i));
    }

    public void arraySetElementAt(int i, JsonRepresentation objectRepr) {
        this.ensureIsAnArrayAtLeastAsLargeAs(i + 1);
        if (objectRepr.isArray()) {
            throw new IllegalArgumentException("Representation being set cannot be an array");
        }
        ArrayNode arrayNode = (ArrayNode)this.jsonNode;
        arrayNode.set(i, objectRepr.asJsonNode());
    }

    private void ensureIsAnArrayAtLeastAsLargeAs(int i) {
        if (!this.jsonNode.isArray()) {
            throw new IllegalStateException("Is not an array");
        }
        if (i > this.size()) {
            throw new IndexOutOfBoundsException("array has only " + this.size() + " elements");
        }
    }

    public boolean mapHas(String key) {
        if (!this.isMap()) {
            throw new IllegalStateException("does not represent map");
        }
        ObjectNode node = this.asObjectNode();
        String[] paths = key.split("\\.");
        for (int i = 0; i < paths.length; ++i) {
            String path = paths[i];
            boolean has = node.has(path);
            if (!has) {
                return false;
            }
            if (i + 1 >= paths.length) continue;
            JsonNode subNode = node.get(path);
            if (!subNode.isObject()) {
                return false;
            }
            node = (ObjectNode)subNode;
        }
        return true;
    }

    public void mapPut(String key, List<Object> value) {
        if (!this.isMap()) {
            throw new IllegalStateException("does not represent map");
        }
        if (value == null) {
            return;
        }
        JsonRepresentation array = JsonRepresentation.newArray();
        for (Object v : value) {
            array.arrayAdd(v);
        }
        this.mapPut(key, array);
    }

    public void mapPut(String key, Object value) {
        if (!this.isMap()) {
            throw new IllegalStateException("does not represent map");
        }
        Path path = Path.parse(key);
        ObjectNode node = JsonNodeUtils.walkNodeUpTo(this.asObjectNode(), path.getHead());
        node.put(path.getTail(), (JsonNode)(value != null ? new POJONode(value) : NullNode.getInstance()));
    }

    public void mapPut(String key, JsonRepresentation value) {
        if (!this.isMap()) {
            throw new IllegalStateException("does not represent map");
        }
        if (value == null) {
            return;
        }
        Path path = Path.parse(key);
        ObjectNode node = JsonNodeUtils.walkNodeUpTo(this.asObjectNode(), path.getHead());
        node.put(path.getTail(), value.asJsonNode());
    }

    public void mapPut(String key, String value) {
        if (!this.isMap()) {
            throw new IllegalStateException("does not represent map");
        }
        if (value == null) {
            return;
        }
        Path path = Path.parse(key);
        ObjectNode node = JsonNodeUtils.walkNodeUpTo(this.asObjectNode(), path.getHead());
        node.put(path.getTail(), value);
    }

    public void mapPut(String key, JsonNode value) {
        if (!this.isMap()) {
            throw new IllegalStateException("does not represent map");
        }
        if (value == null) {
            return;
        }
        Path path = Path.parse(key);
        ObjectNode node = JsonNodeUtils.walkNodeUpTo(this.asObjectNode(), path.getHead());
        node.put(path.getTail(), value);
    }

    public void mapPut(String key, long value) {
        if (!this.isMap()) {
            throw new IllegalStateException("does not represent map");
        }
        Path path = Path.parse(key);
        ObjectNode node = JsonNodeUtils.walkNodeUpTo(this.asObjectNode(), path.getHead());
        node.put(path.getTail(), value);
    }

    public void mapPut(String key, int value) {
        if (!this.isMap()) {
            throw new IllegalStateException("does not represent map");
        }
        Path path = Path.parse(key);
        ObjectNode node = JsonNodeUtils.walkNodeUpTo(this.asObjectNode(), path.getHead());
        node.put(path.getTail(), value);
    }

    public void mapPut(String key, double value) {
        if (!this.isMap()) {
            throw new IllegalStateException("does not represent map");
        }
        Path path = Path.parse(key);
        ObjectNode node = JsonNodeUtils.walkNodeUpTo(this.asObjectNode(), path.getHead());
        node.put(path.getTail(), value);
    }

    public void mapPut(String key, float value) {
        if (!this.isMap()) {
            throw new IllegalStateException("does not represent map");
        }
        Path path = Path.parse(key);
        ObjectNode node = JsonNodeUtils.walkNodeUpTo(this.asObjectNode(), path.getHead());
        node.put(path.getTail(), value);
    }

    public void mapPut(String key, boolean value) {
        if (!this.isMap()) {
            throw new IllegalStateException("does not represent map");
        }
        Path path = Path.parse(key);
        ObjectNode node = JsonNodeUtils.walkNodeUpTo(this.asObjectNode(), path.getHead());
        node.put(path.getTail(), value);
    }

    public Iterable<Map.Entry<String, JsonRepresentation>> mapIterable() {
        this.ensureIsAMap();
        return new Iterable<Map.Entry<String, JsonRepresentation>>(){

            @Override
            public Iterator<Map.Entry<String, JsonRepresentation>> iterator() {
                return JsonRepresentation.this.mapIterator();
            }
        };
    }

    public Iterator<Map.Entry<String, JsonRepresentation>> mapIterator() {
        this.ensureIsAMap();
        return Iterators.transform((Iterator)this.jsonNode.getFields(), MAP_ENTRY_JSON_NODE_TO_JSON_REPRESENTATION);
    }

    private void ensureIsAMap() {
        if (!this.jsonNode.isObject()) {
            throw new IllegalStateException("Is not a map");
        }
    }

    public JsonRepresentation ensureArray() {
        if (this.jsonNode.isArray()) {
            return this;
        }
        JsonRepresentation arrayRepr = JsonRepresentation.newArray();
        arrayRepr.arrayAdd(this.jsonNode);
        return arrayRepr;
    }

    private JsonNode getNode(String path) {
        JsonNode jsonNode = this.jsonNode;
        List<String> keys = PathNode.split(path);
        for (String key : keys) {
            PathNode pathNode = PathNode.parse(key);
            if (!pathNode.getKey().isEmpty()) {
                jsonNode = jsonNode.path(pathNode.getKey());
            }
            if (jsonNode.isNull()) {
                return jsonNode;
            }
            if (!pathNode.hasCriteria()) continue;
            if (!jsonNode.isArray()) {
                return NullNode.getInstance();
            }
            if (!(jsonNode = this.matching(jsonNode, pathNode)).isNull()) continue;
            return jsonNode;
        }
        return jsonNode;
    }

    private JsonNode matching(JsonNode jsonNode, final PathNode pathNode) {
        JsonRepresentation asList = new JsonRepresentation(jsonNode);
        Iterable filtered = Iterables.filter(asList.arrayIterable(JsonNode.class), (Predicate)new Predicate<JsonNode>(){

            public boolean apply(JsonNode input) {
                return pathNode.matches(new JsonRepresentation(input));
            }
        });
        ArrayList matching = Lists.newArrayList((Iterable)filtered);
        return JsonRepresentation.toJsonNode(matching);
    }

    private static JsonNode toJsonNode(List<JsonNode> matching) {
        switch (matching.size()) {
            case 0: {
                return NullNode.getInstance();
            }
            case 1: {
                return matching.get(0);
            }
        }
        ArrayNode arrayNode = new ArrayNode(JsonNodeFactory.instance);
        arrayNode.addAll(matching);
        return arrayNode;
    }

    private static void checkValue(String path, JsonNode node, String requiredType) {
        if (node.isValueNode()) {
            return;
        }
        throw new IllegalArgumentException(JsonRepresentation.formatExMsg(path, "is not " + requiredType));
    }

    private static boolean representsNull(JsonNode node) {
        return node == null || node.isMissingNode() || node.isNull();
    }

    private static String formatExMsg(String pathIfAny, String errorText) {
        StringBuilder buf = new StringBuilder();
        if (pathIfAny != null) {
            buf.append("'").append(pathIfAny).append("' ");
        }
        buf.append(errorText);
        return buf.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.jsonNode == null ? 0 : this.jsonNode.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JsonRepresentation other = (JsonRepresentation)obj;
        return !(this.jsonNode == null ? other.jsonNode != null : !this.jsonNode.equals((Object)other.jsonNode));
    }

    public String toString() {
        return this.jsonNode.toString();
    }

    static {
        REPRESENTATION_INSTANTIATORS.put(String.class, new Function<JsonNode, String>(){

            public String apply(JsonNode input) {
                if (!input.isTextual()) {
                    throw new IllegalStateException("found node that is not a string " + input.toString());
                }
                return input.getTextValue();
            }
        });
        REPRESENTATION_INSTANTIATORS.put(JsonNode.class, new Function<JsonNode, JsonNode>(){

            public JsonNode apply(JsonNode input) {
                return input;
            }
        });
        yyyyMMdd = DateTimeFormat.forPattern((String)"yyyy-MM-dd");
        yyyyMMddTHHmmssZ = DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ssZ");
        MAP_ENTRY_JSON_NODE_TO_JSON_REPRESENTATION = new Function<Map.Entry<String, JsonNode>, Map.Entry<String, JsonRepresentation>>(){

            public Map.Entry<String, JsonRepresentation> apply(final Map.Entry<String, JsonNode> input) {
                return new Map.Entry<String, JsonRepresentation>(){

                    @Override
                    public String getKey() {
                        return (String)input.getKey();
                    }

                    @Override
                    public JsonRepresentation getValue() {
                        return new JsonRepresentation((JsonNode)input.getValue());
                    }

                    @Override
                    public JsonRepresentation setValue(JsonRepresentation value) {
                        JsonNode setValue = input.setValue(value.asJsonNode());
                        return new JsonRepresentation(setValue);
                    }
                };
            }
        };
    }

    private static class Path {
        private final List<String> head;
        private final String tail;

        private Path(List<String> head, String tail) {
            this.head = Collections.unmodifiableList(head);
            this.tail = tail;
        }

        public List<String> getHead() {
            return this.head;
        }

        public String getTail() {
            return this.tail;
        }

        public static Path parse(String pathStr) {
            ArrayList keyList = Lists.newArrayList(Arrays.asList(pathStr.split("\\.")));
            if (keyList.size() == 0) {
                throw new IllegalArgumentException(String.format("Malformed path '%s'", pathStr));
            }
            String tail = (String)keyList.remove(keyList.size() - 1);
            return new Path(keyList, tail);
        }
    }

    public static interface HasExtensions {
        public JsonRepresentation getExtensions();
    }

    public static interface HasLinks {
        public JsonRepresentation getLinks();
    }

    public static interface HasLinkToUp {
        public LinkRepresentation getUp();
    }

    public static interface HasLinkToSelf {
        public LinkRepresentation getSelf();
    }
}

