/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.domainobjects;

import java.io.InputStream;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.annotations.ClientResponseType;

@Path(value="/services")
public interface DomainServiceResource {
    @GET
    @Path(value="/")
    @Produces(value={"application/json", "application/json;profile=urn:org.restfulobjects/list", "application/json;profile=urn:org.restfulobjects/error"})
    @ClientResponseType(entityType=String.class)
    public Response services();

    @GET
    @Path(value="/{serviceId}")
    @Produces(value={"application/json", "application/json;profile=urn:org.restfulobjects/domainobject", "application/json;profile=urn:org.restfulobjects/error"})
    @ClientResponseType(entityType=String.class)
    public Response service(@PathParam(value="serviceId") String var1);

    @GET
    @Path(value="/{serviceId}/properties/{propertyId}")
    @Produces(value={"application/json", "application/json;profile=urn:org.restfulobjects/objectproperty", "application/json;profile=urn:org.restfulobjects/error"})
    public Response propertyDetails(@PathParam(value="serviceId") String var1, @PathParam(value="propertyId") String var2);

    @GET
    @Path(value="/{serviceId}/actions/{actionId}")
    @Produces(value={"application/json", "application/json;profile=urn:org.restfulobjects/objectaction", "application/json;profile=urn:org.restfulobjects/error"})
    @ClientResponseType(entityType=String.class)
    public Response actionPrompt(@PathParam(value="serviceId") String var1, @PathParam(value="actionId") String var2);

    @GET
    @Path(value="/{serviceId}/actions/{actionId}/invoke")
    @Produces(value={"application/json", "application/json;profile=urn:org.restfulobjects/actionresult", "application/json;profile=urn:org.restfulobjects/error"})
    @ClientResponseType(entityType=String.class)
    public Response invokeActionQueryOnly(@PathParam(value="serviceId") String var1, @PathParam(value="actionId") String var2);

    @PUT
    @Path(value="/{serviceId}/actions/{actionId}/invoke")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json", "application/json;profile=urn:org.restfulobjects/actionresult", "application/json;profile=urn:org.restfulobjects/error"})
    @ClientResponseType(entityType=String.class)
    public Response invokeActionIdempotent(@PathParam(value="serviceId") String var1, @PathParam(value="actionId") String var2, InputStream var3);

    @POST
    @Path(value="/{serviceId}/actions/{actionId}/invoke")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json", "application/json;profile=urn:org.restfulobjects/actionresult", "application/json;profile=urn:org.restfulobjects/error"})
    @ClientResponseType(entityType=String.class)
    public Response invokeAction(@PathParam(value="serviceId") String var1, @PathParam(value="actionId") String var2, InputStream var3);
}

