/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.domainobjects;

import java.io.InputStream;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.annotations.ClientResponseType;

@Path(value="/objects")
public interface DomainObjectResource {
    @POST
    @Path(value="/")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json", "application/json;profile=urn:org.restfulobjects/domainobject", "application/json;profile=urn:org.restfulobjects/error"})
    @ClientResponseType(entityType=String.class)
    public Response persist(InputStream var1);

    @GET
    @Path(value="/{oid}")
    @Produces(value={"application/json", "application/json;profile=urn:org.restfulobjects/domainobject", "application/json;profile=urn:org.restfulobjects/error"})
    @ClientResponseType(entityType=String.class)
    public Response object(@PathParam(value="oid") String var1);

    @PUT
    @Path(value="/{oid}")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json;profile=urn:org.restfulobjects/domainobject", "application/json;profile=urn:org.restfulobjects/error"})
    @ClientResponseType(entityType=String.class)
    public Response object(@PathParam(value="oid") String var1, InputStream var2);

    @GET
    @Path(value="/{oid}/properties/{propertyId}")
    @Produces(value={"application/json", "application/json;profile=urn:org.restfulobjects/objectproperty", "application/json;profile=urn:org.restfulobjects/error"})
    @ClientResponseType(entityType=String.class)
    public Response propertyDetails(@PathParam(value="oid") String var1, @PathParam(value="propertyId") String var2);

    @PUT
    @Path(value="/{oid}/properties/{propertyId}")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json", "application/json;profile=urn:org.restfulobjects/error"})
    @ClientResponseType(entityType=String.class)
    public Response modifyProperty(@PathParam(value="oid") String var1, @PathParam(value="propertyId") String var2, InputStream var3);

    @DELETE
    @Path(value="/{oid}/properties/{propertyId}")
    @Produces(value={"application/json", "application/json;profile=urn:org.restfulobjects/error"})
    @ClientResponseType(entityType=String.class)
    public Response clearProperty(@PathParam(value="oid") String var1, @PathParam(value="propertyId") String var2);

    @GET
    @Path(value="/{oid}/collections/{collectionId}")
    @Produces(value={"application/json", "application/json;profile=urn:org.restfulobjects/objectcollection", "application/json;profile=urn:org.restfulobjects/error"})
    @ClientResponseType(entityType=String.class)
    public Response accessCollection(@PathParam(value="oid") String var1, @PathParam(value="collectionId") String var2);

    @PUT
    @Path(value="/{oid}/collections/{collectionId}")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json", "application/json;profile=urn:org.restfulobjects/error"})
    public Response addToSet(@PathParam(value="oid") String var1, @PathParam(value="collectionId") String var2, InputStream var3);

    @POST
    @Path(value="/{oid}/collections/{collectionId}")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json", "application/json;profile=urn:org.restfulobjects/error"})
    @ClientResponseType(entityType=String.class)
    public Response addToList(@PathParam(value="oid") String var1, @PathParam(value="collectionId") String var2, InputStream var3);

    @DELETE
    @Path(value="/{oid}/collections/{collectionId}")
    @Produces(value={"application/json", "application/json;profile=urn:org.restfulobjects/error"})
    @ClientResponseType(entityType=String.class)
    public Response removeFromCollection(@PathParam(value="oid") String var1, @PathParam(value="collectionId") String var2);

    @GET
    @Path(value="/{oid}/actions/{actionId}")
    @Produces(value={"application/json", "application/json;profile=urn:org.restfulobjects/objectaction", "application/json;profile=urn:org.restfulobjects/error"})
    @ClientResponseType(entityType=String.class)
    public Response actionPrompt(@PathParam(value="oid") String var1, @PathParam(value="actionId") String var2);

    @GET
    @Path(value="/{oid}/actions/{actionId}/invoke")
    @Produces(value={"application/json", "application/json;profile=urn:org.restfulobjects/actionresult", "application/json;profile=urn:org.restfulobjects/error"})
    @ClientResponseType(entityType=String.class)
    public Response invokeActionQueryOnly(@PathParam(value="oid") String var1, @PathParam(value="actionId") String var2);

    @PUT
    @Path(value="/{oid}/actions/{actionId}/invoke")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json", "application/json;profile=urn:org.restfulobjects/actionresult", "application/json;profile=urn:org.restfulobjects/scalarvalue", "application/json;profile=urn:org.restfulobjects/error"})
    @ClientResponseType(entityType=String.class)
    public Response invokeActionIdempotent(@PathParam(value="oid") String var1, @PathParam(value="actionId") String var2, InputStream var3);

    @POST
    @Path(value="/{oid}/actions/{actionId}/invoke")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json", "application/json;profile=urn:org.restfulobjects/actionresult", "application/json;profile=urn:org.restfulobjects/error"})
    @ClientResponseType(entityType=String.class)
    public Response invokeAction(@PathParam(value="oid") String var1, @PathParam(value="actionId") String var2, InputStream var3);
}

