/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.applib;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Date;
import java.util.Map;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.isis.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.RepresentationType;
import org.apache.isis.viewer.restfulobjects.applib.util.JsonMapper;
import org.apache.isis.viewer.restfulobjects.applib.util.Parser;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.JsonMappingException;

public class RestfulResponse<T> {
    private final Response response;
    private final HttpStatusCode httpStatusCode;
    private final Class<T> returnType;

    public static RestfulResponse<JsonRepresentation> of(Response response) {
        MediaType mediaType = RestfulResponse.getHeader(response, Header.CONTENT_TYPE);
        RepresentationType representationType = RepresentationType.lookup(mediaType);
        Class<? extends JsonRepresentation> returnType = representationType.getRepresentationClass();
        return new RestfulResponse<JsonRepresentation>(response, returnType);
    }

    public static <T extends JsonRepresentation> RestfulResponse<T> ofT(Response response) {
        return RestfulResponse.of(response);
    }

    private RestfulResponse(Response response, Class<T> returnType) {
        this.response = response;
        this.httpStatusCode = HttpStatusCode.statusFor(response.getStatus());
        this.returnType = returnType;
    }

    public HttpStatusCode getStatus() {
        return this.httpStatusCode;
    }

    public T getEntity() throws JsonParseException, JsonMappingException, IOException {
        return JsonMapper.instance().read(this.response, this.returnType);
    }

    public <V> V getHeader(Header<V> header) {
        return RestfulResponse.getHeader(this.response, header);
    }

    private static <V> V getHeader(Response response, Header<V> header) {
        MultivaluedMap metadata = response.getMetadata();
        String value = (String)metadata.getFirst((Object)header.getName());
        return header.parse(value);
    }

    public static class Header<X> {
        public static final Header<String> WARNING = new Header<String>("Warning", Parser.forString());
        public static final Header<Date> LAST_MODIFIED = new Header<Date>("Last-Modified", Parser.forDate());
        public static final Header<CacheControl> CACHE_CONTROL = new Header<CacheControl>("Cache-Control", Parser.forCacheControl());
        public static final Header<MediaType> CONTENT_TYPE = new Header<MediaType>("Content-Type", Parser.forMediaType());
        private final String name;
        private final Parser<X> parser;

        private Header(String name, Parser<X> parser) {
            this.name = name;
            this.parser = parser;
        }

        public String getName() {
            return this.name;
        }

        public X parse(String value) {
            return this.parser.valueOf(value);
        }
    }

    public static final class HttpStatusCode {
        private static final Map<Response.Status, HttpStatusCode> statii = Maps.newHashMap();
        private static final Map<Integer, HttpStatusCode> statusCodes = Maps.newHashMap();
        public static final HttpStatusCode OK = new HttpStatusCode(200, (Response.StatusType)Response.Status.OK);
        public static final HttpStatusCode CREATED = new HttpStatusCode(201, (Response.StatusType)Response.Status.CREATED);
        public static final HttpStatusCode NO_CONTENT = new HttpStatusCode(204, (Response.StatusType)Response.Status.NO_CONTENT);
        public static final HttpStatusCode NOT_MODIFIED = new HttpStatusCode(304, (Response.StatusType)Response.Status.BAD_REQUEST);
        public static final HttpStatusCode BAD_REQUEST = new HttpStatusCode(400, (Response.StatusType)Response.Status.BAD_REQUEST);
        public static final HttpStatusCode UNAUTHORIZED = new HttpStatusCode(401, (Response.StatusType)Response.Status.UNAUTHORIZED);
        public static final HttpStatusCode NOT_FOUND = new HttpStatusCode(404, (Response.StatusType)Response.Status.NOT_FOUND);
        public static final HttpStatusCode METHOD_NOT_ALLOWED = new HttpStatusCode(405, new StatusTypeImpl(405, Response.Status.Family.CLIENT_ERROR, "Method not allowed"));
        public static final HttpStatusCode NOT_ACCEPTABLE = new HttpStatusCode(406, (Response.StatusType)Response.Status.NOT_ACCEPTABLE);
        public static final HttpStatusCode CONFLICT = new HttpStatusCode(409, (Response.StatusType)Response.Status.CONFLICT);
        public static final HttpStatusCode UNSUPPORTED_MEDIA_TYPE = new HttpStatusCode(415, (Response.StatusType)Response.Status.UNSUPPORTED_MEDIA_TYPE);
        public static final HttpStatusCode METHOD_FAILURE = new HttpStatusCode(420, new StatusTypeImpl(420, Response.Status.Family.CLIENT_ERROR, "Method failure"));
        public static final HttpStatusCode INTERNAL_SERVER_ERROR = new HttpStatusCode(500, (Response.StatusType)Response.Status.INTERNAL_SERVER_ERROR);
        public static final HttpStatusCode NOT_IMPLEMENTED = new HttpStatusCode(501, new StatusTypeImpl(501, Response.Status.Family.SERVER_ERROR, "Not implemented"));
        private final int statusCode;
        private final Response.Status.Family family;
        private final Response.StatusType jaxrsStatusType;

        public static HttpStatusCode lookup(int status) {
            return statusCodes.get(status);
        }

        public static Response.Status.Family lookupFamily(int statusCode) {
            switch (statusCode / 100) {
                case 1: {
                    return Response.Status.Family.INFORMATIONAL;
                }
                case 2: {
                    return Response.Status.Family.SUCCESSFUL;
                }
                case 3: {
                    return Response.Status.Family.REDIRECTION;
                }
                case 4: {
                    return Response.Status.Family.CLIENT_ERROR;
                }
                case 5: {
                    return Response.Status.Family.SERVER_ERROR;
                }
            }
            return Response.Status.Family.OTHER;
        }

        public static final HttpStatusCode statusFor(int statusCode) {
            HttpStatusCode httpStatusCode = statusCodes.get(statusCode);
            if (httpStatusCode != null) {
                return httpStatusCode;
            }
            return HttpStatusCode.syncStatusFor(statusCode);
        }

        public static final HttpStatusCode statusFor(Response.Status status) {
            return statii.get(status);
        }

        private static final synchronized HttpStatusCode syncStatusFor(int statusCode) {
            HttpStatusCode httpStatusCode = statusCodes.get(statusCode);
            if (httpStatusCode == null) {
                httpStatusCode = new HttpStatusCode(statusCode, null);
                statusCodes.put(statusCode, httpStatusCode);
            }
            return httpStatusCode;
        }

        private HttpStatusCode(int statusCode, Response.StatusType status) {
            this.statusCode = statusCode;
            this.jaxrsStatusType = status;
            this.family = HttpStatusCode.lookupFamily(statusCode);
            statusCodes.put(statusCode, this);
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public Response.StatusType getJaxrsStatusType() {
            return this.jaxrsStatusType;
        }

        public Response.Status.Family getFamily() {
            return this.family;
        }

        public int hashCode() {
            return this.statusCode;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            HttpStatusCode other = (HttpStatusCode)obj;
            return this.statusCode == other.statusCode;
        }

        public String toString() {
            return "HttpStatusCode " + this.statusCode + ", " + this.family;
        }

        private static class StatusTypeImpl
        implements Response.StatusType {
            private final int statusCode;
            private final Response.Status.Family family;
            private final String reasonPhrase;

            private StatusTypeImpl(int statusCode, Response.Status.Family family, String reasonPhrase) {
                this.statusCode = statusCode;
                this.family = family;
                this.reasonPhrase = reasonPhrase;
            }

            public int getStatusCode() {
                return this.statusCode;
            }

            public Response.Status.Family getFamily() {
                return this.family;
            }

            public String getReasonPhrase() {
                return this.reasonPhrase;
            }
        }
    }
}

