/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.applib;

import javax.ws.rs.core.MediaType;
import org.apache.isis.applib.util.Enums;
import org.apache.isis.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.domaintypes.ActionDescriptionRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.domaintypes.ActionParameterDescriptionRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.domaintypes.CollectionDescriptionRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.domaintypes.DomainTypeRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.domaintypes.PropertyDescriptionRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.domaintypes.TypeActionResultRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.domaintypes.TypeListRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.errors.ErrorRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.homepage.HomePageRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.user.UserRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.util.Parser;
import org.apache.isis.viewer.restfulobjects.applib.version.VersionRepresentation;
import org.apache.isis.viewer.restfulobjects.domainobjects.ActionResultRepresentation;
import org.apache.isis.viewer.restfulobjects.domainobjects.DomainObjectRepresentation;
import org.apache.isis.viewer.restfulobjects.domainobjects.ListRepresentation;
import org.apache.isis.viewer.restfulobjects.domainobjects.ObjectActionRepresentation;
import org.apache.isis.viewer.restfulobjects.domainobjects.ObjectCollectionRepresentation;
import org.apache.isis.viewer.restfulobjects.domainobjects.ObjectPropertyRepresentation;
import org.apache.isis.viewer.restfulobjects.domainobjects.ScalarValueRepresentation;
import org.apache.isis.viewer.restfulobjects.domainobjects.TransientDomainObjectRepresentation;

public enum RepresentationType {
    HOME_PAGE("application/json;profile=urn:org.restfulobjects/homepage", HomePageRepresentation.class),
    USER("application/json;profile=urn:org.restfulobjects/user", UserRepresentation.class),
    VERSION("application/json;profile=urn:org.restfulobjects/version", VersionRepresentation.class),
    LIST("application/json;profile=urn:org.restfulobjects/list", ListRepresentation.class),
    SCALAR_VALUE("application/json;profile=urn:org.restfulobjects/scalarvalue", ScalarValueRepresentation.class),
    DOMAIN_OBJECT("application/json;profile=urn:org.restfulobjects/domainobject", DomainObjectRepresentation.class),
    TRANSIENT_DOMAIN_OBJECT("application/json;profile=urn:org.restfulobjects/transient", TransientDomainObjectRepresentation.class),
    OBJECT_PROPERTY("application/json;profile=urn:org.restfulobjects/objectproperty", ObjectPropertyRepresentation.class),
    OBJECT_COLLECTION("application/json;profile=urn:org.restfulobjects/objectcollection", ObjectCollectionRepresentation.class),
    OBJECT_ACTION("application/json;profile=urn:org.restfulobjects/objectaction", ObjectActionRepresentation.class),
    ACTION_RESULT("application/json;profile=urn:org.restfulobjects/actionresult", ActionResultRepresentation.class),
    TYPE_LIST("application/json;profile=urn:org.restfulobjects/typelist", TypeListRepresentation.class),
    DOMAIN_TYPE("application/json;profile=urn:org.restfulobjects/domaintype", DomainTypeRepresentation.class),
    PROPERTY_DESCRIPTION("application/json;profile=urn:org.restfulobjects/propertydescription", PropertyDescriptionRepresentation.class),
    COLLECTION_DESCRIPTION("application/json;profile=urn:org.restfulobjects/collectiondescription", CollectionDescriptionRepresentation.class),
    ACTION_DESCRIPTION("application/json;profile=urn:org.restfulobjects/actiondescription", ActionDescriptionRepresentation.class),
    ACTION_PARAMETER_DESCRIPTION("application/json;profile=urn:org.restfulobjects/actionparameterdescription", ActionParameterDescriptionRepresentation.class),
    TYPE_ACTION_RESULT("application/json;profile=urn:org.restfulobjects/typeactionresult", TypeActionResultRepresentation.class),
    ERROR("application/json;profile=urn:org.restfulobjects/error", ErrorRepresentation.class),
    GENERIC("application/json", JsonRepresentation.class);

    private final String name;
    private final MediaType mediaType;
    private final Class<? extends JsonRepresentation> representationClass;

    private RepresentationType(String mediaTypeStr, Class<? extends JsonRepresentation> representationClass) {
        this.representationClass = representationClass;
        this.name = Enums.enumToCamelCase((Enum)this);
        this.mediaType = MediaType.valueOf((String)mediaTypeStr);
    }

    public String getName() {
        return this.name;
    }

    public final MediaType getMediaType() {
        return this.mediaType;
    }

    public String getMediaTypeWithProfile() {
        return (String)this.getMediaType().getParameters().get("profile");
    }

    public Class<? extends JsonRepresentation> getRepresentationClass() {
        return this.representationClass;
    }

    public static RepresentationType lookup(String name) {
        for (RepresentationType representationType : RepresentationType.values()) {
            if (!representationType.getName().equals(name)) continue;
            return representationType;
        }
        return GENERIC;
    }

    public static RepresentationType lookup(MediaType mediaType) {
        for (RepresentationType representationType : RepresentationType.values()) {
            if (!representationType.getMediaType().equals((Object)mediaType)) continue;
            return representationType;
        }
        return GENERIC;
    }

    public static Parser<RepresentationType> parser() {
        return new Parser<RepresentationType>(){

            @Override
            public RepresentationType valueOf(String str) {
                return RepresentationType.lookup(str);
            }

            @Override
            public String asString(RepresentationType t) {
                return t.getName();
            }
        };
    }
}

