/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.applib;

import org.apache.isis.viewer.restfulobjects.applib.ClientRequestConfigurer;
import org.apache.isis.viewer.restfulobjects.applib.JsonRepresentation;

public enum HttpMethod {
    GET("GET", ArgStrategy.QUERY_STRING),
    PUT("PUT", ArgStrategy.BODY),
    DELETE("DELETE", ArgStrategy.QUERY_STRING),
    POST("POST", ArgStrategy.BODY);

    private final String javaxRsMethod;
    private final ArgStrategy argStrategy;

    private HttpMethod(String javaxRsMethod, ArgStrategy argStrategy) {
        this.javaxRsMethod = javaxRsMethod;
        this.argStrategy = argStrategy;
    }

    public String getJavaxRsMethod() {
        return this.javaxRsMethod;
    }

    public void setUpArgs(ClientRequestConfigurer clientRequestConfigurer, JsonRepresentation requestArgs) {
        clientRequestConfigurer.setHttpMethod(this);
        if (requestArgs == null) {
            return;
        }
        if (!requestArgs.isMap()) {
            throw new IllegalArgumentException("requestArgs must be a map; instead got: " + requestArgs);
        }
        this.argStrategy.setUpArgs(clientRequestConfigurer, requestArgs);
    }

    private static enum ArgStrategy {
        QUERY_ARGS{

            @Override
            void setUpArgs(ClientRequestConfigurer clientRequestConfigurer, JsonRepresentation requestArgs) {
                clientRequestConfigurer.queryArgs(requestArgs);
            }
        }
        ,
        QUERY_STRING{

            @Override
            void setUpArgs(ClientRequestConfigurer clientRequestConfigurer, JsonRepresentation requestArgs) {
                clientRequestConfigurer.queryString(requestArgs);
            }
        }
        ,
        BODY{

            @Override
            void setUpArgs(ClientRequestConfigurer clientRequestConfigurer, JsonRepresentation requestArgs) {
                clientRequestConfigurer.body(requestArgs);
            }
        };


        abstract void setUpArgs(ClientRequestConfigurer var1, JsonRepresentation var2);
    }
}

