/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.objectstore.jdo.applib.service.settings;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.List;
import org.apache.isis.applib.AbstractService;
import org.apache.isis.applib.annotation.MemberOrder;
import org.apache.isis.applib.annotation.Named;
import org.apache.isis.applib.annotation.Optional;
import org.apache.isis.applib.query.Query;
import org.apache.isis.applib.query.QueryDefault;
import org.apache.isis.applib.services.settings.SettingAbstract;
import org.apache.isis.applib.services.settings.SettingType;
import org.apache.isis.applib.services.settings.UserSetting;
import org.apache.isis.applib.services.settings.UserSettingsServiceRW;
import org.apache.isis.objectstore.jdo.applib.service.settings.UserSettingJdo;
import org.joda.time.LocalDate;

@Named(value="User Settings")
public class UserSettingsServiceJdo
extends AbstractService
implements UserSettingsServiceRW {
    private static final Function<UserSetting, String> GET_USER = new Function<UserSetting, String>(){

        public String apply(UserSetting input) {
            return input.getUser();
        }
    };

    public UserSetting find(@Named(value="User") String user, @Named(value="Key") String key) {
        return (UserSetting)this.firstMatch((Query)new QueryDefault(UserSettingJdo.class, "findByUserAndKey", new Object[]{"user", user, "key", key}));
    }

    public List<UserSetting> listAllFor(String user) {
        return this.allMatches((Query)new QueryDefault(UserSettingJdo.class, "findByUser", new Object[]{"user", user}));
    }

    public List<String> choices0ListAllFor() {
        return this.existingUsers();
    }

    private List<String> existingUsers() {
        List<UserSetting> listAll = this.listAll();
        return Lists.newArrayList((Iterable)Sets.newTreeSet((Iterable)Iterables.transform(listAll, GET_USER)));
    }

    public List<UserSetting> listAll() {
        return this.allMatches((Query)new QueryDefault(UserSettingJdo.class, "findAll", new Object[0]));
    }

    @MemberOrder(sequence="10")
    public UserSettingJdo newString(@Named(value="User") String user, @Named(value="Key") String key, @Named(value="Description") @Optional String description, @Named(value="Value") String value) {
        return this.newSetting(user, key, description, SettingType.STRING, value);
    }

    public String default0NewString() {
        return this.getContainer().getUser().getName();
    }

    @MemberOrder(sequence="11")
    public UserSettingJdo newInt(@Named(value="User") String user, @Named(value="Key") String key, @Named(value="Description") @Optional String description, @Named(value="Value") Integer value) {
        return this.newSetting(user, key, description, SettingType.INT, value.toString());
    }

    public String default0NewInt() {
        return this.getContainer().getUser().getName();
    }

    @MemberOrder(sequence="12")
    public UserSettingJdo newLong(@Named(value="User") String user, @Named(value="Key") String key, @Named(value="Description") @Optional String description, @Named(value="Value") Long value) {
        return this.newSetting(user, key, description, SettingType.LONG, value.toString());
    }

    public String default0NewLong() {
        return this.getContainer().getUser().getName();
    }

    @MemberOrder(sequence="13")
    public UserSettingJdo newLocalDate(@Named(value="User") String user, @Named(value="Key") String key, @Named(value="Description") @Optional String description, @Named(value="Value") LocalDate value) {
        return this.newSetting(user, key, description, SettingType.LOCAL_DATE, value.toString(SettingAbstract.DATE_FORMATTER));
    }

    public String default0NewLocalDate() {
        return this.getContainer().getUser().getName();
    }

    @MemberOrder(sequence="14")
    public UserSettingJdo newBoolean(@Named(value="User") String user, @Named(value="Key") String key, @Named(value="Description") @Optional String description, @Named(value="Value") @Optional Boolean value) {
        return this.newSetting(user, key, description, SettingType.BOOLEAN, new Boolean(value != null && value != false).toString());
    }

    public String default0NewBoolean() {
        return this.getContainer().getUser().getName();
    }

    private UserSettingJdo newSetting(String user, String key, String description, SettingType settingType, String valueRaw) {
        UserSettingJdo setting = (UserSettingJdo)((Object)this.newTransientInstance(UserSettingJdo.class));
        setting.setUser(user);
        setting.setKey(key);
        setting.setType(settingType);
        setting.setDescription(description);
        setting.setValueRaw(valueRaw);
        this.persist((Object)setting);
        return setting;
    }
}

