/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.objectstore.jdo.applib.service.settings;

import javax.jdo.annotations.Column;
import org.apache.isis.applib.DomainObjectContainer;
import org.apache.isis.applib.annotation.MemberOrder;
import org.apache.isis.applib.annotation.Named;
import org.apache.isis.applib.annotation.Optional;
import org.apache.isis.applib.services.settings.ApplicationSetting;
import org.apache.isis.applib.services.settings.SettingAbstract;
import org.apache.isis.applib.services.settings.SettingType;
import org.joda.time.LocalDate;

public abstract class SettingAbstractJdo
extends SettingAbstract
implements ApplicationSetting {
    private String key;
    private String description;
    private SettingType type;
    private String valueRaw;
    private DomainObjectContainer container;

    @Column(allowsNull="false")
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @MemberOrder(name="Description", sequence="1")
    @Named(value="Update")
    public SettingAbstractJdo updateDescription(@Named(value="Description") @Optional String description) {
        this.setDescription(description);
        return this;
    }

    public String default0UpdateDescription() {
        return this.getDescription();
    }

    @Column(allowsNull="false")
    public SettingType getType() {
        return this.type;
    }

    public void setType(SettingType type) {
        this.type = type;
    }

    @Column(allowsNull="false")
    public String getValueRaw() {
        return this.valueRaw;
    }

    public void setValueRaw(String valueAsRaw) {
        this.valueRaw = valueAsRaw;
    }

    @MemberOrder(name="ValueAsString", sequence="1")
    @Named(value="Update")
    public SettingAbstractJdo updateAsString(@Named(value="Value") String value) {
        this.setValueRaw(value);
        return this;
    }

    public String default0UpdateAsString() {
        return this.getValueAsString();
    }

    public boolean hideUpdateAsString() {
        return this.typeIsNot(SettingType.STRING);
    }

    @MemberOrder(name="ValueAsInt", sequence="1")
    @Named(value="Update")
    public SettingAbstractJdo updateAsInt(@Named(value="Value") Integer value) {
        this.setValueRaw(value.toString());
        return this;
    }

    public Integer default0UpdateAsInt() {
        return this.getValueAsInt();
    }

    public boolean hideUpdateAsInt() {
        return this.typeIsNot(SettingType.INT);
    }

    @MemberOrder(name="ValueAsLong", sequence="1")
    @Named(value="Update")
    public SettingAbstractJdo updateAsLong(@Named(value="Value") Long value) {
        this.setValueRaw(value.toString());
        return this;
    }

    public Long default0UpdateAsLong() {
        return this.getValueAsLong();
    }

    public boolean hideUpdateAsLong() {
        return this.typeIsNot(SettingType.LONG);
    }

    @MemberOrder(name="ValueAsLocalDate", sequence="1")
    @Named(value="Update")
    public SettingAbstractJdo updateAsLocalDate(@Named(value="Value") LocalDate value) {
        this.setValueRaw(value.toString(DATE_FORMATTER));
        return this;
    }

    public LocalDate default0UpdateAsLocalDate() {
        return this.getValueAsLocalDate();
    }

    public boolean hideUpdateAsLocalDate() {
        return this.typeIsNot(SettingType.LOCAL_DATE);
    }

    @MemberOrder(name="ValueAsBoolean", sequence="1")
    @Named(value="Update")
    public SettingAbstractJdo updateAsBoolean(@Named(value="Value") Boolean value) {
        this.setValueRaw(value.toString());
        return this;
    }

    public Boolean default0UpdateAsBoolean() {
        return this.getValueAsBoolean();
    }

    public boolean hideUpdateAsBoolean() {
        return this.typeIsNot(SettingType.BOOLEAN);
    }

    public SettingAbstractJdo delete(@Named(value="Are you sure?") @Optional Boolean confirm) {
        if (confirm == null || !confirm.booleanValue()) {
            this.container.informUser("Setting NOT deleted");
            return this;
        }
        this.container.remove((Object)this);
        this.container.informUser("Setting deleted");
        return null;
    }

    public void setDomainObjectContainer(DomainObjectContainer container) {
        this.container = container;
    }
}

