/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.services.devutils;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.isis.applib.util.ObjectContracts;
import org.apache.isis.core.commons.lang.StringExtensions;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facets.ImperativeFacet;
import org.apache.isis.core.metamodel.facets.actions.defaults.ActionDefaultsFacet;
import org.apache.isis.core.metamodel.facets.actions.validate.ActionValidationFacet;
import org.apache.isis.core.metamodel.facets.all.hide.HiddenFacet;
import org.apache.isis.core.metamodel.facets.collections.validate.CollectionValidateAddToFacet;
import org.apache.isis.core.metamodel.facets.collections.validate.CollectionValidateRemoveFromFacet;
import org.apache.isis.core.metamodel.facets.members.disabled.DisabledFacet;
import org.apache.isis.core.metamodel.facets.param.autocomplete.ActionParameterAutoCompleteFacet;
import org.apache.isis.core.metamodel.facets.param.choices.ActionChoicesFacet;
import org.apache.isis.core.metamodel.facets.param.choices.ActionParameterChoicesFacet;
import org.apache.isis.core.metamodel.facets.param.defaults.ActionParameterDefaultsFacet;
import org.apache.isis.core.metamodel.facets.properties.autocomplete.PropertyAutoCompleteFacet;
import org.apache.isis.core.metamodel.facets.properties.choices.PropertyChoicesFacet;
import org.apache.isis.core.metamodel.facets.properties.defaults.PropertyDefaultFacet;
import org.apache.isis.core.metamodel.facets.properties.validating.PropertyValidateFacet;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.metamodel.spec.feature.ObjectActionParameter;
import org.apache.isis.core.metamodel.spec.feature.ObjectMember;
import org.apache.isis.core.metamodel.spec.feature.OneToManyAssociation;
import org.apache.isis.core.metamodel.spec.feature.OneToOneAssociation;

public class MetaModelRow
implements Comparable<MetaModelRow> {
    private final ObjectSpecification spec;
    private final MemberType memberType;
    private final ObjectMember member;
    private ObjectAction action;

    MetaModelRow(ObjectSpecification spec, OneToOneAssociation property) {
        this.spec = spec;
        this.member = property;
        this.memberType = MemberType.PROPERTY;
    }

    MetaModelRow(ObjectSpecification spec, OneToManyAssociation collection) {
        this.spec = spec;
        this.member = collection;
        this.memberType = MemberType.COLLECTION;
    }

    MetaModelRow(ObjectSpecification spec, ObjectAction action) {
        this.spec = spec;
        this.action = action;
        this.member = this.action;
        this.memberType = MemberType.ACTION;
    }

    public String getClassType() {
        boolean service = false;
        for (ObjectSpecification subspecs : this.spec.subclasses()) {
            service = service || subspecs.isService();
        }
        return service || this.spec.isService() ? "2 Service" : (this.spec.isValue() ? "3 Value" : (this.spec.isParentedOrFreeCollection() ? "4 Collection" : "1 Object"));
    }

    public String getClassName() {
        String fullIdentifier = this.spec.getFullIdentifier();
        int lastDot = fullIdentifier.lastIndexOf(".");
        return lastDot > 0 && lastDot < fullIdentifier.length() - 1 ? fullIdentifier.substring(lastDot + 1, fullIdentifier.length()) : fullIdentifier;
    }

    public String getPackageName() {
        String fullIdentifier = this.spec.getFullIdentifier();
        int lastDot = fullIdentifier.lastIndexOf(".");
        return lastDot > 0 ? fullIdentifier.substring(0, lastDot) : fullIdentifier;
    }

    public String getType() {
        return this.memberType.name().toLowerCase();
    }

    public String getMemberName() {
        return this.member.getId();
    }

    public String getNumParams() {
        return this.action != null ? "" + this.action.getParameterCount() : "";
    }

    String getHidden() {
        return this.interpret(HiddenFacet.class);
    }

    String getDisabled() {
        return this.interpret(DisabledFacet.class);
    }

    public String getChoices() {
        if (this.memberType == MemberType.PROPERTY) {
            return this.interpretRowAndFacet(PropertyChoicesFacet.class);
        }
        if (this.memberType == MemberType.COLLECTION) {
            return "";
        }
        List parameters = this.action.getParameters();
        TreeSet interpretations = Sets.newTreeSet();
        for (ObjectActionParameter param : parameters) {
            ActionParameterChoicesFacet facet = (ActionParameterChoicesFacet)param.getFacet(ActionParameterChoicesFacet.class);
            MetaModelRow.addIfNotEmpty(MetaModelRow.interpretFacet((Facet)facet), interpretations);
        }
        return !interpretations.isEmpty() ? Joiner.on((String)";").join((Iterable)interpretations) : this.interpretRowAndFacet(ActionChoicesFacet.class);
    }

    public String getAutoComplete() {
        if (this.memberType == MemberType.PROPERTY) {
            return this.interpretRowAndFacet(PropertyAutoCompleteFacet.class);
        }
        if (this.memberType == MemberType.COLLECTION) {
            return "";
        }
        List parameters = this.action.getParameters();
        TreeSet interpretations = Sets.newTreeSet();
        for (ObjectActionParameter param : parameters) {
            ActionParameterAutoCompleteFacet facet = (ActionParameterAutoCompleteFacet)param.getFacet(ActionParameterAutoCompleteFacet.class);
            MetaModelRow.addIfNotEmpty(MetaModelRow.interpretFacet((Facet)facet), interpretations);
        }
        return !interpretations.isEmpty() ? Joiner.on((String)";").join((Iterable)interpretations) : "";
    }

    String getDefault() {
        if (this.memberType == MemberType.PROPERTY) {
            return this.interpretRowAndFacet(PropertyDefaultFacet.class);
        }
        if (this.memberType == MemberType.COLLECTION) {
            return "";
        }
        List parameters = this.action.getParameters();
        TreeSet interpretations = Sets.newTreeSet();
        for (ObjectActionParameter param : parameters) {
            ActionParameterDefaultsFacet facet = (ActionParameterDefaultsFacet)param.getFacet(ActionParameterDefaultsFacet.class);
            MetaModelRow.addIfNotEmpty(MetaModelRow.interpretFacet((Facet)facet), interpretations);
        }
        return !interpretations.isEmpty() ? Joiner.on((String)";").join((Iterable)interpretations) : this.interpretRowAndFacet(ActionDefaultsFacet.class);
    }

    String getValidate() {
        if (this.memberType == MemberType.PROPERTY) {
            return this.interpretRowAndFacet(PropertyValidateFacet.class);
        }
        if (this.memberType == MemberType.COLLECTION) {
            TreeSet interpretations = Sets.newTreeSet();
            MetaModelRow.addIfNotEmpty(this.interpretRowAndFacet(CollectionValidateAddToFacet.class), interpretations);
            MetaModelRow.addIfNotEmpty(this.interpretRowAndFacet(CollectionValidateRemoveFromFacet.class), interpretations);
            return !interpretations.isEmpty() ? Joiner.on((String)";").join((Iterable)interpretations) : "";
        }
        return this.interpretRowAndFacet(ActionValidationFacet.class);
    }

    static Object header() {
        return "classType,packageName,className,memberType,memberName,numParams,hidden,disabled,choices,autoComplete,default,validate";
    }

    String asTextCsv() {
        return Joiner.on((String)",").join((Object)this.getClassType(), (Object)this.getPackageName(), new Object[]{this.getClassName(), this.getType(), this.getMemberName(), this.getNumParams(), this.getHidden(), this.getDisabled(), this.getChoices(), this.getAutoComplete(), this.getDefault(), this.getValidate()});
    }

    private String interpretRowAndFacet(Class<? extends Facet> facetClass) {
        Facet facet = this.member.getFacet(facetClass);
        return MetaModelRow.interpretFacet(facet);
    }

    private static void addIfNotEmpty(String str, SortedSet<String> set) {
        if (!Strings.isNullOrEmpty((String)str)) {
            set.add(str);
        }
    }

    private String interpret(Class<? extends Facet> cls) {
        return MetaModelRow.interpretFacet(this.member.getFacet(cls));
    }

    private static String interpretFacet(Facet facet) {
        if (facet == null || facet.isNoop()) {
            return "";
        }
        if (facet instanceof ImperativeFacet) {
            ImperativeFacet imperativeFacet = (ImperativeFacet)facet;
            return ((Method)imperativeFacet.getMethods().get(0)).getName();
        }
        String name = facet.getClass().getSimpleName();
        if (MetaModelRow.ignore(name)) {
            return "";
        }
        String abbr = StringExtensions.toAbbreviation((String)name);
        return abbr.length() > 0 ? abbr : name;
    }

    protected static boolean ignore(String name) {
        return Arrays.asList("PropertyValidateFacetDefault", "PropertyDefaultFacetDerivedFromDefaultedFacet").contains(name);
    }

    @Override
    public int compareTo(MetaModelRow o) {
        return ObjectContracts.compare((Object)this, (Object)o, (String)"classType,className,type desc,memberName");
    }

    static enum MemberType {
        PROPERTY,
        COLLECTION,
        ACTION;

    }
}

