package org.apache.iotdb.db.protocol.rest;

import org.apache.iotdb.db.protocol.rest.model.*;
import org.apache.iotdb.db.protocol.rest.RestApiService;
import org.apache.iotdb.db.protocol.rest.factories.RestApiServiceFactory;

import io.swagger.annotations.ApiParam;
import io.swagger.jaxrs.*;

import org.apache.iotdb.db.protocol.rest.model.ExecutionStatus;
import org.apache.iotdb.db.protocol.rest.model.InsertTabletRequest;
import org.apache.iotdb.db.protocol.rest.model.QueryDataSet;
import org.apache.iotdb.db.protocol.rest.model.SQL;

import java.util.Map;
import java.util.List;
import org.apache.iotdb.db.protocol.rest.NotFoundException;

import java.io.InputStream;

import org.glassfish.jersey.media.multipart.FormDataParam;
import org.glassfish.jersey.media.multipart.FormDataBodyPart;

import javax.servlet.ServletConfig;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.*;
import javax.validation.constraints.*;
import javax.validation.Valid;

@Path("/rest/v1")


@io.swagger.annotations.Api(description = "the rest API")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaJerseyServerCodegen", date = "2022-12-02T16:45:32.397906+08:00[Asia/Shanghai]")
public class RestApi  {
   private final RestApiService delegate;

   public RestApi(@Context ServletConfig servletContext) {
      RestApiService delegate = null;

      if (servletContext != null) {
         String implClass = servletContext.getInitParameter("RestApi.implementation");
         if (implClass != null && !"".equals(implClass.trim())) {
            try {
               delegate = (RestApiService) Class.forName(implClass).newInstance();
            } catch (Exception e) {
               throw new RuntimeException(e);
            }
         } 
      }

      if (delegate == null) {
         delegate = RestApiServiceFactory.getRestApi();
      }

      this.delegate = delegate;
   }

    @POST
    @Path("/nonQuery")
    @Consumes({ "application/json" })
    @Produces({ "application/json" })
    @io.swagger.annotations.ApiOperation(value = "executeNonQueryStatement", notes = "executeNonQueryStatement", response = ExecutionStatus.class, authorizations = {
        @io.swagger.annotations.Authorization(value = "basic")
    }, tags={  })
    @io.swagger.annotations.ApiResponses(value = { 
        @io.swagger.annotations.ApiResponse(code = 200, message = "ExecutionStatus", response = ExecutionStatus.class) })
    public Response executeNonQueryStatement(@ApiParam(value = "") @Valid  SQL SQL,@Context SecurityContext securityContext)
    throws NotFoundException {
        return delegate.executeNonQueryStatement(SQL, securityContext);
    }
    @POST
    @Path("/query")
    @Consumes({ "application/json" })
    @Produces({ "application/json" })
    @io.swagger.annotations.ApiOperation(value = "executeQueryStatement", notes = "executeQueryStatement", response = QueryDataSet.class, authorizations = {
        @io.swagger.annotations.Authorization(value = "basic")
    }, tags={  })
    @io.swagger.annotations.ApiResponses(value = { 
        @io.swagger.annotations.ApiResponse(code = 200, message = "QueryDataSet", response = QueryDataSet.class) })
    public Response executeQueryStatement(@ApiParam(value = "") @Valid  SQL SQL,@Context SecurityContext securityContext)
    throws NotFoundException {
        return delegate.executeQueryStatement(SQL, securityContext);
    }
    @POST
    @Path("/insertTablet")
    @Consumes({ "application/json" })
    @Produces({ "application/json" })
    @io.swagger.annotations.ApiOperation(value = "insertTablet", notes = "insertTablet", response = ExecutionStatus.class, authorizations = {
        @io.swagger.annotations.Authorization(value = "basic")
    }, tags={  })
    @io.swagger.annotations.ApiResponses(value = { 
        @io.swagger.annotations.ApiResponse(code = 200, message = "ExecutionStatus", response = ExecutionStatus.class) })
    public Response insertTablet(@ApiParam(value = "") @Valid  InsertTabletRequest insertTabletRequest,@Context SecurityContext securityContext)
    throws NotFoundException {
        return delegate.insertTablet(insertTabletRequest, securityContext);
    }
}
