package org.apache.iotdb.db.protocol.rest;

import org.apache.iotdb.db.protocol.rest.model.*;
import org.apache.iotdb.db.protocol.rest.GrafanaApiService;
import org.apache.iotdb.db.protocol.rest.factories.GrafanaApiServiceFactory;

import io.swagger.annotations.ApiParam;
import io.swagger.jaxrs.*;

import org.apache.iotdb.db.protocol.rest.model.ExecutionStatus;
import org.apache.iotdb.db.protocol.rest.model.ExpressionRequest;
import java.util.List;
import org.apache.iotdb.db.protocol.rest.model.QueryDataSet;
import org.apache.iotdb.db.protocol.rest.model.SQL;

import java.util.Map;
import java.util.List;
import org.apache.iotdb.db.protocol.rest.NotFoundException;

import java.io.InputStream;

import org.glassfish.jersey.media.multipart.FormDataParam;
import org.glassfish.jersey.media.multipart.FormDataBodyPart;

import javax.servlet.ServletConfig;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.*;
import javax.validation.constraints.*;
import javax.validation.Valid;

@Path("/grafana/v1")


@io.swagger.annotations.Api(description = "the grafana API")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaJerseyServerCodegen", date = "2022-12-02T16:45:32.397906+08:00[Asia/Shanghai]")
public class GrafanaApi  {
   private final GrafanaApiService delegate;

   public GrafanaApi(@Context ServletConfig servletContext) {
      GrafanaApiService delegate = null;

      if (servletContext != null) {
         String implClass = servletContext.getInitParameter("GrafanaApi.implementation");
         if (implClass != null && !"".equals(implClass.trim())) {
            try {
               delegate = (GrafanaApiService) Class.forName(implClass).newInstance();
            } catch (Exception e) {
               throw new RuntimeException(e);
            }
         } 
      }

      if (delegate == null) {
         delegate = GrafanaApiServiceFactory.getGrafanaApi();
      }

      this.delegate = delegate;
   }

    @POST
    @Path("/query/expression")
    @Consumes({ "application/json" })
    @Produces({ "application/json" })
    @io.swagger.annotations.ApiOperation(value = "expression", notes = "expression", response = QueryDataSet.class, authorizations = {
        @io.swagger.annotations.Authorization(value = "basic")
    }, tags={  })
    @io.swagger.annotations.ApiResponses(value = { 
        @io.swagger.annotations.ApiResponse(code = 200, message = "QueryDataSet", response = QueryDataSet.class) })
    public Response expression(@ApiParam(value = "") @Valid  ExpressionRequest expressionRequest,@Context SecurityContext securityContext)
    throws NotFoundException {
        return delegate.expression(expressionRequest, securityContext);
    }
    @GET
    @Path("/login")
    
    @Produces({ "application/json" })
    @io.swagger.annotations.ApiOperation(value = "", notes = "", response = ExecutionStatus.class, authorizations = {
        @io.swagger.annotations.Authorization(value = "basic")
    }, tags={  })
    @io.swagger.annotations.ApiResponses(value = { 
        @io.swagger.annotations.ApiResponse(code = 200, message = "ExecutionStatus", response = ExecutionStatus.class) })
    public Response login(@Context SecurityContext securityContext)
    throws NotFoundException {
        return delegate.login(securityContext);
    }
    @POST
    @Path("/node")
    @Consumes({ "application/json" })
    @Produces({ "application/json" })
    @io.swagger.annotations.ApiOperation(value = "node", notes = "node", response = String.class, responseContainer = "List", authorizations = {
        @io.swagger.annotations.Authorization(value = "basic")
    }, tags={  })
    @io.swagger.annotations.ApiResponses(value = { 
        @io.swagger.annotations.ApiResponse(code = 200, message = "NodesResult", response = String.class, responseContainer = "List") })
    public Response node(@ApiParam(value = "") @Valid  List<String> requestBody,@Context SecurityContext securityContext)
    throws NotFoundException {
        return delegate.node(requestBody, securityContext);
    }
    @POST
    @Path("/variable")
    @Consumes({ "application/json" })
    @Produces({ "application/json" })
    @io.swagger.annotations.ApiOperation(value = "variables", notes = "variables", response = Object.class, responseContainer = "List", authorizations = {
        @io.swagger.annotations.Authorization(value = "basic")
    }, tags={  })
    @io.swagger.annotations.ApiResponses(value = { 
        @io.swagger.annotations.ApiResponse(code = 200, message = "VariablesResult", response = Object.class, responseContainer = "List") })
    public Response variables(@ApiParam(value = "") @Valid  SQL SQL,@Context SecurityContext securityContext)
    throws NotFoundException {
        return delegate.variables(SQL, securityContext);
    }
}
