/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.systemview.view;

import org.apache.ignite.internal.managers.systemview.walker.Order;
import org.apache.ignite.internal.processors.query.h2.H2Utils;
import org.apache.ignite.internal.processors.query.h2.database.H2IndexType;
import org.apache.ignite.internal.processors.query.h2.database.H2PkHashIndex;
import org.apache.ignite.internal.processors.query.h2.database.H2TreeIndexBase;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2ProxyIndex;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;
import org.apache.ignite.internal.processors.query.h2.opt.H2TableScanIndex;
import org.h2.index.Index;

public class SqlIndexView {
    private final GridH2Table tbl;
    private final Index idx;
    private final H2IndexType type;

    public SqlIndexView(GridH2Table tbl, Index idx) {
        this.tbl = tbl;
        this.idx = idx;
        this.type = SqlIndexView.type(idx);
    }

    public int cacheId() {
        return this.tbl.cacheId();
    }

    @Order(value=5)
    public String cacheName() {
        return this.tbl.cacheName();
    }

    @Order(value=3)
    public String schemaName() {
        return this.tbl.getSchema().getName();
    }

    @Order(value=4)
    public String tableName() {
        return this.tbl.identifier().table();
    }

    @Order
    public String indexName() {
        return this.idx.getName();
    }

    @Order(value=1)
    public H2IndexType indexType() {
        return this.type;
    }

    @Order(value=2)
    public String columns() {
        switch (this.type) {
            case HASH: 
            case BTREE: {
                return H2Utils.indexColumnsSql(H2Utils.unwrapKeyColumns(this.tbl, this.idx.getIndexColumns()));
            }
            case SPATIAL: {
                return H2Utils.indexColumnsSql(this.idx.getIndexColumns());
            }
            case SCAN: {
                return null;
            }
        }
        return "???";
    }

    public boolean isPk() {
        return this.idx.getIndexType().isPrimaryKey();
    }

    public boolean isUnique() {
        return this.idx.getIndexType().isUnique();
    }

    public int inlineSize() {
        return this.idx instanceof H2TreeIndexBase ? ((H2TreeIndexBase)this.idx).inlineSize() : 0;
    }

    private static H2IndexType type(Index idx) {
        if (idx instanceof H2TreeIndexBase) {
            return H2IndexType.BTREE;
        }
        if (idx instanceof H2PkHashIndex) {
            return H2IndexType.HASH;
        }
        if (idx instanceof H2TableScanIndex) {
            return H2IndexType.SCAN;
        }
        if (idx instanceof GridH2ProxyIndex) {
            return SqlIndexView.type(((GridH2ProxyIndex)idx).underlyingIndex());
        }
        if (idx.getIndexType().isSpatial()) {
            return H2IndexType.SPATIAL;
        }
        return null;
    }
}

