/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.systemview;

import java.util.function.Predicate;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.query.QueryUtils;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.processors.query.h2.SchemaManager;
import org.apache.ignite.spi.IgniteSpiAdapter;
import org.apache.ignite.spi.IgniteSpiContext;
import org.apache.ignite.spi.IgniteSpiException;
import org.apache.ignite.spi.systemview.FiltrableSystemViewLocal;
import org.apache.ignite.spi.systemview.ReadOnlySystemViewRegistry;
import org.apache.ignite.spi.systemview.SystemViewExporterSpi;
import org.apache.ignite.spi.systemview.SystemViewLocal;
import org.apache.ignite.spi.systemview.view.FiltrableSystemView;
import org.apache.ignite.spi.systemview.view.SystemView;
import org.jetbrains.annotations.Nullable;

public class SqlViewExporterSpi
extends IgniteSpiAdapter
implements SystemViewExporterSpi {
    @Nullable
    private Predicate<SystemView<?>> filter;
    private ReadOnlySystemViewRegistry sysViewReg;
    private SchemaManager mgr;

    protected void onContextInitialized0(IgniteSpiContext spiCtx) throws IgniteSpiException {
        GridKernalContext ctx = ((IgniteEx)this.ignite()).context();
        if (ctx.query().getIndexing() instanceof IgniteH2Indexing) {
            this.mgr = ((IgniteH2Indexing)ctx.query().getIndexing()).schemaManager();
            this.sysViewReg.forEach(this::register);
            this.sysViewReg.addSystemViewCreationListener(this::register);
        }
    }

    private void register(SystemView<?> sysView) {
        if (this.filter != null && !this.filter.test(sysView)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("System view filtered and will not be registered [name=" + sysView.name() + ']');
            }
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Found new system view [name=" + sysView.name() + ']');
        }
        GridKernalContext ctx = ((IgniteEx)this.ignite()).context();
        SystemViewLocal view = sysView instanceof FiltrableSystemView ? new FiltrableSystemViewLocal(ctx, sysView) : new SystemViewLocal(ctx, sysView);
        this.mgr.createSystemView(QueryUtils.SCHEMA_SYS, view);
    }

    public void spiStart(@Nullable String igniteInstanceName) throws IgniteSpiException {
    }

    public void spiStop() throws IgniteSpiException {
    }

    public void setSystemViewRegistry(ReadOnlySystemViewRegistry mlreg) {
        this.sysViewReg = mlreg;
    }

    public void setExportFilter(Predicate<SystemView<?>> filter) {
        this.filter = filter;
    }
}

