/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.systemview;

import java.util.HashMap;
import java.util.Iterator;
import java.util.stream.Collectors;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.processors.query.h2.sys.view.SqlSystemViewColumnCondition;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.spi.systemview.SystemViewLocal;
import org.apache.ignite.spi.systemview.view.FiltrableSystemView;
import org.apache.ignite.spi.systemview.view.SystemView;
import org.apache.ignite.spi.systemview.view.SystemViewRowAttributeWalker;
import org.h2.result.SearchRow;

public class FiltrableSystemViewLocal<R>
extends SystemViewLocal<R> {
    private final String[] attributeNames;
    private final Class<?>[] attributeClasses;

    public FiltrableSystemViewLocal(GridKernalContext ctx, SystemView<R> sysView) {
        super(ctx, sysView, FiltrableSystemViewLocal.indexes(sysView));
        assert (sysView instanceof FiltrableSystemView);
        this.attributeNames = new String[sysView.walker().count()];
        this.attributeClasses = new Class[sysView.walker().count()];
        sysView.walker().visitAll(new SystemViewRowAttributeWalker.AttributeVisitor(){

            public <T> void accept(int idx, String name, Class<T> clazz) {
                ((FiltrableSystemViewLocal)FiltrableSystemViewLocal.this).attributeNames[idx] = name;
                ((FiltrableSystemViewLocal)FiltrableSystemViewLocal.this).attributeClasses[idx] = U.box(clazz);
            }
        });
    }

    @Override
    protected Iterator<R> viewIterator(SearchRow first, SearchRow last) {
        HashMap<String, Object> filter = new HashMap<String, Object>();
        for (int i = 0; i < this.cols.length; ++i) {
            SqlSystemViewColumnCondition cond = SqlSystemViewColumnCondition.forColumn(i, first, last);
            if (!cond.isEquality()) continue;
            Object val = cond.valueForEquality().getObject();
            if (this.attributeClasses[i].isInstance(val)) {
                filter.put(this.attributeNames[i], val);
                continue;
            }
            throw new IgniteSQLException("Unexpected filter value type [column=" + this.cols[i] + ", actual=" + val.getClass().getSimpleName() + ", expected=" + this.attributeClasses[i].getSimpleName(), 3013);
        }
        return ((FiltrableSystemView)this.sysView).iterator(filter);
    }

    private static String[] indexes(SystemView<?> sysView) {
        return new String[]{sysView.walker().filtrableAttributes().stream().map(SystemViewLocal::sqlName).collect(Collectors.joining(","))};
    }
}

