/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.sql;

import java.util.List;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlColumn;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlElement;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlQuery;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlStatement;
import org.h2.util.StatementBuilder;

public class GridSqlInsert
extends GridSqlStatement {
    private GridSqlElement into;
    private GridSqlColumn[] cols;
    private List<GridSqlElement[]> rows;
    private GridSqlQuery qry;
    private boolean direct;
    private boolean sorted;

    @Override
    public String getSQL() {
        StatementBuilder buff = new StatementBuilder(this.explain() ? "EXPLAIN " : "");
        buff.append("INSERT").append("\nINTO ").append(this.into.getSQL()).append('(');
        for (GridSqlColumn col : this.cols) {
            buff.appendExceptFirst(", ");
            buff.append('\n').append(col.getSQL());
        }
        buff.append("\n)\n");
        if (this.direct) {
            buff.append("DIRECT ");
        }
        if (this.sorted) {
            buff.append("SORTED ");
        }
        if (!this.rows.isEmpty()) {
            buff.append("VALUES\n");
            StatementBuilder valuesBuff = new StatementBuilder();
            for (GridSqlElement[] row : this.rows()) {
                valuesBuff.appendExceptFirst(",\n");
                StatementBuilder rowBuff = new StatementBuilder("(");
                for (GridSqlElement e : row) {
                    rowBuff.appendExceptFirst(", ");
                    rowBuff.append(e != null ? e.getSQL() : "DEFAULT");
                }
                rowBuff.append(')');
                valuesBuff.append(rowBuff.toString());
            }
            buff.append(valuesBuff.toString());
        } else {
            buff.append('\n').append(this.qry.getSQL());
        }
        return buff.toString();
    }

    public GridSqlElement into() {
        return this.into;
    }

    public GridSqlInsert into(GridSqlElement from) {
        this.into = from;
        return this;
    }

    public List<GridSqlElement[]> rows() {
        return this.rows;
    }

    public GridSqlInsert rows(List<GridSqlElement[]> rows) {
        assert (rows != null);
        this.rows = rows;
        return this;
    }

    public GridSqlQuery query() {
        return this.qry;
    }

    public GridSqlInsert query(GridSqlQuery qry) {
        this.qry = qry;
        return this;
    }

    public GridSqlColumn[] columns() {
        return this.cols;
    }

    public GridSqlInsert columns(GridSqlColumn[] cols) {
        this.cols = cols;
        return this;
    }

    public GridSqlInsert direct(boolean direct) {
        this.direct = direct;
        return this;
    }

    public GridSqlInsert sorted(boolean sorted) {
        this.sorted = sorted;
        return this;
    }
}

