/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.parquet;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Deque;
import java.util.List;
import java.util.Optional;
import org.apache.iceberg.expressions.PathUtil;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.types.Comparators;
import org.apache.iceberg.util.BinaryUtil;
import org.apache.iceberg.util.UnicodeUtil;
import org.apache.iceberg.variants.PhysicalType;
import org.apache.iceberg.variants.VariantArray;
import org.apache.iceberg.variants.VariantMetadata;
import org.apache.iceberg.variants.VariantObject;
import org.apache.iceberg.variants.VariantPrimitive;
import org.apache.iceberg.variants.VariantValue;
import org.apache.iceberg.variants.VariantVisitor;
import org.apache.iceberg.variants.Variants;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;

class ParquetVariantUtil {
    private ParquetVariantUtil() {
    }

    static PhysicalType convert(PrimitiveType primitive) {
        LogicalTypeAnnotation annotation = primitive.getLogicalTypeAnnotation();
        if (annotation != null) {
            return annotation.accept((LogicalTypeAnnotation.LogicalTypeAnnotationVisitor)PhysicalTypeConverter.INSTANCE).orElse(null);
        }
        switch (primitive.getPrimitiveTypeName()) {
            case BOOLEAN: {
                return PhysicalType.BOOLEAN_TRUE;
            }
            case INT32: {
                return PhysicalType.INT32;
            }
            case INT64: {
                return PhysicalType.INT64;
            }
            case FLOAT: {
                return PhysicalType.FLOAT;
            }
            case DOUBLE: {
                return PhysicalType.DOUBLE;
            }
            case BINARY: {
                return PhysicalType.BINARY;
            }
        }
        return null;
    }

    static ByteBuffer toByteBuffer(VariantMetadata metadata, VariantValue value) {
        ByteBuffer buffer = ByteBuffer.allocate(metadata.sizeInBytes() + value.sizeInBytes()).order(ByteOrder.LITTLE_ENDIAN);
        metadata.writeTo(buffer, 0);
        value.writeTo(buffer, metadata.sizeInBytes());
        return buffer;
    }

    static <T> T convertValue(PhysicalType primitive, int scale, Object value) {
        switch (primitive) {
            case BOOLEAN_FALSE: 
            case BOOLEAN_TRUE: 
            case INT32: 
            case INT64: 
            case DATE: 
            case TIMESTAMPTZ: 
            case TIMESTAMPNTZ: 
            case FLOAT: 
            case DOUBLE: {
                return (T)value;
            }
            case INT8: {
                return (T)Byte.valueOf(((Number)value).byteValue());
            }
            case INT16: {
                return (T)Short.valueOf(((Number)value).shortValue());
            }
            case DECIMAL4: 
            case DECIMAL8: {
                return (T)BigDecimal.valueOf(((Number)value).longValue(), scale);
            }
            case DECIMAL16: {
                return (T)new BigDecimal(new BigInteger(((Binary)value).getBytes()), scale);
            }
            case BINARY: {
                return (T)((Binary)value).toByteBuffer();
            }
            case STRING: {
                return (T)((Binary)value).toStringUsingUTF8();
            }
        }
        throw new IllegalStateException("Invalid bound type: " + primitive);
    }

    static <T> Comparator<T> comparator(PhysicalType primitive) {
        if (primitive == PhysicalType.BINARY) {
            return Comparators.unsignedBytes();
        }
        return Comparator.naturalOrder();
    }

    static int scale(PrimitiveType primitive) {
        LogicalTypeAnnotation annotation = primitive.getLogicalTypeAnnotation();
        if (annotation instanceof LogicalTypeAnnotation.DecimalLogicalTypeAnnotation) {
            return ((LogicalTypeAnnotation.DecimalLogicalTypeAnnotation)annotation).getScale();
        }
        return 0;
    }

    static Type toParquetSchema(VariantValue value) {
        return (Type)VariantVisitor.visit((VariantValue)value, (VariantVisitor)new ParquetSchemaProducer());
    }

    private static class ParquetSchemaProducer
    extends VariantVisitor<Type> {
        private ParquetSchemaProducer() {
        }

        public Type object(VariantObject object, List<String> names, List<Type> typedValues) {
            if (object.numFields() < 1) {
                return null;
            }
            ArrayList fields = Lists.newArrayList();
            int index = 0;
            for (String name : names) {
                Type typedValue = typedValues.get(index);
                fields.add(ParquetSchemaProducer.field(name, typedValue));
                ++index;
            }
            return ParquetSchemaProducer.objectFields(fields);
        }

        public Type array(VariantArray array, List<Type> elementResults) {
            return null;
        }

        public Type primitive(VariantPrimitive<?> primitive) {
            switch (primitive.type()) {
                case NULL: {
                    return null;
                }
                case BOOLEAN_FALSE: 
                case BOOLEAN_TRUE: {
                    return ParquetSchemaProducer.shreddedPrimitive(PrimitiveType.PrimitiveTypeName.BOOLEAN);
                }
                case INT8: {
                    return ParquetSchemaProducer.shreddedPrimitive(PrimitiveType.PrimitiveTypeName.INT32, (LogicalTypeAnnotation)LogicalTypeAnnotation.intType((int)8));
                }
                case INT16: {
                    return ParquetSchemaProducer.shreddedPrimitive(PrimitiveType.PrimitiveTypeName.INT32, (LogicalTypeAnnotation)LogicalTypeAnnotation.intType((int)16));
                }
                case INT32: {
                    return ParquetSchemaProducer.shreddedPrimitive(PrimitiveType.PrimitiveTypeName.INT32);
                }
                case INT64: {
                    return ParquetSchemaProducer.shreddedPrimitive(PrimitiveType.PrimitiveTypeName.INT64);
                }
                case FLOAT: {
                    return ParquetSchemaProducer.shreddedPrimitive(PrimitiveType.PrimitiveTypeName.FLOAT);
                }
                case DOUBLE: {
                    return ParquetSchemaProducer.shreddedPrimitive(PrimitiveType.PrimitiveTypeName.DOUBLE);
                }
                case DECIMAL4: {
                    BigDecimal decimal4 = (BigDecimal)primitive.get();
                    return ParquetSchemaProducer.shreddedPrimitive(PrimitiveType.PrimitiveTypeName.INT32, (LogicalTypeAnnotation)LogicalTypeAnnotation.decimalType((int)decimal4.scale(), (int)9));
                }
                case DECIMAL8: {
                    BigDecimal decimal8 = (BigDecimal)primitive.get();
                    return ParquetSchemaProducer.shreddedPrimitive(PrimitiveType.PrimitiveTypeName.INT64, (LogicalTypeAnnotation)LogicalTypeAnnotation.decimalType((int)decimal8.scale(), (int)18));
                }
                case DECIMAL16: {
                    BigDecimal decimal16 = (BigDecimal)primitive.get();
                    return ParquetSchemaProducer.shreddedPrimitive(PrimitiveType.PrimitiveTypeName.BINARY, (LogicalTypeAnnotation)LogicalTypeAnnotation.decimalType((int)decimal16.scale(), (int)38));
                }
                case DATE: {
                    return ParquetSchemaProducer.shreddedPrimitive(PrimitiveType.PrimitiveTypeName.INT32, (LogicalTypeAnnotation)LogicalTypeAnnotation.dateType());
                }
                case TIMESTAMPTZ: {
                    return ParquetSchemaProducer.shreddedPrimitive(PrimitiveType.PrimitiveTypeName.INT64, (LogicalTypeAnnotation)LogicalTypeAnnotation.timestampType((boolean)true, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MICROS));
                }
                case TIMESTAMPNTZ: {
                    return ParquetSchemaProducer.shreddedPrimitive(PrimitiveType.PrimitiveTypeName.INT64, (LogicalTypeAnnotation)LogicalTypeAnnotation.timestampType((boolean)false, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MICROS));
                }
                case BINARY: {
                    return ParquetSchemaProducer.shreddedPrimitive(PrimitiveType.PrimitiveTypeName.BINARY);
                }
                case STRING: {
                    return ParquetSchemaProducer.shreddedPrimitive(PrimitiveType.PrimitiveTypeName.BINARY, (LogicalTypeAnnotation)LogicalTypeAnnotation.stringType());
                }
            }
            throw new UnsupportedOperationException("Unsupported shredding type: " + primitive.type());
        }

        private static GroupType objectFields(List<GroupType> fields) {
            Types.GroupBuilder builder = Types.buildGroup((Type.Repetition)Type.Repetition.OPTIONAL);
            for (GroupType field : fields) {
                ParquetSchemaProducer.checkField(field);
                builder.addField((Type)field);
            }
            return (GroupType)builder.named("typed_value");
        }

        private static void checkField(GroupType fieldType) {
            Preconditions.checkArgument((boolean)fieldType.isRepetition(Type.Repetition.REQUIRED), (String)"Invalid field type repetition: %s should be REQUIRED", (Object)fieldType.getRepetition());
        }

        private static GroupType field(String name, Type shreddedType) {
            Types.GroupBuilder builder = (Types.GroupBuilder)Types.buildGroup((Type.Repetition)Type.Repetition.REQUIRED).optional(PrimitiveType.PrimitiveTypeName.BINARY).named("value");
            if (shreddedType != null) {
                ParquetSchemaProducer.checkShreddedType(shreddedType);
                builder.addField(shreddedType);
            }
            return (GroupType)builder.named(name);
        }

        private static void checkShreddedType(Type shreddedType) {
            Preconditions.checkArgument((boolean)shreddedType.getName().equals("typed_value"), (String)"Invalid shredded type name: %s should be typed_value", (Object)shreddedType.getName());
            Preconditions.checkArgument((boolean)shreddedType.isRepetition(Type.Repetition.OPTIONAL), (String)"Invalid shredded type repetition: %s should be OPTIONAL", (Object)shreddedType.getRepetition());
        }

        private static Type shreddedPrimitive(PrimitiveType.PrimitiveTypeName primitive) {
            return (Type)Types.optional((PrimitiveType.PrimitiveTypeName)primitive).named("typed_value");
        }

        private static Type shreddedPrimitive(PrimitiveType.PrimitiveTypeName primitive, LogicalTypeAnnotation annotation) {
            return (Type)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)primitive).as(annotation)).named("typed_value");
        }
    }

    static class VariantMetrics {
        private final long valueCount;
        private final long nullCount;
        private final VariantValue lowerBound;
        private final VariantValue upperBound;
        private final Deque<String> fieldNames = Lists.newLinkedList();
        private String lazyFieldName = null;

        VariantMetrics(long valueCount, long nullCount) {
            this.valueCount = valueCount;
            this.nullCount = nullCount;
            this.lowerBound = null;
            this.upperBound = null;
        }

        VariantMetrics(long valueCount, long nullCount, VariantValue lowerBound, VariantValue upperBound) {
            this.valueCount = valueCount;
            this.nullCount = nullCount;
            this.lowerBound = VariantMetrics.truncateLowerBound(lowerBound);
            this.upperBound = VariantMetrics.truncateUpperBound(upperBound);
        }

        VariantMetrics prependFieldName(String name) {
            this.lazyFieldName = null;
            this.fieldNames.addFirst(name);
            return this;
        }

        public String fieldName() {
            if (null == this.lazyFieldName) {
                this.lazyFieldName = PathUtil.toNormalizedPath(this.fieldNames);
            }
            return this.lazyFieldName;
        }

        public long valueCount() {
            return this.valueCount;
        }

        public long nullCount() {
            return this.nullCount;
        }

        public VariantValue lowerBound() {
            return this.lowerBound;
        }

        public VariantValue upperBound() {
            return this.upperBound;
        }

        private static VariantValue truncateLowerBound(VariantValue value) {
            switch (value.type()) {
                case STRING: {
                    return Variants.of((PhysicalType)PhysicalType.STRING, (Object)UnicodeUtil.truncateStringMin((String)((String)value.asPrimitive().get()), (int)16));
                }
                case BINARY: {
                    return Variants.of((PhysicalType)PhysicalType.BINARY, (Object)BinaryUtil.truncateBinaryMin((ByteBuffer)((ByteBuffer)value.asPrimitive().get()), (int)16));
                }
            }
            return value;
        }

        private static VariantValue truncateUpperBound(VariantValue value) {
            switch (value.type()) {
                case STRING: {
                    String truncatedString = UnicodeUtil.truncateStringMax((String)((String)value.asPrimitive().get()), (int)16);
                    return truncatedString != null ? Variants.of((PhysicalType)PhysicalType.STRING, (Object)truncatedString) : null;
                }
                case BINARY: {
                    ByteBuffer truncatedBuffer = BinaryUtil.truncateBinaryMin((ByteBuffer)((ByteBuffer)value.asPrimitive().get()), (int)16);
                    return truncatedBuffer != null ? Variants.of((PhysicalType)PhysicalType.BINARY, (Object)truncatedBuffer) : null;
                }
            }
            return value;
        }
    }

    private static class PhysicalTypeConverter
    implements LogicalTypeAnnotation.LogicalTypeAnnotationVisitor<PhysicalType> {
        private static final PhysicalTypeConverter INSTANCE = new PhysicalTypeConverter();

        private PhysicalTypeConverter() {
        }

        public Optional<PhysicalType> visit(LogicalTypeAnnotation.StringLogicalTypeAnnotation ignored) {
            return Optional.of(PhysicalType.STRING);
        }

        public Optional<PhysicalType> visit(LogicalTypeAnnotation.DecimalLogicalTypeAnnotation decimal) {
            if (decimal.getPrecision() <= 9) {
                return Optional.of(PhysicalType.DECIMAL4);
            }
            if (decimal.getPrecision() <= 18) {
                return Optional.of(PhysicalType.DECIMAL8);
            }
            return Optional.of(PhysicalType.DECIMAL16);
        }

        public Optional<PhysicalType> visit(LogicalTypeAnnotation.DateLogicalTypeAnnotation ignored) {
            return Optional.of(PhysicalType.DATE);
        }

        public Optional<PhysicalType> visit(LogicalTypeAnnotation.TimeLogicalTypeAnnotation ignored) {
            return Optional.empty();
        }

        public Optional<PhysicalType> visit(LogicalTypeAnnotation.TimestampLogicalTypeAnnotation timestamps) {
            switch (timestamps.getUnit()) {
                case MICROS: {
                    if (timestamps.isAdjustedToUTC()) {
                        return Optional.of(PhysicalType.TIMESTAMPTZ);
                    }
                    return Optional.of(PhysicalType.TIMESTAMPNTZ);
                }
            }
            return Optional.empty();
        }

        public Optional<PhysicalType> visit(LogicalTypeAnnotation.IntLogicalTypeAnnotation ints) {
            if (!ints.isSigned()) {
                return Optional.empty();
            }
            switch (ints.getBitWidth()) {
                case 8: {
                    return Optional.of(PhysicalType.INT8);
                }
                case 16: {
                    return Optional.of(PhysicalType.INT16);
                }
                case 32: {
                    return Optional.of(PhysicalType.INT32);
                }
                case 64: {
                    return Optional.of(PhysicalType.INT64);
                }
            }
            return Optional.empty();
        }

        public Optional<PhysicalType> visit(LogicalTypeAnnotation.UUIDLogicalTypeAnnotation uuidLogicalType) {
            return Optional.empty();
        }
    }
}

