/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.parquet;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.Files;
import org.apache.iceberg.InternalData;
import org.apache.iceberg.MetricsConfig;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SchemaParser;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.SystemConfigs;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableProperties;
import org.apache.iceberg.avro.AvroSchemaUtil;
import org.apache.iceberg.data.parquet.GenericParquetWriter;
import org.apache.iceberg.deletes.EqualityDeleteWriter;
import org.apache.iceberg.deletes.PositionDeleteWriter;
import org.apache.iceberg.encryption.EncryptedOutputFile;
import org.apache.iceberg.encryption.EncryptionKeyMetadata;
import org.apache.iceberg.encryption.NativeEncryptionInputFile;
import org.apache.iceberg.encryption.NativeEncryptionOutputFile;
import org.apache.iceberg.exceptions.RuntimeIOException;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.hadoop.HadoopInputFile;
import org.apache.iceberg.hadoop.HadoopOutputFile;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.DataWriter;
import org.apache.iceberg.io.DeleteSchemaUtil;
import org.apache.iceberg.io.FileAppender;
import org.apache.iceberg.mapping.NameMapping;
import org.apache.iceberg.parquet.ParquetAvro;
import org.apache.iceberg.parquet.ParquetFilters;
import org.apache.iceberg.parquet.ParquetIO;
import org.apache.iceberg.parquet.ParquetIterable;
import org.apache.iceberg.parquet.ParquetReadSupport;
import org.apache.iceberg.parquet.ParquetReader;
import org.apache.iceberg.parquet.ParquetSchemaUtil;
import org.apache.iceberg.parquet.ParquetValueReader;
import org.apache.iceberg.parquet.ParquetValueWriter;
import org.apache.iceberg.parquet.ParquetValueWriters;
import org.apache.iceberg.parquet.ParquetWriteAdapter;
import org.apache.iceberg.parquet.ParquetWriteSupport;
import org.apache.iceberg.parquet.ParquetWriter;
import org.apache.iceberg.parquet.VariantShreddingFunction;
import org.apache.iceberg.parquet.VectorizedParquetReader;
import org.apache.iceberg.parquet.VectorizedReader;
import org.apache.iceberg.relocated.com.google.common.annotations.VisibleForTesting;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.ArrayUtil;
import org.apache.iceberg.util.ByteBuffers;
import org.apache.iceberg.util.PropertyUtil;
import org.apache.parquet.HadoopReadOptions;
import org.apache.parquet.ParquetReadOptions;
import org.apache.parquet.avro.AvroReadSupport;
import org.apache.parquet.avro.AvroWriteSupport;
import org.apache.parquet.column.ParquetProperties;
import org.apache.parquet.conf.ParquetConfiguration;
import org.apache.parquet.conf.PlainParquetConfiguration;
import org.apache.parquet.crypto.FileDecryptionProperties;
import org.apache.parquet.crypto.FileEncryptionProperties;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.parquet.hadoop.ParquetReader;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.hadoop.api.WriteSupport;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.io.InputFile;
import org.apache.parquet.io.OutputFile;
import org.apache.parquet.schema.MessageType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Parquet {
    private static final Logger LOG = LoggerFactory.getLogger(Parquet.class);
    private static final Collection<String> READ_PROPERTIES_TO_REMOVE = Sets.newHashSet((Object[])new String[]{"parquet.read.filter", "parquet.private.read.filter.predicate", "parquet.read.support.class", "parquet.crypto.factory.class"});

    private Parquet() {
    }

    public static WriteBuilder write(org.apache.iceberg.io.OutputFile file) {
        if (file instanceof EncryptedOutputFile) {
            return Parquet.write((EncryptedOutputFile)file);
        }
        return new WriteBuilder(file);
    }

    public static WriteBuilder write(EncryptedOutputFile file) {
        if (file instanceof NativeEncryptionOutputFile) {
            NativeEncryptionOutputFile nativeFile = (NativeEncryptionOutputFile)file;
            return Parquet.write(nativeFile.plainOutputFile()).withFileEncryptionKey(nativeFile.keyMetadata().encryptionKey()).withAADPrefix(nativeFile.keyMetadata().aadPrefix());
        }
        return Parquet.write(file.encryptingOutputFile());
    }

    public static DataWriteBuilder writeData(org.apache.iceberg.io.OutputFile file) {
        return new DataWriteBuilder(file);
    }

    public static DataWriteBuilder writeData(EncryptedOutputFile file) {
        if (file instanceof NativeEncryptionOutputFile) {
            NativeEncryptionOutputFile nativeFile = (NativeEncryptionOutputFile)file;
            return Parquet.writeData(nativeFile.plainOutputFile()).withFileEncryptionKey(nativeFile.keyMetadata().encryptionKey()).withAADPrefix(nativeFile.keyMetadata().aadPrefix());
        }
        return Parquet.writeData(file.encryptingOutputFile());
    }

    public static DeleteWriteBuilder writeDeletes(org.apache.iceberg.io.OutputFile file) {
        return new DeleteWriteBuilder(file);
    }

    public static DeleteWriteBuilder writeDeletes(EncryptedOutputFile file) {
        if (file instanceof NativeEncryptionOutputFile) {
            NativeEncryptionOutputFile nativeFile = (NativeEncryptionOutputFile)file;
            return Parquet.writeDeletes(nativeFile.plainOutputFile()).withFileEncryptionKey(nativeFile.keyMetadata().encryptionKey()).withAADPrefix(nativeFile.keyMetadata().aadPrefix());
        }
        return Parquet.writeDeletes(file.encryptingOutputFile());
    }

    public static ReadBuilder read(org.apache.iceberg.io.InputFile file) {
        if (file instanceof NativeEncryptionInputFile) {
            NativeEncryptionInputFile nativeFile = (NativeEncryptionInputFile)file;
            return new ReadBuilder(nativeFile.encryptedInputFile()).withFileEncryptionKey(nativeFile.keyMetadata().encryptionKey()).withAADPrefix(nativeFile.keyMetadata().aadPrefix());
        }
        return new ReadBuilder(file);
    }

    public static void concat(Iterable<File> inputFiles, File outputFile, int rowGroupSize, Schema schema, Map<String, String> metadata) throws IOException {
        org.apache.iceberg.io.OutputFile file = Files.localOutput((File)outputFile);
        ParquetFileWriter writer = new ParquetFileWriter(ParquetIO.file(file), ParquetSchemaUtil.convert(schema, "table"), ParquetFileWriter.Mode.CREATE, (long)rowGroupSize, 0);
        writer.start();
        for (File inputFile : inputFiles) {
            writer.appendFile(ParquetIO.file(Files.localInput((File)inputFile)));
        }
        writer.end(metadata);
    }

    private static class ParquetReadBuilder<T>
    extends ParquetReader.Builder<T> {
        private Schema schema = null;
        private ReadSupport<T> readSupport = null;
        private boolean callInit = false;
        private NameMapping nameMapping = null;

        private ParquetReadBuilder(InputFile file) {
            super(file);
        }

        public ParquetReadBuilder<T> project(Schema newSchema) {
            this.schema = newSchema;
            return this;
        }

        public ParquetReadBuilder<T> withNameMapping(NameMapping newNameMapping) {
            this.nameMapping = newNameMapping;
            return this;
        }

        public ParquetReadBuilder<T> readSupport(ReadSupport<T> newReadSupport) {
            this.readSupport = newReadSupport;
            return this;
        }

        public ParquetReadBuilder<T> callInit() {
            this.callInit = true;
            return this;
        }

        protected ReadSupport<T> getReadSupport() {
            return new ParquetReadSupport<T>(this.schema, this.readSupport, this.callInit, this.nameMapping);
        }
    }

    public static class ReadBuilder
    implements InternalData.ReadBuilder {
        private final org.apache.iceberg.io.InputFile file;
        private final Map<String, String> properties = Maps.newHashMap();
        private Long start = null;
        private Long length = null;
        private Schema schema = null;
        private Expression filter = null;
        private ReadSupport<?> readSupport = null;
        private Function<MessageType, VectorizedReader<?>> batchedReaderFunc = null;
        private Function<MessageType, ParquetValueReader<?>> readerFunc = null;
        private BiFunction<Schema, MessageType, ParquetValueReader<?>> readerFuncWithSchema = null;
        private boolean filterRecords = true;
        private boolean caseSensitive = true;
        private boolean callInit = false;
        private boolean reuseContainers = false;
        private int maxRecordsPerBatch = 10000;
        private NameMapping nameMapping = null;
        private ByteBuffer fileEncryptionKey = null;
        private ByteBuffer fileAADPrefix = null;

        private ReadBuilder(org.apache.iceberg.io.InputFile file) {
            this.file = file;
        }

        public ReadBuilder split(long newStart, long newLength) {
            this.start = newStart;
            this.length = newLength;
            return this;
        }

        public ReadBuilder project(Schema newSchema) {
            this.schema = newSchema;
            return this;
        }

        public ReadBuilder caseInsensitive() {
            return this.caseSensitive(false);
        }

        public ReadBuilder caseSensitive(boolean newCaseSensitive) {
            this.caseSensitive = newCaseSensitive;
            return this;
        }

        public ReadBuilder filterRecords(boolean newFilterRecords) {
            this.filterRecords = newFilterRecords;
            return this;
        }

        public ReadBuilder filter(Expression newFilter) {
            this.filter = newFilter;
            return this;
        }

        @Deprecated
        public ReadBuilder readSupport(ReadSupport<?> newFilterSupport) {
            this.readSupport = newFilterSupport;
            return this;
        }

        public ReadBuilder createReaderFunc(Function<MessageType, ParquetValueReader<?>> newReaderFunction) {
            Preconditions.checkArgument((this.batchedReaderFunc == null ? 1 : 0) != 0, (Object)"Cannot set reader function: batched reader function already set");
            Preconditions.checkArgument((this.readerFuncWithSchema == null ? 1 : 0) != 0, (Object)"Cannot set reader function: 2-argument reader function already set");
            this.readerFunc = newReaderFunction;
            return this;
        }

        public ReadBuilder createReaderFunc(BiFunction<Schema, MessageType, ParquetValueReader<?>> newReaderFunction) {
            Preconditions.checkArgument((this.readerFunc == null ? 1 : 0) != 0, (Object)"Cannot set 2-argument reader function: reader function already set");
            Preconditions.checkArgument((this.batchedReaderFunc == null ? 1 : 0) != 0, (Object)"Cannot set 2-argument reader function: batched reader function already set");
            this.readerFuncWithSchema = newReaderFunction;
            return this;
        }

        public ReadBuilder createBatchedReaderFunc(Function<MessageType, VectorizedReader<?>> func) {
            Preconditions.checkArgument((this.readerFunc == null ? 1 : 0) != 0, (Object)"Cannot set batched reader function: reader function already set");
            Preconditions.checkArgument((this.readerFuncWithSchema == null ? 1 : 0) != 0, (Object)"Cannot set batched reader function: 2-argument reader function already set");
            this.batchedReaderFunc = func;
            return this;
        }

        public ReadBuilder set(String key, String value) {
            this.properties.put(key, value);
            return this;
        }

        @Deprecated
        public ReadBuilder callInit() {
            this.callInit = true;
            return this;
        }

        public ReadBuilder reuseContainers() {
            this.reuseContainers = true;
            return this;
        }

        public ReadBuilder recordsPerBatch(int numRowsPerBatch) {
            this.maxRecordsPerBatch = numRowsPerBatch;
            return this;
        }

        public ReadBuilder withNameMapping(NameMapping newNameMapping) {
            this.nameMapping = newNameMapping;
            return this;
        }

        public ReadBuilder setRootType(Class<? extends StructLike> rootClass) {
            throw new UnsupportedOperationException("Custom types are not yet supported");
        }

        public ReadBuilder setCustomType(int fieldId, Class<? extends StructLike> structClass) {
            throw new UnsupportedOperationException("Custom types are not yet supported");
        }

        public ReadBuilder withFileEncryptionKey(ByteBuffer encryptionKey) {
            this.fileEncryptionKey = encryptionKey;
            return this;
        }

        public ReadBuilder withAADPrefix(ByteBuffer aadPrefix) {
            this.fileAADPrefix = aadPrefix;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public <D> CloseableIterable<D> build() {
            FileDecryptionProperties fileDecryptionProperties = null;
            if (this.fileEncryptionKey != null) {
                byte[] encryptionKeyArray = ByteBuffers.toByteArray((ByteBuffer)this.fileEncryptionKey);
                byte[] aadPrefixArray = ByteBuffers.toByteArray((ByteBuffer)this.fileAADPrefix);
                fileDecryptionProperties = FileDecryptionProperties.builder().withFooterKey(encryptionKeyArray).withAADPrefix(aadPrefixArray).build();
            } else {
                Preconditions.checkState((this.fileAADPrefix == null ? 1 : 0) != 0, (Object)"AAD prefix set with null encryption key");
            }
            if (this.readerFunc != null || this.readerFuncWithSchema != null || this.batchedReaderFunc != null) {
                void var4_10;
                ParquetReadOptions.Builder optionsBuilder;
                if (this.file instanceof HadoopInputFile) {
                    Configuration conf = new Configuration(((HadoopInputFile)this.file).getConf());
                    for (String property : READ_PROPERTIES_TO_REMOVE) {
                        conf.unset(property);
                    }
                    optionsBuilder = HadoopReadOptions.builder((Configuration)conf);
                } else {
                    optionsBuilder = ParquetReadOptions.builder((ParquetConfiguration)new PlainParquetConfiguration());
                }
                for (Map.Entry entry : this.properties.entrySet()) {
                    optionsBuilder.set((String)entry.getKey(), (String)entry.getValue());
                }
                if (this.start != null) {
                    optionsBuilder.withRange(this.start.longValue(), this.start + this.length);
                }
                if (fileDecryptionProperties != null) {
                    optionsBuilder.withDecryption(fileDecryptionProperties);
                }
                ParquetReadOptions options = optionsBuilder.build();
                if (this.nameMapping != null) {
                    NameMapping nameMapping = this.nameMapping;
                } else if (((Boolean)SystemConfigs.NETFLIX_UNSAFE_PARQUET_ID_FALLBACK_ENABLED.value()).booleanValue()) {
                    Object var4_8 = null;
                } else {
                    NameMapping nameMapping = NameMapping.empty();
                }
                if (this.batchedReaderFunc != null) {
                    return new VectorizedParquetReader(this.file, this.schema, options, this.batchedReaderFunc, (NameMapping)var4_10, this.filter, this.reuseContainers, this.caseSensitive, this.maxRecordsPerBatch);
                }
                Function<MessageType, ParquetValueReader<?>> readBuilder = this.readerFuncWithSchema != null ? fileType -> this.readerFuncWithSchema.apply(this.schema, (MessageType)fileType) : this.readerFunc;
                return new ParquetReader(this.file, this.schema, options, readBuilder, (NameMapping)var4_10, this.filter, this.reuseContainers, this.caseSensitive);
            }
            ParquetReadBuilder builder = new ParquetReadBuilder(ParquetIO.file(this.file));
            builder.project(this.schema);
            if (this.readSupport != null) {
                builder.readSupport(this.readSupport);
            } else {
                builder.readSupport(new AvroReadSupport(ParquetAvro.DEFAULT_MODEL));
            }
            builder.set("parquet.strict.typing", "false").set("parquet.avro.compatible", "false").set("parquet.avro.add-list-element-records", "false");
            for (Map.Entry entry : this.properties.entrySet()) {
                builder.set((String)entry.getKey(), (String)entry.getValue());
            }
            if (this.filter != null) {
                MessageType messageType;
                ParquetReadOptions decryptOptions = ParquetReadOptions.builder((ParquetConfiguration)new PlainParquetConfiguration()).withDecryption(fileDecryptionProperties).build();
                try (ParquetFileReader schemaReader = ParquetFileReader.open((InputFile)ParquetIO.file(this.file), (ParquetReadOptions)decryptOptions);){
                    messageType = schemaReader.getFileMetaData().getSchema();
                }
                catch (IOException e) {
                    throw new RuntimeIOException(e);
                }
                Schema fileSchema = ParquetSchemaUtil.convert(messageType);
                builder.useStatsFilter().useDictionaryFilter().useRecordFilter(this.filterRecords).useBloomFilter().withFilter(ParquetFilters.convert(fileSchema, this.filter, this.caseSensitive));
            } else {
                builder.useStatsFilter(false).useDictionaryFilter(false).useBloomFilter(false).useRecordFilter(false);
            }
            if (this.callInit) {
                builder.callInit();
            }
            if (this.start != null) {
                builder.withFileRange(this.start, this.start + this.length);
            }
            if (this.nameMapping != null) {
                builder.withNameMapping(this.nameMapping);
            }
            if (fileDecryptionProperties != null) {
                builder.withDecryption(fileDecryptionProperties);
            }
            return new ParquetIterable(builder);
        }
    }

    private static class ParquetWriteBuilder<T>
    extends ParquetWriter.Builder<T, ParquetWriteBuilder<T>> {
        private Map<String, String> keyValueMetadata = Maps.newHashMap();
        private Map<String, String> config = Maps.newHashMap();
        private MessageType type;
        private WriteSupport<T> writeSupport;

        private ParquetWriteBuilder(OutputFile path) {
            super(path);
        }

        protected ParquetWriteBuilder<T> self() {
            return this;
        }

        public ParquetWriteBuilder<T> setKeyValueMetadata(Map<String, String> keyValueMetadata) {
            this.keyValueMetadata = keyValueMetadata;
            return this.self();
        }

        public ParquetWriteBuilder<T> setConfig(Map<String, String> config) {
            this.config = config;
            return this.self();
        }

        public ParquetWriteBuilder<T> setType(MessageType type) {
            this.type = type;
            return this.self();
        }

        public ParquetWriteBuilder<T> setWriteSupport(WriteSupport<T> writeSupport) {
            this.writeSupport = writeSupport;
            return this.self();
        }

        protected WriteSupport<T> getWriteSupport(Configuration configuration) {
            for (Map.Entry<String, String> entry : this.config.entrySet()) {
                configuration.set(entry.getKey(), entry.getValue());
            }
            return new ParquetWriteSupport<T>(this.type, this.keyValueMetadata, this.writeSupport);
        }
    }

    public static class DeleteWriteBuilder {
        private final WriteBuilder appenderBuilder;
        private final String location;
        private BiFunction<Schema, MessageType, ParquetValueWriter<?>> createWriterFunc = null;
        private Schema rowSchema = null;
        private PartitionSpec spec = null;
        private StructLike partition = null;
        private EncryptionKeyMetadata keyMetadata = null;
        private int[] equalityFieldIds = null;
        private SortOrder sortOrder;
        private Function<CharSequence, ?> pathTransformFunc = Function.identity();

        private DeleteWriteBuilder(org.apache.iceberg.io.OutputFile file) {
            this.appenderBuilder = Parquet.write(file);
            this.location = file.location();
        }

        public DeleteWriteBuilder forTable(Table table) {
            this.rowSchema(table.schema());
            this.withSpec(table.spec());
            this.setAll(table.properties());
            this.metricsConfig(MetricsConfig.forTable((Table)table));
            return this;
        }

        public DeleteWriteBuilder set(String property, String value) {
            this.appenderBuilder.set(property, value);
            return this;
        }

        public DeleteWriteBuilder setAll(Map<String, String> properties) {
            this.appenderBuilder.setAll(properties);
            return this;
        }

        public DeleteWriteBuilder meta(String property, String value) {
            this.appenderBuilder.meta(property, value);
            return this;
        }

        public DeleteWriteBuilder overwrite() {
            return this.overwrite(true);
        }

        public DeleteWriteBuilder overwrite(boolean enabled) {
            this.appenderBuilder.overwrite(enabled);
            return this;
        }

        public DeleteWriteBuilder metricsConfig(MetricsConfig newMetricsConfig) {
            this.appenderBuilder.metricsConfig(newMetricsConfig);
            return this;
        }

        public DeleteWriteBuilder createWriterFunc(Function<MessageType, ParquetValueWriter<?>> newCreateWriterFunc) {
            this.createWriterFunc = (ignored, fileSchema) -> (ParquetValueWriter)newCreateWriterFunc.apply((MessageType)fileSchema);
            return this;
        }

        public DeleteWriteBuilder createWriterFunc(BiFunction<Schema, MessageType, ParquetValueWriter<?>> newCreateWriterFunc) {
            this.createWriterFunc = newCreateWriterFunc;
            return this;
        }

        public DeleteWriteBuilder rowSchema(Schema newSchema) {
            this.rowSchema = newSchema;
            return this;
        }

        public DeleteWriteBuilder withSpec(PartitionSpec newSpec) {
            this.spec = newSpec;
            return this;
        }

        public DeleteWriteBuilder withPartition(StructLike key) {
            this.partition = key;
            return this;
        }

        public DeleteWriteBuilder withKeyMetadata(EncryptionKeyMetadata metadata) {
            this.keyMetadata = metadata;
            return this;
        }

        public DeleteWriteBuilder withFileEncryptionKey(ByteBuffer fileEncryptionKey) {
            this.appenderBuilder.withFileEncryptionKey(fileEncryptionKey);
            return this;
        }

        public DeleteWriteBuilder withAADPrefix(ByteBuffer aadPrefix) {
            this.appenderBuilder.withAADPrefix(aadPrefix);
            return this;
        }

        public DeleteWriteBuilder equalityFieldIds(List<Integer> fieldIds) {
            this.equalityFieldIds = ArrayUtil.toIntArray(fieldIds);
            return this;
        }

        public DeleteWriteBuilder equalityFieldIds(int ... fieldIds) {
            this.equalityFieldIds = fieldIds;
            return this;
        }

        public DeleteWriteBuilder transformPaths(Function<CharSequence, ?> newPathTransformFunc) {
            this.pathTransformFunc = newPathTransformFunc;
            return this;
        }

        public DeleteWriteBuilder withSortOrder(SortOrder newSortOrder) {
            this.sortOrder = newSortOrder;
            return this;
        }

        public <T> EqualityDeleteWriter<T> buildEqualityWriter() throws IOException {
            Preconditions.checkState((this.rowSchema != null ? 1 : 0) != 0, (Object)"Cannot create equality delete file without a schema");
            Preconditions.checkState((this.equalityFieldIds != null ? 1 : 0) != 0, (Object)"Cannot create equality delete file without delete field ids");
            Preconditions.checkState((this.createWriterFunc != null ? 1 : 0) != 0, (Object)"Cannot create equality delete file unless createWriterFunc is set");
            Preconditions.checkArgument((this.spec != null ? 1 : 0) != 0, (Object)"Spec must not be null when creating equality delete writer");
            Preconditions.checkArgument((this.spec.isUnpartitioned() || this.partition != null ? 1 : 0) != 0, (Object)"Partition must not be null for partitioned writes");
            this.meta("delete-type", "equality");
            this.meta("delete-field-ids", IntStream.of(this.equalityFieldIds).mapToObj(Objects::toString).collect(Collectors.joining(", ")));
            this.appenderBuilder.schema(this.rowSchema);
            this.appenderBuilder.createWriterFunc(this.createWriterFunc);
            this.appenderBuilder.createContextFunc(WriteBuilder.Context::deleteContext);
            return new EqualityDeleteWriter(this.appenderBuilder.build(), FileFormat.PARQUET, this.location, this.spec, this.partition, this.keyMetadata, this.sortOrder, this.equalityFieldIds);
        }

        public <T> PositionDeleteWriter<T> buildPositionWriter() throws IOException {
            Preconditions.checkState((this.equalityFieldIds == null ? 1 : 0) != 0, (Object)"Cannot create position delete file using delete field ids");
            Preconditions.checkArgument((this.spec != null ? 1 : 0) != 0, (Object)"Spec must not be null when creating position delete writer");
            Preconditions.checkArgument((this.spec.isUnpartitioned() || this.partition != null ? 1 : 0) != 0, (Object)"Partition must not be null for partitioned writes");
            Preconditions.checkArgument((this.rowSchema == null || this.createWriterFunc != null ? 1 : 0) != 0, (Object)"Create function should be provided if we write row data");
            this.meta("delete-type", "position");
            if (this.rowSchema != null && this.createWriterFunc != null) {
                this.appenderBuilder.schema(DeleteSchemaUtil.posDeleteSchema((Schema)this.rowSchema));
                this.appenderBuilder.createWriterFunc((Schema schema, MessageType parquetSchema) -> {
                    ParquetValueWriter<?> writer = this.createWriterFunc.apply((Schema)schema, (MessageType)parquetSchema);
                    if (writer instanceof ParquetValueWriters.StructWriter) {
                        return new ParquetValueWriters.PositionDeleteStructWriter((ParquetValueWriters.StructWriter)writer, this.pathTransformFunc);
                    }
                    throw new UnsupportedOperationException("Cannot wrap writer for position deletes: " + writer.getClass());
                });
            } else {
                this.appenderBuilder.schema(DeleteSchemaUtil.pathPosSchema());
                this.appenderBuilder.createWriterFunc((Schema schema, MessageType parquetSchema) -> new ParquetValueWriters.PositionDeleteStructWriter((ParquetValueWriters.StructWriter)GenericParquetWriter.create(schema, parquetSchema), Function.identity()));
            }
            this.appenderBuilder.createContextFunc(WriteBuilder.Context::deleteContext);
            return new PositionDeleteWriter(this.appenderBuilder.build(), FileFormat.PARQUET, this.location, this.spec, this.partition, this.keyMetadata);
        }
    }

    public static class DataWriteBuilder {
        private final WriteBuilder appenderBuilder;
        private final String location;
        private PartitionSpec spec = null;
        private StructLike partition = null;
        private EncryptionKeyMetadata keyMetadata = null;
        private SortOrder sortOrder = null;

        private DataWriteBuilder(org.apache.iceberg.io.OutputFile file) {
            this.appenderBuilder = Parquet.write(file);
            this.location = file.location();
        }

        public DataWriteBuilder forTable(Table table) {
            this.schema(table.schema());
            this.withSpec(table.spec());
            this.setAll(table.properties());
            this.metricsConfig(MetricsConfig.forTable((Table)table));
            return this;
        }

        public DataWriteBuilder schema(Schema newSchema) {
            this.appenderBuilder.schema(newSchema);
            return this;
        }

        public DataWriteBuilder set(String property, String value) {
            this.appenderBuilder.set(property, value);
            return this;
        }

        public DataWriteBuilder setAll(Map<String, String> properties) {
            this.appenderBuilder.setAll(properties);
            return this;
        }

        public DataWriteBuilder meta(String property, String value) {
            this.appenderBuilder.meta(property, value);
            return this;
        }

        public DataWriteBuilder overwrite() {
            return this.overwrite(true);
        }

        public DataWriteBuilder overwrite(boolean enabled) {
            this.appenderBuilder.overwrite(enabled);
            return this;
        }

        public DataWriteBuilder metricsConfig(MetricsConfig newMetricsConfig) {
            this.appenderBuilder.metricsConfig(newMetricsConfig);
            return this;
        }

        public DataWriteBuilder createWriterFunc(Function<MessageType, ParquetValueWriter<?>> newCreateWriterFunc) {
            this.appenderBuilder.createWriterFunc(newCreateWriterFunc);
            return this;
        }

        public DataWriteBuilder createWriterFunc(BiFunction<Schema, MessageType, ParquetValueWriter<?>> newCreateWriterFunc) {
            this.appenderBuilder.createWriterFunc(newCreateWriterFunc);
            return this;
        }

        public DataWriteBuilder withSpec(PartitionSpec newSpec) {
            this.spec = newSpec;
            return this;
        }

        public DataWriteBuilder withPartition(StructLike newPartition) {
            this.partition = newPartition;
            return this;
        }

        public DataWriteBuilder withKeyMetadata(EncryptionKeyMetadata metadata) {
            this.keyMetadata = metadata;
            return this;
        }

        public DataWriteBuilder withFileEncryptionKey(ByteBuffer fileEncryptionKey) {
            this.appenderBuilder.withFileEncryptionKey(fileEncryptionKey);
            return this;
        }

        public DataWriteBuilder withAADPrefix(ByteBuffer aadPrefix) {
            this.appenderBuilder.withAADPrefix(aadPrefix);
            return this;
        }

        public DataWriteBuilder withSortOrder(SortOrder newSortOrder) {
            this.sortOrder = newSortOrder;
            return this;
        }

        public <T> DataWriter<T> build() throws IOException {
            Preconditions.checkArgument((this.spec != null ? 1 : 0) != 0, (Object)"Cannot create data writer without spec");
            Preconditions.checkArgument((this.spec.isUnpartitioned() || this.partition != null ? 1 : 0) != 0, (Object)"Partition must not be null when creating data writer for partitioned spec");
            FileAppender fileAppender = this.appenderBuilder.build();
            return new DataWriter(fileAppender, FileFormat.PARQUET, this.location, this.spec, this.partition, this.keyMetadata, this.sortOrder);
        }
    }

    public static class WriteBuilder
    implements InternalData.WriteBuilder {
        private final org.apache.iceberg.io.OutputFile file;
        private final Configuration conf;
        private final Map<String, String> metadata = Maps.newLinkedHashMap();
        private final Map<String, String> config = Maps.newLinkedHashMap();
        private Schema schema = null;
        private VariantShreddingFunction variantShreddingFunc = null;
        private String name = "table";
        private WriteSupport<?> writeSupport = null;
        private BiFunction<Schema, MessageType, ParquetValueWriter<?>> createWriterFunc = null;
        private MetricsConfig metricsConfig = MetricsConfig.getDefault();
        private ParquetFileWriter.Mode writeMode = ParquetFileWriter.Mode.CREATE;
        private ParquetProperties.WriterVersion writerVersion = ParquetProperties.WriterVersion.PARQUET_1_0;
        private Function<Map<String, String>, Context> createContextFunc = Context::dataContext;
        private ByteBuffer fileEncryptionKey = null;
        private ByteBuffer fileAADPrefix = null;

        private WriteBuilder(org.apache.iceberg.io.OutputFile file) {
            this.file = file;
            this.conf = file instanceof HadoopOutputFile ? new Configuration(((HadoopOutputFile)file).getConf()) : new Configuration();
        }

        public WriteBuilder forTable(Table table) {
            this.schema(table.schema());
            this.setAll(table.properties());
            this.metricsConfig(MetricsConfig.forTable((Table)table));
            return this;
        }

        public WriteBuilder schema(Schema newSchema) {
            this.schema = newSchema;
            return this;
        }

        public WriteBuilder variantShreddingFunc(VariantShreddingFunction func) {
            this.variantShreddingFunc = func;
            return this;
        }

        public WriteBuilder named(String newName) {
            this.name = newName;
            return this;
        }

        public WriteBuilder writeSupport(WriteSupport<?> newWriteSupport) {
            this.writeSupport = newWriteSupport;
            return this;
        }

        public WriteBuilder set(String property, String value) {
            this.config.put(property, value);
            return this;
        }

        public WriteBuilder setAll(Map<String, String> properties) {
            this.config.putAll(properties);
            return this;
        }

        public WriteBuilder meta(String property, String value) {
            this.metadata.put(property, value);
            return this;
        }

        public WriteBuilder createWriterFunc(Function<MessageType, ParquetValueWriter<?>> newCreateWriterFunc) {
            if (newCreateWriterFunc != null) {
                this.createWriterFunc = (icebergSchema, type) -> (ParquetValueWriter)newCreateWriterFunc.apply((MessageType)type);
            }
            return this;
        }

        public WriteBuilder createWriterFunc(BiFunction<Schema, MessageType, ParquetValueWriter<?>> newCreateWriterFunc) {
            this.createWriterFunc = newCreateWriterFunc;
            return this;
        }

        public WriteBuilder metricsConfig(MetricsConfig newMetricsConfig) {
            this.metricsConfig = newMetricsConfig;
            return this;
        }

        public WriteBuilder overwrite() {
            return this.overwrite(true);
        }

        public WriteBuilder overwrite(boolean enabled) {
            this.writeMode = enabled ? ParquetFileWriter.Mode.OVERWRITE : ParquetFileWriter.Mode.CREATE;
            return this;
        }

        public WriteBuilder writerVersion(ParquetProperties.WriterVersion version) {
            this.writerVersion = version;
            return this;
        }

        public WriteBuilder withFileEncryptionKey(ByteBuffer encryptionKey) {
            this.fileEncryptionKey = encryptionKey;
            return this;
        }

        public WriteBuilder withAADPrefix(ByteBuffer aadPrefix) {
            this.fileAADPrefix = aadPrefix;
            return this;
        }

        private <T> WriteSupport<T> getWriteSupport(MessageType type) {
            if (this.writeSupport != null) {
                return this.writeSupport;
            }
            return new AvroWriteSupport(type, ParquetAvro.parquetAvroSchema(AvroSchemaUtil.convert((Schema)this.schema, (String)this.name)), ParquetAvro.DEFAULT_MODEL);
        }

        @VisibleForTesting
        WriteBuilder withWriterVersion(ParquetProperties.WriterVersion version) {
            this.writerVersion = version;
            return this;
        }

        private WriteBuilder createContextFunc(Function<Map<String, String>, Context> newCreateContextFunc) {
            this.createContextFunc = newCreateContextFunc;
            return this;
        }

        private void setBloomFilterConfig(Context context, MessageType parquetSchema, BiConsumer<String, Boolean> withBloomFilterEnabled, BiConsumer<String, Double> withBloomFilterFPP) {
            Map<Integer, String> fieldIdToParquetPath = parquetSchema.getColumns().stream().filter(col -> col.getPrimitiveType().getId() != null).collect(Collectors.toMap(col -> col.getPrimitiveType().getId().intValue(), col -> String.join((CharSequence)".", col.getPath())));
            context.columnBloomFilterEnabled().forEach((colPath, isEnabled) -> {
                Types.NestedField fieldId = this.schema.findField(colPath);
                if (fieldId == null) {
                    LOG.warn("Skipping bloom filter config for missing field: {}", colPath);
                    return;
                }
                String parquetColumnPath = (String)fieldIdToParquetPath.get(fieldId.fieldId());
                if (parquetColumnPath == null) {
                    LOG.warn("Skipping bloom filter config for missing field: {}", (Object)fieldId);
                    return;
                }
                withBloomFilterEnabled.accept(parquetColumnPath, Boolean.valueOf(isEnabled));
                String fpp = context.columnBloomFilterFpp().get(colPath);
                if (fpp != null) {
                    withBloomFilterFPP.accept(parquetColumnPath, Double.parseDouble(fpp));
                }
            });
        }

        public <D> FileAppender<D> build() throws IOException {
            Object encryptionKeyArray;
            Preconditions.checkNotNull((Object)this.schema, (Object)"Schema is required");
            Preconditions.checkNotNull((Object)this.name, (Object)"Table name is required and cannot be null");
            this.meta("iceberg.schema", SchemaParser.toJson((Schema)this.schema));
            Context context = this.createContextFunc.apply(this.config);
            int rowGroupSize = context.rowGroupSize();
            int pageSize = context.pageSize();
            int pageRowLimit = context.pageRowLimit();
            int dictionaryPageSize = context.dictionaryPageSize();
            String compressionLevel = context.compressionLevel();
            CompressionCodecName codec = context.codec();
            int rowGroupCheckMinRecordCount = context.rowGroupCheckMinRecordCount();
            int rowGroupCheckMaxRecordCount = context.rowGroupCheckMaxRecordCount();
            int bloomFilterMaxBytes = context.bloomFilterMaxBytes();
            boolean dictionaryEnabled = context.dictionaryEnabled();
            if (compressionLevel != null) {
                switch (codec) {
                    case GZIP: {
                        this.config.put("zlib.compress.level", compressionLevel);
                        break;
                    }
                    case BROTLI: {
                        this.config.put("compression.brotli.quality", compressionLevel);
                        break;
                    }
                    case ZSTD: {
                        this.config.put("io.compression.codec.zstd.level", compressionLevel);
                        this.config.put("parquet.compression.codec.zstd.level", compressionLevel);
                        break;
                    }
                }
            }
            this.set("parquet.avro.write-old-list-structure", "false");
            MessageType type = ParquetSchemaUtil.convert(this.schema, this.name, this.variantShreddingFunc);
            FileEncryptionProperties fileEncryptionProperties = null;
            if (this.fileEncryptionKey != null) {
                encryptionKeyArray = ByteBuffers.toByteArray((ByteBuffer)this.fileEncryptionKey);
                byte[] aadPrefixArray = ByteBuffers.toByteArray((ByteBuffer)this.fileAADPrefix);
                fileEncryptionProperties = FileEncryptionProperties.builder((byte[])encryptionKeyArray).withAADPrefix(aadPrefixArray).withoutAADPrefixStorage().build();
            } else {
                Preconditions.checkState((this.fileAADPrefix == null ? 1 : 0) != 0, (Object)"AAD prefix set with null encryption key");
            }
            if (this.createWriterFunc != null) {
                Preconditions.checkArgument((this.writeSupport == null ? 1 : 0) != 0, (Object)"Cannot write with both write support and Parquet value writer");
                encryptionKeyArray = this.config.entrySet().iterator();
                while (encryptionKeyArray.hasNext()) {
                    Map.Entry entry = (Map.Entry)encryptionKeyArray.next();
                    this.conf.set((String)entry.getKey(), (String)entry.getValue());
                }
                ParquetProperties.Builder propsBuilder = ParquetProperties.builder().withWriterVersion(this.writerVersion).withPageSize(pageSize).withPageRowCountLimit(pageRowLimit).withDictionaryEncoding(dictionaryEnabled).withDictionaryPageSize(dictionaryPageSize).withMinRowCountForPageSizeCheck(rowGroupCheckMinRecordCount).withMaxRowCountForPageSizeCheck(rowGroupCheckMaxRecordCount).withMaxBloomFilterBytes(bloomFilterMaxBytes);
                this.setBloomFilterConfig(context, type, (arg_0, arg_1) -> ((ParquetProperties.Builder)propsBuilder).withBloomFilterEnabled(arg_0, arg_1), (arg_0, arg_1) -> ((ParquetProperties.Builder)propsBuilder).withBloomFilterFPP(arg_0, arg_1));
                ParquetProperties parquetProperties = propsBuilder.build();
                return new ParquetWriter(this.conf, this.file, this.schema, type, rowGroupSize, this.metadata, this.createWriterFunc, codec, parquetProperties, this.metricsConfig, this.writeMode, fileEncryptionProperties);
            }
            ParquetWriteBuilder parquetWriteBuilder = (ParquetWriteBuilder)((ParquetWriteBuilder)((ParquetWriteBuilder)((ParquetWriteBuilder)((ParquetWriteBuilder)((ParquetWriteBuilder)((ParquetWriteBuilder)((ParquetWriteBuilder)((ParquetWriteBuilder)new ParquetWriteBuilder(ParquetIO.file(this.file)).withWriterVersion(this.writerVersion)).setType(type).setConfig(this.config).setKeyValueMetadata(this.metadata).setWriteSupport(this.getWriteSupport(type)).withCompressionCodec(codec)).withWriteMode(this.writeMode)).withRowGroupSize(rowGroupSize)).withPageSize(pageSize)).withPageRowCountLimit(pageRowLimit)).withDictionaryEncoding(dictionaryEnabled)).withDictionaryPageSize(dictionaryPageSize)).withEncryption(fileEncryptionProperties);
            this.setBloomFilterConfig(context, type, (arg_0, arg_1) -> ((ParquetWriteBuilder)parquetWriteBuilder).withBloomFilterEnabled(arg_0, arg_1), (arg_0, arg_1) -> ((ParquetWriteBuilder)parquetWriteBuilder).withBloomFilterFPP(arg_0, arg_1));
            return new ParquetWriteAdapter(parquetWriteBuilder.build(), this.metricsConfig);
        }

        private static class Context {
            private final int rowGroupSize;
            private final int pageSize;
            private final int pageRowLimit;
            private final int dictionaryPageSize;
            private final CompressionCodecName codec;
            private final String compressionLevel;
            private final int rowGroupCheckMinRecordCount;
            private final int rowGroupCheckMaxRecordCount;
            private final int bloomFilterMaxBytes;
            private final Map<String, String> columnBloomFilterFpp;
            private final Map<String, String> columnBloomFilterEnabled;
            private final boolean dictionaryEnabled;

            private Context(int rowGroupSize, int pageSize, int pageRowLimit, int dictionaryPageSize, CompressionCodecName codec, String compressionLevel, int rowGroupCheckMinRecordCount, int rowGroupCheckMaxRecordCount, int bloomFilterMaxBytes, Map<String, String> columnBloomFilterFpp, Map<String, String> columnBloomFilterEnabled, boolean dictionaryEnabled) {
                this.rowGroupSize = rowGroupSize;
                this.pageSize = pageSize;
                this.pageRowLimit = pageRowLimit;
                this.dictionaryPageSize = dictionaryPageSize;
                this.codec = codec;
                this.compressionLevel = compressionLevel;
                this.rowGroupCheckMinRecordCount = rowGroupCheckMinRecordCount;
                this.rowGroupCheckMaxRecordCount = rowGroupCheckMaxRecordCount;
                this.bloomFilterMaxBytes = bloomFilterMaxBytes;
                this.columnBloomFilterFpp = columnBloomFilterFpp;
                this.columnBloomFilterEnabled = columnBloomFilterEnabled;
                this.dictionaryEnabled = dictionaryEnabled;
            }

            static Context dataContext(Map<String, String> config) {
                int rowGroupSize = PropertyUtil.propertyAsInt(config, (String)"write.parquet.row-group-size-bytes", (int)0x8000000);
                Preconditions.checkArgument((rowGroupSize > 0 ? 1 : 0) != 0, (Object)"Row group size must be > 0");
                int pageSize = PropertyUtil.propertyAsInt(config, (String)"write.parquet.page-size-bytes", (int)0x100000);
                Preconditions.checkArgument((pageSize > 0 ? 1 : 0) != 0, (Object)"Page size must be > 0");
                int pageRowLimit = PropertyUtil.propertyAsInt(config, (String)"write.parquet.page-row-limit", (int)20000);
                Preconditions.checkArgument((pageRowLimit > 0 ? 1 : 0) != 0, (Object)"Page row count limit must be > 0");
                int dictionaryPageSize = PropertyUtil.propertyAsInt(config, (String)"write.parquet.dict-size-bytes", (int)0x200000);
                Preconditions.checkArgument((dictionaryPageSize > 0 ? 1 : 0) != 0, (Object)"Dictionary page size must be > 0");
                String codecAsString = config.getOrDefault("write.parquet.compression-codec", "gzip");
                CompressionCodecName codec = Context.toCodec(codecAsString);
                String compressionLevel = config.getOrDefault("write.parquet.compression-level", TableProperties.PARQUET_COMPRESSION_LEVEL_DEFAULT);
                int rowGroupCheckMinRecordCount = PropertyUtil.propertyAsInt(config, (String)"write.parquet.row-group-check-min-record-count", (int)100);
                Preconditions.checkArgument((rowGroupCheckMinRecordCount > 0 ? 1 : 0) != 0, (Object)"Row group check minimal record count must be > 0");
                int rowGroupCheckMaxRecordCount = PropertyUtil.propertyAsInt(config, (String)"write.parquet.row-group-check-max-record-count", (int)10000);
                Preconditions.checkArgument((rowGroupCheckMaxRecordCount > 0 ? 1 : 0) != 0, (Object)"Row group check maximum record count must be > 0");
                Preconditions.checkArgument((rowGroupCheckMaxRecordCount >= rowGroupCheckMinRecordCount ? 1 : 0) != 0, (Object)"Row group check maximum record count must be >= minimal record count");
                int bloomFilterMaxBytes = PropertyUtil.propertyAsInt(config, (String)"write.parquet.bloom-filter-max-bytes", (int)0x100000);
                Preconditions.checkArgument((bloomFilterMaxBytes > 0 ? 1 : 0) != 0, (Object)"bloom Filter Max Bytes must be > 0");
                Map columnBloomFilterFpp = PropertyUtil.propertiesWithPrefix(config, (String)"write.parquet.bloom-filter-fpp.column.");
                Map columnBloomFilterEnabled = PropertyUtil.propertiesWithPrefix(config, (String)"write.parquet.bloom-filter-enabled.column.");
                boolean dictionaryEnabled = PropertyUtil.propertyAsBoolean(config, (String)"parquet.enable.dictionary", (boolean)true);
                return new Context(rowGroupSize, pageSize, pageRowLimit, dictionaryPageSize, codec, compressionLevel, rowGroupCheckMinRecordCount, rowGroupCheckMaxRecordCount, bloomFilterMaxBytes, columnBloomFilterFpp, columnBloomFilterEnabled, dictionaryEnabled);
            }

            static Context deleteContext(Map<String, String> config) {
                Context dataContext = Context.dataContext(config);
                int rowGroupSize = PropertyUtil.propertyAsInt(config, (String)"write.delete.parquet.row-group-size-bytes", (int)dataContext.rowGroupSize());
                Preconditions.checkArgument((rowGroupSize > 0 ? 1 : 0) != 0, (Object)"Row group size must be > 0");
                int pageSize = PropertyUtil.propertyAsInt(config, (String)"write.delete.parquet.page-size-bytes", (int)dataContext.pageSize());
                Preconditions.checkArgument((pageSize > 0 ? 1 : 0) != 0, (Object)"Page size must be > 0");
                int pageRowLimit = PropertyUtil.propertyAsInt(config, (String)"write.delete.parquet.page-row-limit", (int)dataContext.pageRowLimit());
                Preconditions.checkArgument((pageRowLimit > 0 ? 1 : 0) != 0, (Object)"Page row count limit must be > 0");
                int dictionaryPageSize = PropertyUtil.propertyAsInt(config, (String)"write.delete.parquet.dict-size-bytes", (int)dataContext.dictionaryPageSize());
                Preconditions.checkArgument((dictionaryPageSize > 0 ? 1 : 0) != 0, (Object)"Dictionary page size must be > 0");
                String codecAsString = config.get("write.delete.parquet.compression-codec");
                CompressionCodecName codec = codecAsString != null ? Context.toCodec(codecAsString) : dataContext.codec();
                String compressionLevel = config.getOrDefault("write.delete.parquet.compression-level", dataContext.compressionLevel());
                int rowGroupCheckMinRecordCount = PropertyUtil.propertyAsInt(config, (String)"write.delete.parquet.row-group-check-min-record-count", (int)dataContext.rowGroupCheckMinRecordCount());
                Preconditions.checkArgument((rowGroupCheckMinRecordCount > 0 ? 1 : 0) != 0, (Object)"Row group check minimal record count must be > 0");
                int rowGroupCheckMaxRecordCount = PropertyUtil.propertyAsInt(config, (String)"write.delete.parquet.row-group-check-max-record-count", (int)dataContext.rowGroupCheckMaxRecordCount());
                Preconditions.checkArgument((rowGroupCheckMaxRecordCount > 0 ? 1 : 0) != 0, (Object)"Row group check maximum record count must be > 0");
                Preconditions.checkArgument((rowGroupCheckMaxRecordCount >= rowGroupCheckMinRecordCount ? 1 : 0) != 0, (Object)"Row group check maximum record count must be >= minimal record count");
                boolean dictionaryEnabled = PropertyUtil.propertyAsBoolean(config, (String)"parquet.enable.dictionary", (boolean)true);
                return new Context(rowGroupSize, pageSize, pageRowLimit, dictionaryPageSize, codec, compressionLevel, rowGroupCheckMinRecordCount, rowGroupCheckMaxRecordCount, 0x100000, (Map<String, String>)ImmutableMap.of(), (Map<String, String>)ImmutableMap.of(), dictionaryEnabled);
            }

            private static CompressionCodecName toCodec(String codecAsString) {
                try {
                    return CompressionCodecName.valueOf((String)codecAsString.toUpperCase(Locale.ENGLISH));
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException("Unsupported compression codec: " + codecAsString);
                }
            }

            int rowGroupSize() {
                return this.rowGroupSize;
            }

            int pageSize() {
                return this.pageSize;
            }

            int pageRowLimit() {
                return this.pageRowLimit;
            }

            int dictionaryPageSize() {
                return this.dictionaryPageSize;
            }

            CompressionCodecName codec() {
                return this.codec;
            }

            String compressionLevel() {
                return this.compressionLevel;
            }

            int rowGroupCheckMinRecordCount() {
                return this.rowGroupCheckMinRecordCount;
            }

            int rowGroupCheckMaxRecordCount() {
                return this.rowGroupCheckMaxRecordCount;
            }

            int bloomFilterMaxBytes() {
                return this.bloomFilterMaxBytes;
            }

            Map<String, String> columnBloomFilterFpp() {
                return this.columnBloomFilterFpp;
            }

            Map<String, String> columnBloomFilterEnabled() {
                return this.columnBloomFilterEnabled;
            }

            boolean dictionaryEnabled() {
                return this.dictionaryEnabled;
            }
        }
    }
}

