/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.data.parquet;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.Schema;
import org.apache.iceberg.data.parquet.GenericParquetReaders;
import org.apache.iceberg.parquet.ParquetSchemaUtil;
import org.apache.iceberg.parquet.ParquetValueReader;
import org.apache.iceberg.parquet.ParquetValueReaders;
import org.apache.iceberg.parquet.TypeWithSchemaVisitor;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;

@Deprecated
public abstract class BaseParquetReaders<T> {
    protected BaseParquetReaders() {
    }

    protected ParquetValueReader<T> createReader(Schema expectedSchema, MessageType fileSchema) {
        return this.createReader(expectedSchema, fileSchema, (Map<Integer, ?>)ImmutableMap.of());
    }

    protected ParquetValueReader<T> createReader(Schema expectedSchema, MessageType fileSchema, Map<Integer, ?> idToConstant) {
        if (ParquetSchemaUtil.hasIds(fileSchema)) {
            return (ParquetValueReader)TypeWithSchemaVisitor.visit((Type)expectedSchema.asStruct(), (org.apache.parquet.schema.Type)fileSchema, new ReadBuilder(fileSchema, idToConstant));
        }
        return (ParquetValueReader)TypeWithSchemaVisitor.visit((Type)expectedSchema.asStruct(), (org.apache.parquet.schema.Type)fileSchema, new FallbackReadBuilder(fileSchema, idToConstant));
    }

    protected abstract ParquetValueReader<T> createStructReader(List<org.apache.parquet.schema.Type> var1, List<ParquetValueReader<?>> var2, Types.StructType var3);

    protected ParquetValueReader<?> fixedReader(ColumnDescriptor desc) {
        return new GenericParquetReaders.FixedReader(desc);
    }

    protected ParquetValueReader<?> dateReader(ColumnDescriptor desc) {
        return new GenericParquetReaders.DateReader(desc);
    }

    protected ParquetValueReader<?> timeReader(ColumnDescriptor desc) {
        LogicalTypeAnnotation time = desc.getPrimitiveType().getLogicalTypeAnnotation();
        Preconditions.checkArgument((boolean)(time instanceof LogicalTypeAnnotation.TimeLogicalTypeAnnotation), (Object)("Invalid time logical type: " + time));
        LogicalTypeAnnotation.TimeUnit unit = ((LogicalTypeAnnotation.TimeLogicalTypeAnnotation)time).getUnit();
        switch (unit) {
            case MICROS: {
                return new GenericParquetReaders.TimeReader(desc);
            }
            case MILLIS: {
                return new GenericParquetReaders.TimeMillisReader(desc);
            }
        }
        throw new UnsupportedOperationException("Unsupported unit for time: " + unit);
    }

    protected ParquetValueReader<?> timestampReader(ColumnDescriptor desc, boolean isAdjustedToUTC) {
        if (desc.getPrimitiveType().getPrimitiveTypeName() == PrimitiveType.PrimitiveTypeName.INT96) {
            return new GenericParquetReaders.TimestampInt96Reader(desc);
        }
        LogicalTypeAnnotation timestamp = desc.getPrimitiveType().getLogicalTypeAnnotation();
        Preconditions.checkArgument((boolean)(timestamp instanceof LogicalTypeAnnotation.TimestampLogicalTypeAnnotation), (Object)("Invalid timestamp logical type: " + timestamp));
        LogicalTypeAnnotation.TimeUnit unit = ((LogicalTypeAnnotation.TimestampLogicalTypeAnnotation)timestamp).getUnit();
        switch (unit) {
            case MICROS: {
                return isAdjustedToUTC ? new GenericParquetReaders.TimestamptzReader(desc) : new GenericParquetReaders.TimestampReader(desc);
            }
            case MILLIS: {
                return isAdjustedToUTC ? new GenericParquetReaders.TimestamptzMillisReader(desc) : new GenericParquetReaders.TimestampMillisReader(desc);
            }
        }
        throw new UnsupportedOperationException("Unsupported unit for timestamp: " + unit);
    }

    protected Object convertConstant(Type type, Object value) {
        return value;
    }

    private class ReadBuilder
    extends TypeWithSchemaVisitor<ParquetValueReader<?>> {
        private final MessageType type;
        private final Map<Integer, ?> idToConstant;

        private ReadBuilder(MessageType type, Map<Integer, ?> idToConstant) {
            this.type = type;
            this.idToConstant = idToConstant;
        }

        @Override
        public ParquetValueReader<?> message(Types.StructType expected, MessageType message, List<ParquetValueReader<?>> fieldReaders) {
            return this.struct(expected, message.asGroupType(), (List)fieldReaders);
        }

        @Override
        public ParquetValueReader<?> struct(Types.StructType expected, GroupType struct, List<ParquetValueReader<?>> fieldReaders) {
            HashMap readersById = Maps.newHashMap();
            HashMap typesById = Maps.newHashMap();
            HashMap maxDefinitionLevelsById = Maps.newHashMap();
            List fields = struct.getFields();
            for (int i = 0; i < fields.size(); ++i) {
                ParquetValueReader<?> fieldReader = fieldReaders.get(i);
                if (fieldReader == null) continue;
                org.apache.parquet.schema.Type fieldType = (org.apache.parquet.schema.Type)fields.get(i);
                int fieldD = this.type.getMaxDefinitionLevel(this.path(fieldType.getName())) - 1;
                int id = fieldType.getId().intValue();
                readersById.put(id, ParquetValueReaders.option(fieldType, fieldD, fieldReader));
                typesById.put(id, fieldType);
                if (!this.idToConstant.containsKey(id)) continue;
                maxDefinitionLevelsById.put(id, fieldD);
            }
            List expectedFields = expected != null ? expected.fields() : ImmutableList.of();
            ArrayList reorderedFields = Lists.newArrayListWithExpectedSize((int)expectedFields.size());
            ArrayList types = Lists.newArrayListWithExpectedSize((int)expectedFields.size());
            int defaultMaxDefinitionLevel = this.type.getMaxDefinitionLevel(this.currentPath());
            Iterator iterator = expectedFields.iterator();
            while (iterator.hasNext()) {
                Types.NestedField field = (Types.NestedField)iterator.next();
                int id = field.fieldId();
                ParquetValueReader reader = (ParquetValueReader)readersById.get(id);
                if (this.idToConstant.containsKey(id)) {
                    int fieldMaxDefinitionLevel = maxDefinitionLevelsById.getOrDefault(id, defaultMaxDefinitionLevel);
                    reorderedFields.add(ParquetValueReaders.constant(this.idToConstant.get(id), fieldMaxDefinitionLevel));
                    types.add(null);
                    continue;
                }
                if (id == MetadataColumns.ROW_POSITION.fieldId()) {
                    reorderedFields.add(ParquetValueReaders.position());
                    types.add(null);
                    continue;
                }
                if (id == MetadataColumns.IS_DELETED.fieldId()) {
                    reorderedFields.add(ParquetValueReaders.constant(false));
                    types.add(null);
                    continue;
                }
                if (reader != null) {
                    reorderedFields.add(reader);
                    types.add((org.apache.parquet.schema.Type)typesById.get(id));
                    continue;
                }
                if (field.initialDefault() != null) {
                    reorderedFields.add(ParquetValueReaders.constant(BaseParquetReaders.this.convertConstant(field.type(), field.initialDefault()), maxDefinitionLevelsById.getOrDefault(id, defaultMaxDefinitionLevel)));
                    types.add((org.apache.parquet.schema.Type)typesById.get(id));
                    continue;
                }
                if (field.isOptional()) {
                    reorderedFields.add(ParquetValueReaders.nulls());
                    types.add(null);
                    continue;
                }
                throw new IllegalArgumentException(String.format("Missing required field: %s", field.name()));
            }
            return BaseParquetReaders.this.createStructReader(types, reorderedFields, expected);
        }

        @Override
        public ParquetValueReader<?> list(Types.ListType expectedList, GroupType array, ParquetValueReader<?> elementReader) {
            if (expectedList == null) {
                return null;
            }
            String[] repeatedPath = this.currentPath();
            int repeatedD = this.type.getMaxDefinitionLevel(repeatedPath) - 1;
            int repeatedR = this.type.getMaxRepetitionLevel(repeatedPath) - 1;
            org.apache.parquet.schema.Type elementType = ParquetSchemaUtil.determineListElementType(array);
            int elementD = this.type.getMaxDefinitionLevel(this.path(elementType.getName())) - 1;
            return new ParquetValueReaders.ListReader(repeatedD, repeatedR, ParquetValueReaders.option(elementType, elementD, elementReader));
        }

        @Override
        public ParquetValueReader<?> map(Types.MapType expectedMap, GroupType map, ParquetValueReader<?> keyReader, ParquetValueReader<?> valueReader) {
            if (expectedMap == null) {
                return null;
            }
            GroupType repeatedKeyValue = ((org.apache.parquet.schema.Type)map.getFields().get(0)).asGroupType();
            String[] repeatedPath = this.currentPath();
            int repeatedD = this.type.getMaxDefinitionLevel(repeatedPath) - 1;
            int repeatedR = this.type.getMaxRepetitionLevel(repeatedPath) - 1;
            org.apache.parquet.schema.Type keyType = repeatedKeyValue.getType(0);
            int keyD = this.type.getMaxDefinitionLevel(this.path(keyType.getName())) - 1;
            org.apache.parquet.schema.Type valueType = repeatedKeyValue.getType(1);
            int valueD = this.type.getMaxDefinitionLevel(this.path(valueType.getName())) - 1;
            return new ParquetValueReaders.MapReader(repeatedD, repeatedR, ParquetValueReaders.option(keyType, keyD, keyReader), ParquetValueReaders.option(valueType, valueD, valueReader));
        }

        @Override
        public ParquetValueReader<?> primitive(Type.PrimitiveType expected, PrimitiveType primitive) {
            if (expected == null) {
                return null;
            }
            ColumnDescriptor desc = this.type.getColumnDescription(this.currentPath());
            if (primitive.getLogicalTypeAnnotation() != null) {
                return (ParquetValueReader)primitive.getLogicalTypeAnnotation().accept((LogicalTypeAnnotation.LogicalTypeAnnotationVisitor)new LogicalTypeReadBuilder(desc, expected)).orElseThrow(() -> new UnsupportedOperationException("Unsupported logical type: " + primitive.getLogicalTypeAnnotation()));
            }
            switch (primitive.getPrimitiveTypeName()) {
                case FIXED_LEN_BYTE_ARRAY: {
                    return BaseParquetReaders.this.fixedReader(desc);
                }
                case BINARY: {
                    if (expected.typeId() == Type.TypeID.STRING) {
                        return ParquetValueReaders.strings(desc);
                    }
                    return ParquetValueReaders.byteBuffers(desc);
                }
                case INT32: {
                    if (expected.typeId() == Type.TypeID.LONG) {
                        return ParquetValueReaders.intsAsLongs(desc);
                    }
                    return ParquetValueReaders.unboxed(desc);
                }
                case FLOAT: {
                    if (expected.typeId() == Type.TypeID.DOUBLE) {
                        return ParquetValueReaders.floatsAsDoubles(desc);
                    }
                    return ParquetValueReaders.unboxed(desc);
                }
                case BOOLEAN: 
                case INT64: 
                case DOUBLE: {
                    return ParquetValueReaders.unboxed(desc);
                }
                case INT96: {
                    return BaseParquetReaders.this.timestampReader(desc, true);
                }
            }
            throw new UnsupportedOperationException("Unsupported type: " + primitive);
        }

        MessageType type() {
            return this.type;
        }
    }

    private class LogicalTypeReadBuilder
    implements LogicalTypeAnnotation.LogicalTypeAnnotationVisitor<ParquetValueReader<?>> {
        private final ColumnDescriptor desc;
        private final Type.PrimitiveType expected;

        LogicalTypeReadBuilder(ColumnDescriptor desc, Type.PrimitiveType expected) {
            this.desc = desc;
            this.expected = expected;
        }

        public Optional<ParquetValueReader<?>> visit(LogicalTypeAnnotation.StringLogicalTypeAnnotation stringLogicalType) {
            return Optional.of(ParquetValueReaders.strings(this.desc));
        }

        public Optional<ParquetValueReader<?>> visit(LogicalTypeAnnotation.EnumLogicalTypeAnnotation enumLogicalType) {
            return Optional.of(ParquetValueReaders.strings(this.desc));
        }

        public Optional<ParquetValueReader<?>> visit(LogicalTypeAnnotation.DecimalLogicalTypeAnnotation decimalLogicalType) {
            return Optional.of(ParquetValueReaders.bigDecimals(this.desc));
        }

        public Optional<ParquetValueReader<?>> visit(LogicalTypeAnnotation.DateLogicalTypeAnnotation dateLogicalType) {
            return Optional.of(BaseParquetReaders.this.dateReader(this.desc));
        }

        public Optional<ParquetValueReader<?>> visit(LogicalTypeAnnotation.TimeLogicalTypeAnnotation timeLogicalType) {
            return Optional.of(BaseParquetReaders.this.timeReader(this.desc));
        }

        public Optional<ParquetValueReader<?>> visit(LogicalTypeAnnotation.TimestampLogicalTypeAnnotation timestampLogicalType) {
            return Optional.of(BaseParquetReaders.this.timestampReader(this.desc, ((Types.TimestampType)this.expected).shouldAdjustToUTC()));
        }

        public Optional<ParquetValueReader<?>> visit(LogicalTypeAnnotation.IntLogicalTypeAnnotation intLogicalType) {
            if (intLogicalType.getBitWidth() == 64) {
                Preconditions.checkArgument((boolean)intLogicalType.isSigned(), (Object)"Cannot read UINT64 as a long value");
                return Optional.of(new ParquetValueReaders.UnboxedReader(this.desc));
            }
            if (this.expected.typeId() == Type.TypeID.LONG) {
                return Optional.of(new ParquetValueReaders.IntAsLongReader(this.desc));
            }
            Preconditions.checkArgument((intLogicalType.isSigned() || intLogicalType.getBitWidth() < 32 ? 1 : 0) != 0, (Object)"Cannot read UINT32 as an int value");
            return Optional.of(new ParquetValueReaders.UnboxedReader(this.desc));
        }

        public Optional<ParquetValueReader<?>> visit(LogicalTypeAnnotation.JsonLogicalTypeAnnotation jsonLogicalType) {
            return Optional.of(ParquetValueReaders.strings(this.desc));
        }

        public Optional<ParquetValueReader<?>> visit(LogicalTypeAnnotation.BsonLogicalTypeAnnotation bsonLogicalType) {
            return Optional.of(ParquetValueReaders.byteBuffers(this.desc));
        }

        public Optional<ParquetValueReader<?>> visit(LogicalTypeAnnotation.UUIDLogicalTypeAnnotation uuidLogicalType) {
            return Optional.of(ParquetValueReaders.uuids(this.desc));
        }
    }

    private class FallbackReadBuilder
    extends ReadBuilder {
        private FallbackReadBuilder(MessageType type, Map<Integer, ?> idToConstant) {
            super(type, idToConstant);
        }

        @Override
        public ParquetValueReader<?> message(Types.StructType expected, MessageType message, List<ParquetValueReader<?>> fieldReaders) {
            return super.struct(expected, (GroupType)message, (List)fieldReaders);
        }

        @Override
        public ParquetValueReader<?> struct(Types.StructType expected, GroupType struct, List<ParquetValueReader<?>> fieldReaders) {
            ArrayList newFields = Lists.newArrayListWithExpectedSize((int)fieldReaders.size());
            ArrayList types = Lists.newArrayListWithExpectedSize((int)fieldReaders.size());
            List fields = struct.getFields();
            for (int i = 0; i < fields.size(); ++i) {
                ParquetValueReader<?> fieldReader = fieldReaders.get(i);
                if (fieldReader == null) continue;
                org.apache.parquet.schema.Type fieldType = (org.apache.parquet.schema.Type)fields.get(i);
                int fieldD = this.type().getMaxDefinitionLevel(this.path(fieldType.getName())) - 1;
                newFields.add(ParquetValueReaders.option(fieldType, fieldD, fieldReader));
                types.add(fieldType);
            }
            return BaseParquetReaders.this.createStructReader(types, newFields, expected);
        }
    }
}

