/*
 * Decompiled with CFR 0.152.
 */
package com.google.monitoring.v3;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.iceberg.gcp.shaded.com.google.common.base.Preconditions;
import org.apache.iceberg.gcp.shaded.com.google.common.collect.ImmutableMap;

public class UptimeCheckConfigName
implements ResourceName {
    private static final PathTemplate PROJECT_UPTIME_CHECK_CONFIG = PathTemplate.createWithoutUrlEncoding("projects/{project}/uptimeCheckConfigs/{uptime_check_config}");
    private static final PathTemplate ORGANIZATION_UPTIME_CHECK_CONFIG = PathTemplate.createWithoutUrlEncoding("organizations/{organization}/uptimeCheckConfigs/{uptime_check_config}");
    private static final PathTemplate FOLDER_UPTIME_CHECK_CONFIG = PathTemplate.createWithoutUrlEncoding("folders/{folder}/uptimeCheckConfigs/{uptime_check_config}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String project;
    private final String uptimeCheckConfig;
    private final String organization;
    private final String folder;

    @Deprecated
    protected UptimeCheckConfigName() {
        this.project = null;
        this.uptimeCheckConfig = null;
        this.organization = null;
        this.folder = null;
    }

    private UptimeCheckConfigName(Builder builder) {
        this.project = Preconditions.checkNotNull(builder.getProject());
        this.uptimeCheckConfig = Preconditions.checkNotNull(builder.getUptimeCheckConfig());
        this.organization = null;
        this.folder = null;
        this.pathTemplate = PROJECT_UPTIME_CHECK_CONFIG;
    }

    private UptimeCheckConfigName(OrganizationUptimeCheckConfigBuilder builder) {
        this.organization = Preconditions.checkNotNull(builder.getOrganization());
        this.uptimeCheckConfig = Preconditions.checkNotNull(builder.getUptimeCheckConfig());
        this.project = null;
        this.folder = null;
        this.pathTemplate = ORGANIZATION_UPTIME_CHECK_CONFIG;
    }

    private UptimeCheckConfigName(FolderUptimeCheckConfigBuilder builder) {
        this.folder = Preconditions.checkNotNull(builder.getFolder());
        this.uptimeCheckConfig = Preconditions.checkNotNull(builder.getUptimeCheckConfig());
        this.project = null;
        this.organization = null;
        this.pathTemplate = FOLDER_UPTIME_CHECK_CONFIG;
    }

    public String getProject() {
        return this.project;
    }

    public String getUptimeCheckConfig() {
        return this.uptimeCheckConfig;
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getFolder() {
        return this.folder;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newProjectUptimeCheckConfigBuilder() {
        return new Builder();
    }

    public static OrganizationUptimeCheckConfigBuilder newOrganizationUptimeCheckConfigBuilder() {
        return new OrganizationUptimeCheckConfigBuilder();
    }

    public static FolderUptimeCheckConfigBuilder newFolderUptimeCheckConfigBuilder() {
        return new FolderUptimeCheckConfigBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static UptimeCheckConfigName of(String project, String uptimeCheckConfig) {
        return UptimeCheckConfigName.newBuilder().setProject(project).setUptimeCheckConfig(uptimeCheckConfig).build();
    }

    public static UptimeCheckConfigName ofProjectUptimeCheckConfigName(String project, String uptimeCheckConfig) {
        return UptimeCheckConfigName.newBuilder().setProject(project).setUptimeCheckConfig(uptimeCheckConfig).build();
    }

    public static UptimeCheckConfigName ofOrganizationUptimeCheckConfigName(String organization, String uptimeCheckConfig) {
        return UptimeCheckConfigName.newOrganizationUptimeCheckConfigBuilder().setOrganization(organization).setUptimeCheckConfig(uptimeCheckConfig).build();
    }

    public static UptimeCheckConfigName ofFolderUptimeCheckConfigName(String folder, String uptimeCheckConfig) {
        return UptimeCheckConfigName.newFolderUptimeCheckConfigBuilder().setFolder(folder).setUptimeCheckConfig(uptimeCheckConfig).build();
    }

    public static String format(String project, String uptimeCheckConfig) {
        return UptimeCheckConfigName.newBuilder().setProject(project).setUptimeCheckConfig(uptimeCheckConfig).build().toString();
    }

    public static String formatProjectUptimeCheckConfigName(String project, String uptimeCheckConfig) {
        return UptimeCheckConfigName.newBuilder().setProject(project).setUptimeCheckConfig(uptimeCheckConfig).build().toString();
    }

    public static String formatOrganizationUptimeCheckConfigName(String organization, String uptimeCheckConfig) {
        return UptimeCheckConfigName.newOrganizationUptimeCheckConfigBuilder().setOrganization(organization).setUptimeCheckConfig(uptimeCheckConfig).build().toString();
    }

    public static String formatFolderUptimeCheckConfigName(String folder, String uptimeCheckConfig) {
        return UptimeCheckConfigName.newFolderUptimeCheckConfigBuilder().setFolder(folder).setUptimeCheckConfig(uptimeCheckConfig).build().toString();
    }

    public static UptimeCheckConfigName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (PROJECT_UPTIME_CHECK_CONFIG.matches(formattedString)) {
            Map<String, String> matchMap = PROJECT_UPTIME_CHECK_CONFIG.match(formattedString);
            return UptimeCheckConfigName.ofProjectUptimeCheckConfigName(matchMap.get("project"), matchMap.get("uptime_check_config"));
        }
        if (ORGANIZATION_UPTIME_CHECK_CONFIG.matches(formattedString)) {
            Map<String, String> matchMap = ORGANIZATION_UPTIME_CHECK_CONFIG.match(formattedString);
            return UptimeCheckConfigName.ofOrganizationUptimeCheckConfigName(matchMap.get("organization"), matchMap.get("uptime_check_config"));
        }
        if (FOLDER_UPTIME_CHECK_CONFIG.matches(formattedString)) {
            Map<String, String> matchMap = FOLDER_UPTIME_CHECK_CONFIG.match(formattedString);
            return UptimeCheckConfigName.ofFolderUptimeCheckConfigName(matchMap.get("folder"), matchMap.get("uptime_check_config"));
        }
        throw new ValidationException("UptimeCheckConfigName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<UptimeCheckConfigName> parseList(List<String> formattedStrings) {
        ArrayList<UptimeCheckConfigName> list = new ArrayList<UptimeCheckConfigName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(UptimeCheckConfigName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<UptimeCheckConfigName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (UptimeCheckConfigName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_UPTIME_CHECK_CONFIG.matches(formattedString) || ORGANIZATION_UPTIME_CHECK_CONFIG.matches(formattedString) || FOLDER_UPTIME_CHECK_CONFIG.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            UptimeCheckConfigName uptimeCheckConfigName = this;
            synchronized (uptimeCheckConfigName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder<String, String> fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put("project", this.project);
                    }
                    if (this.uptimeCheckConfig != null) {
                        fieldMapBuilder.put("uptime_check_config", this.uptimeCheckConfig);
                    }
                    if (this.organization != null) {
                        fieldMapBuilder.put("organization", this.organization);
                    }
                    if (this.folder != null) {
                        fieldMapBuilder.put("folder", this.folder);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    @Override
    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            UptimeCheckConfigName that = (UptimeCheckConfigName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.uptimeCheckConfig, that.uptimeCheckConfig) && Objects.equals(this.organization, that.organization) && Objects.equals(this.folder, that.folder);
        }
        return false;
    }

    public int hashCode() {
        int h2 = 1;
        h2 *= 1000003;
        h2 ^= Objects.hashCode(this.fixedValue);
        h2 *= 1000003;
        h2 ^= Objects.hashCode(this.project);
        h2 *= 1000003;
        h2 ^= Objects.hashCode(this.uptimeCheckConfig);
        h2 *= 1000003;
        h2 ^= Objects.hashCode(this.organization);
        h2 *= 1000003;
        return h2 ^= Objects.hashCode(this.folder);
    }

    public static class FolderUptimeCheckConfigBuilder {
        private String folder;
        private String uptimeCheckConfig;

        protected FolderUptimeCheckConfigBuilder() {
        }

        public String getFolder() {
            return this.folder;
        }

        public String getUptimeCheckConfig() {
            return this.uptimeCheckConfig;
        }

        public FolderUptimeCheckConfigBuilder setFolder(String folder) {
            this.folder = folder;
            return this;
        }

        public FolderUptimeCheckConfigBuilder setUptimeCheckConfig(String uptimeCheckConfig) {
            this.uptimeCheckConfig = uptimeCheckConfig;
            return this;
        }

        public UptimeCheckConfigName build() {
            return new UptimeCheckConfigName(this);
        }
    }

    public static class OrganizationUptimeCheckConfigBuilder {
        private String organization;
        private String uptimeCheckConfig;

        protected OrganizationUptimeCheckConfigBuilder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public String getUptimeCheckConfig() {
            return this.uptimeCheckConfig;
        }

        public OrganizationUptimeCheckConfigBuilder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public OrganizationUptimeCheckConfigBuilder setUptimeCheckConfig(String uptimeCheckConfig) {
            this.uptimeCheckConfig = uptimeCheckConfig;
            return this;
        }

        public UptimeCheckConfigName build() {
            return new UptimeCheckConfigName(this);
        }
    }

    public static class Builder {
        private String project;
        private String uptimeCheckConfig;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getUptimeCheckConfig() {
            return this.uptimeCheckConfig;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setUptimeCheckConfig(String uptimeCheckConfig) {
            this.uptimeCheckConfig = uptimeCheckConfig;
            return this;
        }

        private Builder(UptimeCheckConfigName uptimeCheckConfigName) {
            Preconditions.checkArgument(Objects.equals(uptimeCheckConfigName.pathTemplate, PROJECT_UPTIME_CHECK_CONFIG), "toBuilder is only supported when UptimeCheckConfigName has the pattern of projects/{project}/uptimeCheckConfigs/{uptime_check_config}");
            this.project = uptimeCheckConfigName.project;
            this.uptimeCheckConfig = uptimeCheckConfigName.uptimeCheckConfig;
        }

        public UptimeCheckConfigName build() {
            return new UptimeCheckConfigName(this);
        }
    }
}

